/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.action.closegaps.GapClosingMethod;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.displaysettings.SliderPanelDouble;
import fiji.plugin.trackmate.gui.displaysettings.StyleElements;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CloseGapsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final JComboBox<GapClosingMethod> cmbboxMethod;
    final JButton btnRun;

    public CloseGapsPanel(Collection<GapClosingMethod> gapClosingMethods) {
        HashMap<GapClosingMethod, JPanel> configPanels = new HashMap<GapClosingMethod, JPanel>();
        for (GapClosingMethod gcm : gapClosingMethods) {
            List<GapClosingMethod.GapClosingParameter> params = gcm.getParameters();
            JPanel paramPanel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            paramPanel.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 5, 2, 5);
            for (final GapClosingMethod.GapClosingParameter p : params) {
                c.gridwidth = 1;
                c.anchor = 22;
                JLabel lblParamName = new JLabel(p.name);
                lblParamName.setFont(Fonts.SMALL_FONT);
                paramPanel.add((Component)lblParamName, c);
                StyleElements.BoundedDoubleElement el = new StyleElements.BoundedDoubleElement(p.name, p.minValue, p.maxValue){

                    @Override
                    public double get() {
                        return p.value;
                    }

                    @Override
                    public void set(double v) {
                        p.value = v;
                    }
                };
                SliderPanelDouble slider = StyleElements.linkedSliderPanel(el, 4);
                slider.setDecimalFormat("0.00");
                for (Component cmp : slider.getComponents()) {
                    cmp.setFont(Fonts.SMALL_FONT);
                }
                ++c.gridx;
                c.weightx = 1.0;
                c.anchor = 21;
                paramPanel.add((Component)slider, c);
                c.gridx = 0;
                c.weightx = 0.0;
                ++c.gridy;
            }
            configPanels.put(gcm, paramPanel);
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblTitle = new JLabel("Close gap");
        lblTitle.setFont(Fonts.BIG_FONT);
        lblTitle.setHorizontalAlignment(0);
        GridBagConstraints gbcLblTitle = new GridBagConstraints();
        gbcLblTitle.gridwidth = 2;
        gbcLblTitle.insets = new Insets(0, 0, 5, 0);
        gbcLblTitle.fill = 1;
        gbcLblTitle.gridx = 0;
        gbcLblTitle.gridy = 0;
        this.add((Component)lblTitle, gbcLblTitle);
        JLabel lblDoc = new JLabel("<html>This action proposes several methods to close gaps in tracks.<p>Gaps are part of tracks where spots are missing in one or several consecutive frames. The listed methods can introduce new spots in such gaps, depending on possibly the other spots in tracks and/or the image data.<p>They are useful to fix missed detection when a uninterrupted list of position is required for track analysis. For instance in FRAP experiments, where you need to measure signal intensity changing during time, even if the spot is not visible.</html>");
        lblDoc.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblDoc = new GridBagConstraints();
        gbcLblDoc.fill = 1;
        gbcLblDoc.insets = new Insets(0, 0, 5, 0);
        gbcLblDoc.gridwidth = 2;
        gbcLblDoc.gridx = 0;
        gbcLblDoc.gridy = 1;
        this.add((Component)lblDoc, gbcLblDoc);
        JLabel lblMethod = new JLabel("Gap-closing method");
        lblMethod.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblMethod = new GridBagConstraints();
        gbcLblMethod.anchor = 13;
        gbcLblMethod.insets = new Insets(0, 0, 5, 5);
        gbcLblMethod.gridx = 0;
        gbcLblMethod.gridy = 2;
        this.add((Component)lblMethod, gbcLblMethod);
        this.cmbboxMethod = new JComboBox<GapClosingMethod>(new Vector<GapClosingMethod>(gapClosingMethods));
        this.cmbboxMethod.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcCmbboxMethod = new GridBagConstraints();
        gbcCmbboxMethod.insets = new Insets(0, 0, 5, 0);
        gbcCmbboxMethod.fill = 2;
        gbcCmbboxMethod.gridx = 1;
        gbcCmbboxMethod.gridy = 2;
        this.add(this.cmbboxMethod, gbcCmbboxMethod);
        JPanel panelParams = new JPanel();
        GridBagConstraints gbcPanelParams = new GridBagConstraints();
        gbcPanelParams.gridwidth = 2;
        gbcPanelParams.insets = new Insets(0, 0, 5, 5);
        gbcPanelParams.fill = 1;
        gbcPanelParams.gridx = 0;
        gbcPanelParams.gridy = 3;
        this.add((Component)panelParams, gbcPanelParams);
        panelParams.setLayout(new BorderLayout(0, 0));
        JLabel lblMethodDoc = new JLabel();
        lblMethodDoc.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblMethodDoc = new GridBagConstraints();
        gbcLblMethodDoc.fill = 1;
        gbcLblMethodDoc.insets = new Insets(0, 0, 5, 0);
        gbcLblMethodDoc.gridwidth = 2;
        gbcLblMethodDoc.gridx = 0;
        gbcLblMethodDoc.gridy = 4;
        this.add((Component)lblMethodDoc, gbcLblMethodDoc);
        this.btnRun = new JButton("Run");
        GridBagConstraints gbcBtnRun = new GridBagConstraints();
        gbcBtnRun.anchor = 13;
        gbcBtnRun.gridx = 1;
        gbcBtnRun.gridy = 5;
        this.add((Component)this.btnRun, gbcBtnRun);
        this.cmbboxMethod.addActionListener(e -> {
            panelParams.removeAll();
            GapClosingMethod gcm = (GapClosingMethod)this.cmbboxMethod.getSelectedItem();
            panelParams.add((Component)configPanels.get(gcm), "Center");
            lblMethodDoc.setText(gcm.getInfoText());
        });
        this.cmbboxMethod.setSelectedIndex(0);
    }
}

