/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.edges;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.edges.AbstractEdgeAnalyzer;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

@Plugin(type=EdgeAnalyzer.class)
public class EdgeTimeLocationAnalyzer
extends AbstractEdgeAnalyzer {
    public static final String KEY = "Edge location";
    public static final String TIME = "EDGE_TIME";
    public static final String X_LOCATION = "EDGE_X_LOCATION";
    public static final String Y_LOCATION = "EDGE_Y_LOCATION";
    public static final String Z_LOCATION = "EDGE_Z_LOCATION";
    public static final List<String> FEATURES = new ArrayList<String>(4);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(4);
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(4);
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(4);
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(4);

    public EdgeTimeLocationAnalyzer() {
        super(KEY, KEY, FEATURES, FEATURE_NAMES, FEATURE_SHORT_NAMES, FEATURE_DIMENSIONS, IS_INT);
    }

    @Override
    protected void analyze(DefaultWeightedEdge edge, Model model) {
        FeatureModel featureModel = model.getFeatureModel();
        Spot source = model.getTrackModel().getEdgeSource(edge);
        Spot target = model.getTrackModel().getEdgeTarget(edge);
        double x = 0.5 * (source.getFeature("POSITION_X") + target.getFeature("POSITION_X"));
        double y = 0.5 * (source.getFeature("POSITION_Y") + target.getFeature("POSITION_Y"));
        double z = 0.5 * (source.getFeature("POSITION_Z") + target.getFeature("POSITION_Z"));
        double t = 0.5 * (source.getFeature("POSITION_T") + target.getFeature("POSITION_T"));
        featureModel.putEdgeFeature(edge, TIME, t);
        featureModel.putEdgeFeature(edge, X_LOCATION, x);
        featureModel.putEdgeFeature(edge, Y_LOCATION, y);
        featureModel.putEdgeFeature(edge, Z_LOCATION, z);
    }

    static {
        FEATURES.add(TIME);
        FEATURES.add(X_LOCATION);
        FEATURES.add(Y_LOCATION);
        FEATURES.add(Z_LOCATION);
        FEATURE_NAMES.put(TIME, "Edge time");
        FEATURE_NAMES.put(X_LOCATION, "Edge X");
        FEATURE_NAMES.put(Y_LOCATION, "Edge Y");
        FEATURE_NAMES.put(Z_LOCATION, "Edge Z");
        FEATURE_SHORT_NAMES.put(TIME, "Edge T");
        FEATURE_SHORT_NAMES.put(X_LOCATION, "Edge X");
        FEATURE_SHORT_NAMES.put(Y_LOCATION, "Edge Y");
        FEATURE_SHORT_NAMES.put(Z_LOCATION, "Edge Z");
        FEATURE_DIMENSIONS.put(TIME, Dimension.TIME);
        FEATURE_DIMENSIONS.put(X_LOCATION, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(Y_LOCATION, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(Z_LOCATION, Dimension.POSITION);
        IS_INT.put(TIME, Boolean.FALSE);
        IS_INT.put(X_LOCATION, Boolean.FALSE);
        IS_INT.put(Y_LOCATION, Boolean.FALSE);
        IS_INT.put(Z_LOCATION, Boolean.FALSE);
    }
}

