/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.track;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

@Plugin(type=TrackAnalyzer.class)
public class TrackIndexAnalyzer
implements TrackAnalyzer {
    public static final String KEY = "Track index";
    public static final String TRACK_INDEX = "TRACK_INDEX";
    public static final String TRACK_ID = "TRACK_ID";
    public static final List<String> FEATURES = new ArrayList<String>(2);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(2);
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(2);
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(2);
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(2);
    private long processingTime;

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void process(Collection<Integer> trackIDs, Model model) {
        long start = System.currentTimeMillis();
        FeatureModel fm = model.getFeatureModel();
        int index = 0;
        for (Integer trackID : trackIDs) {
            fm.putTrackFeature(trackID, TRACK_INDEX, Double.valueOf(index++));
            fm.putTrackFeature(trackID, TRACK_ID, (double)trackID);
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<String> getFeatures() {
        return FEATURES;
    }

    @Override
    public Map<String, String> getFeatureShortNames() {
        return FEATURE_SHORT_NAMES;
    }

    @Override
    public Map<String, String> getFeatureNames() {
        return FEATURE_NAMES;
    }

    @Override
    public Map<String, Dimension> getFeatureDimensions() {
        return FEATURE_DIMENSIONS;
    }

    public void setNumThreads() {
    }

    public void setNumThreads(int numThreads) {
    }

    public int getNumThreads() {
        return 1;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return KEY;
    }

    @Override
    public Map<String, Boolean> getIsIntFeature() {
        return IS_INT;
    }

    @Override
    public boolean isManualFeature() {
        return false;
    }

    static {
        FEATURES.add(TRACK_INDEX);
        FEATURES.add(TRACK_ID);
        FEATURE_NAMES.put(TRACK_INDEX, KEY);
        FEATURE_NAMES.put(TRACK_ID, "Track ID");
        FEATURE_SHORT_NAMES.put(TRACK_INDEX, "Index");
        FEATURE_SHORT_NAMES.put(TRACK_ID, "ID");
        FEATURE_DIMENSIONS.put(TRACK_INDEX, Dimension.NONE);
        FEATURE_DIMENSIONS.put(TRACK_ID, Dimension.NONE);
        IS_INT.put(TRACK_INDEX, Boolean.TRUE);
        IS_INT.put(TRACK_ID, Boolean.TRUE);
    }
}

