/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.detector;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class ManualDetectorConfigurationPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat FORMAT = new DecimalFormat("#.##");
    protected final JFormattedTextField ftfDiameter;

    public ManualDetectorConfigurationPanel(String infoText, String detectorName) {
        this.setPreferredSize(new Dimension(300, 461));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
        JLabel jLabelPreTitle = new JLabel();
        GridBagConstraints gbcLabelPreTitle = new GridBagConstraints();
        gbcLabelPreTitle.anchor = 11;
        gbcLabelPreTitle.fill = 2;
        gbcLabelPreTitle.insets = new Insets(5, 5, 5, 5);
        gbcLabelPreTitle.gridwidth = 3;
        gbcLabelPreTitle.gridx = 0;
        gbcLabelPreTitle.gridy = 0;
        this.add((Component)jLabelPreTitle, gbcLabelPreTitle);
        jLabelPreTitle.setText("Settings for detector:");
        jLabelPreTitle.setFont(Fonts.FONT);
        JLabel jLabelSegmenterName = new JLabel();
        GridBagConstraints gbcLabelSegmenterName = new GridBagConstraints();
        gbcLabelSegmenterName.anchor = 11;
        gbcLabelSegmenterName.fill = 2;
        gbcLabelSegmenterName.insets = new Insets(5, 5, 5, 5);
        gbcLabelSegmenterName.gridwidth = 3;
        gbcLabelSegmenterName.gridx = 0;
        gbcLabelSegmenterName.gridy = 1;
        this.add((Component)jLabelSegmenterName, gbcLabelSegmenterName);
        jLabelSegmenterName.setFont(Fonts.BIG_FONT);
        jLabelSegmenterName.setText(detectorName);
        JLabel jLabelHelpText = new JLabel();
        GridBagConstraints gbcLabelHelpText = new GridBagConstraints();
        gbcLabelHelpText.fill = 1;
        gbcLabelHelpText.insets = new Insets(5, 5, 5, 5);
        gbcLabelHelpText.gridwidth = 3;
        gbcLabelHelpText.gridx = 0;
        gbcLabelHelpText.gridy = 2;
        this.add((Component)jLabelHelpText, gbcLabelHelpText);
        jLabelHelpText.setFont(Fonts.FONT.deriveFont(2));
        jLabelHelpText.setText(infoText.replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">"));
        JLabel jLabelEstimDiameter = new JLabel();
        GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
        gbc_jLabel2.anchor = 13;
        gbc_jLabel2.insets = new Insets(5, 5, 5, 5);
        gbc_jLabel2.gridx = 0;
        gbc_jLabel2.gridy = 3;
        this.add((Component)jLabelEstimDiameter, gbc_jLabel2);
        jLabelEstimDiameter.setText("Spot diameter to use:");
        jLabelEstimDiameter.setFont(Fonts.SMALL_FONT);
        this.ftfDiameter = new JFormattedTextField(FORMAT);
        this.ftfDiameter.setValue(10.0);
        this.ftfDiameter.setHorizontalAlignment(0);
        GridBagConstraints gbcTextFieldBlobDiameter = new GridBagConstraints();
        gbcTextFieldBlobDiameter.anchor = 15;
        gbcTextFieldBlobDiameter.fill = 2;
        gbcTextFieldBlobDiameter.insets = new Insets(5, 5, 5, 5);
        gbcTextFieldBlobDiameter.gridx = 1;
        gbcTextFieldBlobDiameter.gridy = 3;
        this.add((Component)this.ftfDiameter, gbcTextFieldBlobDiameter);
        this.ftfDiameter.setFont(Fonts.SMALL_FONT);
        JLabel jLabelBlobDiameterUnit = new JLabel();
        GridBagConstraints gbcLabelBlobDiameterUnit = new GridBagConstraints();
        gbcLabelBlobDiameterUnit.anchor = 17;
        gbcLabelBlobDiameterUnit.fill = 3;
        gbcLabelBlobDiameterUnit.insets = new Insets(5, 5, 5, 5);
        gbcLabelBlobDiameterUnit.gridx = 2;
        gbcLabelBlobDiameterUnit.gridy = 3;
        this.add((Component)jLabelBlobDiameterUnit, gbcLabelBlobDiameterUnit);
        jLabelBlobDiameterUnit.setFont(Fonts.SMALL_FONT);
        jLabelBlobDiameterUnit.setText("pixels");
        JLabel lblSpacer = new JLabel("   ");
        GridBagConstraints gbc_lblSpacer = new GridBagConstraints();
        gbc_lblSpacer.gridwidth = 3;
        gbc_lblSpacer.insets = new Insets(5, 5, 5, 5);
        gbc_lblSpacer.gridx = 0;
        gbc_lblSpacer.gridy = 4;
        this.add((Component)lblSpacer, gbc_lblSpacer);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(1);
        settings.put("RADIUS", ((Number)this.ftfDiameter.getValue()).doubleValue());
        return settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.ftfDiameter.setValue((Double)Optional.ofNullable(settings.get("RADIUS")).orElse(5.0) * 2.0);
    }

    @Override
    public void clean() {
    }
}

