/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.tracker.JPanelFeatureSelectionGui;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelTrackerSettingsMain
extends JPanel {
    private static final long serialVersionUID = -1L;
    private final JLabel lblSplittingMaxDistanceUnit;
    private final JFormattedTextField txtfldSplittingMaxDistance;
    private final JCheckBox chkboxAllowSplitting;
    private final JPanelFeatureSelectionGui panelGapClosing;
    private final JPanelFeatureSelectionGui panelMergingFeatures;
    private final JPanelFeatureSelectionGui panelLinkingFeatures;
    private final JPanelFeatureSelectionGui panelSplittingFeatures;
    private final JScrollPane scrpneMergingFeatures;
    private final JLabel lblMergingMaxDistanceUnit;
    private final JFormattedTextField txtfldMergingMaxDistance;
    private final JCheckBox chkboxAllowMerging;
    private final JScrollPane scrpneSplittingFeatures;
    private final JScrollPane scrpneGapClosingFeatures;
    private final JFormattedTextField txtfldGapClosingMaxFrameInterval;
    private final JLabel lblGapClosingMaxDistanceUnit;
    private final JFormattedTextField txtfldGapClosingMaxDistance;
    private final JCheckBox chkboxAllowGapClosing;
    private final JLabel lblLinkingMaxDistanceUnits;
    private final JFormattedTextField txtfldLinkingMaxDistance;
    private final JLabel lbl6;
    private final JLabel lbl7;
    private final JLabel lbl8;
    private final JLabel lbl10;
    private final JLabel lbl15;
    private final JLabel lbl13;
    private final JLabel lbl16;

    public JPanelTrackerSettingsMain(String trackerName, String spaceUnits, Collection<String> features, Map<String, String> featureNames) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        this.setPreferredSize(new Dimension(280, 1000));
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.columnWidths = new int[]{180, 50, 50};
        thisLayout.columnWeights = new double[]{0.1, 0.8, 0.1};
        thisLayout.rowHeights = new int[]{15, 20, 0, 15, 10, 15, 95, 15, 15, 15, 15, 15, 95, 15, 15, 15, 15, 15, 95, 15, 15, 15, 15, 15, 95};
        thisLayout.rowWeights = new double[]{0.0, 0.1, 0.25, 0.1, 0.0, 0.0, 0.25, 0.1, 0.0, 0.0, 0.0, 0.0, 0.25, 0.1, 0.0, 0.0, 0.0, 0.0, 0.25, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(thisLayout);
        JLabel jLabel1 = new JLabel();
        this.add((Component)jLabel1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        jLabel1.setText("Settings for tracker:");
        jLabel1.setFont(Fonts.FONT);
        JLabel lblTrackerName = new JLabel();
        this.add((Component)lblTrackerName, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 21, 0, new Insets(10, 20, 0, 0), 0, 0));
        lblTrackerName.setHorizontalTextPosition(0);
        lblTrackerName.setHorizontalAlignment(0);
        lblTrackerName.setFont(Fonts.BIG_FONT);
        lblTrackerName.setText(trackerName);
        JLabel lbl2 = new JLabel();
        this.add((Component)lbl2, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl2.setText("Frame to frame linking:");
        lbl2.setFont(Fonts.BIG_FONT.deriveFont(1));
        JLabel lbl3 = new JLabel();
        this.add((Component)lbl3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl3.setText("Max distance:");
        lbl3.setFont(Fonts.SMALL_FONT);
        this.txtfldLinkingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldLinkingMaxDistance, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldLinkingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldLinkingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldLinkingMaxDistance.setHorizontalAlignment(0);
        this.lblLinkingMaxDistanceUnits = new JLabel();
        this.add((Component)this.lblLinkingMaxDistanceUnits, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblLinkingMaxDistanceUnits.setFont(Fonts.SMALL_FONT);
        this.lblLinkingMaxDistanceUnits.setText(spaceUnits);
        JLabel lbl4 = new JLabel();
        this.add((Component)lbl4, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl4.setText("Feature penalties");
        lbl4.setFont(Fonts.SMALL_FONT);
        JScrollPane scrpneLinkingFeatures = new JScrollPane();
        MouseWheelListener[] l = scrpneLinkingFeatures.getMouseWheelListeners();
        scrpneLinkingFeatures.removeMouseWheelListener(l[0]);
        this.add((Component)scrpneLinkingFeatures, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        scrpneLinkingFeatures.setHorizontalScrollBarPolicy(31);
        scrpneLinkingFeatures.setVerticalScrollBarPolicy(22);
        this.panelLinkingFeatures = new JPanelFeatureSelectionGui();
        this.panelLinkingFeatures.setDisplayFeatures(features, featureNames);
        scrpneLinkingFeatures.setViewportView(this.panelLinkingFeatures);
        JLabel lbl5 = new JLabel();
        this.add((Component)lbl5, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        lbl5.setText("Track segment gap closing:");
        lbl5.setFont(Fonts.BIG_FONT.deriveFont(1));
        this.chkboxAllowGapClosing = new JCheckBox();
        this.add((Component)this.chkboxAllowGapClosing, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.chkboxAllowGapClosing.setText("Allow gap closing");
        this.chkboxAllowGapClosing.setFont(Fonts.SMALL_FONT);
        this.lbl6 = new JLabel();
        this.add((Component)this.lbl6, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl6.setText("Max distance:");
        this.lbl6.setFont(Fonts.SMALL_FONT);
        this.txtfldGapClosingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldGapClosingMaxDistance, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldGapClosingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldGapClosingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldGapClosingMaxDistance.setHorizontalAlignment(0);
        this.lblGapClosingMaxDistanceUnit = new JLabel();
        this.add((Component)this.lblGapClosingMaxDistanceUnit, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblGapClosingMaxDistanceUnit.setFont(Fonts.SMALL_FONT);
        this.lblGapClosingMaxDistanceUnit.setText(spaceUnits);
        this.lbl7 = new JLabel();
        this.add((Component)this.lbl7, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl7.setText("Max frame gap:");
        this.lbl7.setFont(Fonts.SMALL_FONT);
        this.txtfldGapClosingMaxFrameInterval = new JFormattedTextField((Object)2);
        this.add((Component)this.txtfldGapClosingMaxFrameInterval, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldGapClosingMaxFrameInterval.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldGapClosingMaxFrameInterval.setFont(Fonts.SMALL_FONT);
        this.txtfldGapClosingMaxFrameInterval.setHorizontalAlignment(0);
        this.lbl8 = new JLabel();
        this.add((Component)this.lbl8, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl8.setText("Feature penalties:");
        this.lbl8.setFont(Fonts.SMALL_FONT);
        this.scrpneGapClosingFeatures = new JScrollPane();
        MouseWheelListener[] l1 = this.scrpneGapClosingFeatures.getMouseWheelListeners();
        this.scrpneGapClosingFeatures.removeMouseWheelListener(l1[0]);
        this.add((Component)this.scrpneGapClosingFeatures, new GridBagConstraints(0, 12, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrpneGapClosingFeatures.setHorizontalScrollBarPolicy(31);
        this.scrpneGapClosingFeatures.setVerticalScrollBarPolicy(22);
        this.panelGapClosing = new JPanelFeatureSelectionGui();
        this.panelGapClosing.setDisplayFeatures(features, featureNames);
        this.scrpneGapClosingFeatures.setViewportView(this.panelGapClosing);
        JLabel lbl9 = new JLabel();
        this.add((Component)lbl9, new GridBagConstraints(0, 13, 3, 1, 0.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        lbl9.setText("Track segment splitting:");
        lbl9.setFont(Fonts.BIG_FONT.deriveFont(1));
        this.chkboxAllowSplitting = new JCheckBox();
        this.add((Component)this.chkboxAllowSplitting, new GridBagConstraints(0, 14, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.chkboxAllowSplitting.setText("Allow track segment splitting");
        this.chkboxAllowSplitting.setFont(Fonts.SMALL_FONT);
        this.lbl10 = new JLabel();
        this.add((Component)this.lbl10, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lbl10.setText("Max distance:");
        this.lbl10.setFont(Fonts.SMALL_FONT);
        this.txtfldSplittingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldSplittingMaxDistance, new GridBagConstraints(1, 15, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldSplittingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldSplittingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldSplittingMaxDistance.setHorizontalAlignment(0);
        this.lblSplittingMaxDistanceUnit = new JLabel();
        this.add((Component)this.lblSplittingMaxDistanceUnit, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblSplittingMaxDistanceUnit.setFont(Fonts.SMALL_FONT);
        this.lblSplittingMaxDistanceUnit.setText(spaceUnits);
        this.lbl15 = new JLabel();
        this.add((Component)this.lbl15, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl15.setText("Feature penalties:");
        this.lbl15.setFont(Fonts.SMALL_FONT);
        this.scrpneSplittingFeatures = new JScrollPane();
        MouseWheelListener[] l2 = this.scrpneSplittingFeatures.getMouseWheelListeners();
        this.scrpneSplittingFeatures.removeMouseWheelListener(l2[0]);
        this.add((Component)this.scrpneSplittingFeatures, new GridBagConstraints(0, 18, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrpneSplittingFeatures.setHorizontalScrollBarPolicy(31);
        this.scrpneSplittingFeatures.setVerticalScrollBarPolicy(22);
        this.panelSplittingFeatures = new JPanelFeatureSelectionGui();
        this.panelSplittingFeatures.setDisplayFeatures(features, featureNames);
        this.scrpneSplittingFeatures.setViewportView(this.panelSplittingFeatures);
        JLabel lbl12 = new JLabel();
        this.add((Component)lbl12, new GridBagConstraints(0, 19, 3, 1, 0.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        lbl12.setText("Track segment merging:");
        lbl12.setFont(Fonts.BIG_FONT.deriveFont(1));
        this.chkboxAllowMerging = new JCheckBox();
        this.add((Component)this.chkboxAllowMerging, new GridBagConstraints(0, 20, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.chkboxAllowMerging.setText("Allow track segment merging");
        this.chkboxAllowMerging.setFont(Fonts.SMALL_FONT);
        this.lbl13 = new JLabel();
        this.add((Component)this.lbl13, new GridBagConstraints(0, 21, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lbl13.setText("Max distance:");
        this.lbl13.setFont(Fonts.SMALL_FONT);
        this.txtfldMergingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldMergingMaxDistance, new GridBagConstraints(1, 21, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldMergingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldMergingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldMergingMaxDistance.setHorizontalAlignment(0);
        this.lblMergingMaxDistanceUnit = new JLabel();
        this.add((Component)this.lblMergingMaxDistanceUnit, new GridBagConstraints(2, 21, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblMergingMaxDistanceUnit.setFont(Fonts.SMALL_FONT);
        this.lblMergingMaxDistanceUnit.setText(spaceUnits);
        this.lbl16 = new JLabel();
        this.add((Component)this.lbl16, new GridBagConstraints(0, 23, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl16.setText("Feature penalties:");
        this.lbl16.setFont(Fonts.SMALL_FONT);
        this.scrpneMergingFeatures = new JScrollPane();
        MouseWheelListener[] l3 = this.scrpneMergingFeatures.getMouseWheelListeners();
        this.scrpneMergingFeatures.removeMouseWheelListener(l3[0]);
        this.add((Component)this.scrpneMergingFeatures, new GridBagConstraints(0, 24, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrpneMergingFeatures.setHorizontalScrollBarPolicy(31);
        this.scrpneMergingFeatures.setVerticalScrollBarPolicy(22);
        this.panelMergingFeatures = new JPanelFeatureSelectionGui();
        this.panelMergingFeatures.setDisplayFeatures(features, featureNames);
        this.scrpneMergingFeatures.setViewportView(this.panelMergingFeatures);
        GuiUtils.selectAllOnFocus(this.txtfldGapClosingMaxDistance);
        GuiUtils.selectAllOnFocus(this.txtfldGapClosingMaxFrameInterval);
        GuiUtils.selectAllOnFocus(this.txtfldLinkingMaxDistance);
        GuiUtils.selectAllOnFocus(this.txtfldMergingMaxDistance);
        GuiUtils.selectAllOnFocus(this.txtfldSplittingMaxDistance);
        this.chkboxAllowGapClosing.addActionListener(e -> this.setEnabled(new Component[]{this.lbl6, this.txtfldGapClosingMaxDistance, this.lblGapClosingMaxDistanceUnit, this.lbl7, this.txtfldGapClosingMaxFrameInterval, this.txtfldGapClosingMaxFrameInterval, this.lbl8, this.scrpneGapClosingFeatures, this.panelGapClosing}, this.chkboxAllowGapClosing.isSelected()));
        this.chkboxAllowSplitting.addActionListener(e -> this.setEnabled(new Component[]{this.lbl10, this.txtfldSplittingMaxDistance, this.lblSplittingMaxDistanceUnit, this.lbl15, this.scrpneSplittingFeatures, this.panelSplittingFeatures}, this.chkboxAllowSplitting.isSelected()));
        this.chkboxAllowMerging.addActionListener(e -> this.setEnabled(new Component[]{this.lbl13, this.txtfldMergingMaxDistance, this.lblMergingMaxDistanceUnit, this.lbl16, this.scrpneMergingFeatures, this.panelMergingFeatures}, this.chkboxAllowMerging.isSelected()));
    }

    void echoSettings(Map<String, Object> settings) {
        this.txtfldLinkingMaxDistance.setValue(settings.get("LINKING_MAX_DISTANCE"));
        this.panelLinkingFeatures.setSelectedFeaturePenalties((Map)settings.get("LINKING_FEATURE_PENALTIES"));
        this.chkboxAllowGapClosing.setSelected((Boolean)settings.get("ALLOW_GAP_CLOSING"));
        this.txtfldGapClosingMaxDistance.setValue(settings.get("GAP_CLOSING_MAX_DISTANCE"));
        this.txtfldGapClosingMaxFrameInterval.setValue(settings.get("MAX_FRAME_GAP"));
        this.panelGapClosing.setSelectedFeaturePenalties((Map)settings.get("GAP_CLOSING_FEATURE_PENALTIES"));
        this.chkboxAllowSplitting.setSelected((Boolean)settings.get("ALLOW_TRACK_SPLITTING"));
        this.txtfldSplittingMaxDistance.setValue(settings.get("SPLITTING_MAX_DISTANCE"));
        this.panelSplittingFeatures.setSelectedFeaturePenalties((Map)settings.get("SPLITTING_FEATURE_PENALTIES"));
        this.chkboxAllowMerging.setSelected((Boolean)settings.get("ALLOW_TRACK_MERGING"));
        this.txtfldMergingMaxDistance.setValue(settings.get("MERGING_MAX_DISTANCE"));
        this.panelMergingFeatures.setSelectedFeaturePenalties((Map)settings.get("MERGING_FEATURE_PENALTIES"));
        this.setEnabled(new Component[]{this.lbl6, this.txtfldGapClosingMaxDistance, this.lblGapClosingMaxDistanceUnit, this.lbl7, this.txtfldGapClosingMaxFrameInterval, this.txtfldGapClosingMaxFrameInterval, this.lbl8, this.scrpneGapClosingFeatures, this.panelGapClosing}, this.chkboxAllowGapClosing.isSelected());
        this.setEnabled(new Component[]{this.lbl10, this.txtfldSplittingMaxDistance, this.lblSplittingMaxDistanceUnit, this.lbl15, this.scrpneSplittingFeatures, this.panelSplittingFeatures}, this.chkboxAllowSplitting.isSelected());
        this.setEnabled(new Component[]{this.lbl13, this.txtfldMergingMaxDistance, this.lblMergingMaxDistanceUnit, this.lbl16, this.scrpneMergingFeatures, this.panelMergingFeatures}, this.chkboxAllowMerging.isSelected());
    }

    public Map<String, Object> getSettings() {
        Map<String, Object> settings = JPanelTrackerSettingsMain.getDefaultLAPSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.txtfldLinkingMaxDistance.getValue()).doubleValue());
        settings.put("LINKING_FEATURE_PENALTIES", this.panelLinkingFeatures.getFeaturePenalties());
        settings.put("ALLOW_GAP_CLOSING", this.chkboxAllowGapClosing.isSelected());
        settings.put("GAP_CLOSING_MAX_DISTANCE", ((Number)this.txtfldGapClosingMaxDistance.getValue()).doubleValue());
        settings.put("MAX_FRAME_GAP", ((Number)this.txtfldGapClosingMaxFrameInterval.getValue()).intValue());
        settings.put("GAP_CLOSING_FEATURE_PENALTIES", this.panelGapClosing.getFeaturePenalties());
        settings.put("ALLOW_TRACK_SPLITTING", this.chkboxAllowSplitting.isSelected());
        settings.put("SPLITTING_MAX_DISTANCE", ((Number)this.txtfldSplittingMaxDistance.getValue()).doubleValue());
        settings.put("SPLITTING_FEATURE_PENALTIES", this.panelSplittingFeatures.getFeaturePenalties());
        settings.put("ALLOW_TRACK_MERGING", this.chkboxAllowMerging.isSelected());
        settings.put("MERGING_MAX_DISTANCE", ((Number)this.txtfldMergingMaxDistance.getValue()).doubleValue());
        settings.put("MERGING_FEATURE_PENALTIES", this.panelMergingFeatures.getFeaturePenalties());
        return settings;
    }

    public static final Map<String, Object> getDefaultLAPSettingsMap() {
        Map<String, Object> settings = LAPUtils.getDefaultSegmentSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", 15.0);
        settings.put("LINKING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_LINKING_FEATURE_PENALTIES));
        return settings;
    }

    private void setEnabled(Component[] components, boolean enable) {
        for (Component component : components) {
            component.setEnabled(enable);
        }
    }
}

