/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.gui.displaysettings.BoundedValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel
implements BoundedValue.UpdateListener {
    private static final long serialVersionUID = 6444334522127424416L;
    public static final Dimension PANEL_SIZE = new Dimension(150, 20);
    private final JSlider slider;
    private final JSpinner spinner;
    private final BoundedValue model;

    public SliderPanel(String name, final BoundedValue model, final int spinnerStepSize) {
        this.setLayout(new BorderLayout(10, 10));
        this.setPreferredSize(PANEL_SIZE);
        this.slider = new JSlider(0, model.getRangeMin(), model.getRangeMax(), model.getCurrentValue());
        this.spinner = new JSpinner();
        this.spinner.setModel(new SpinnerNumberModel(model.getCurrentValue(), model.getRangeMin(), model.getRangeMax(), spinnerStepSize));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = SliderPanel.this.slider.getValue();
                model.setCurrentValue(value);
            }
        });
        MouseWheelListener mwl = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                int value = SliderPanel.this.slider.getValue();
                if ((value -= notches * spinnerStepSize) < SliderPanel.this.slider.getMinimum()) {
                    value = SliderPanel.this.slider.getMinimum();
                } else if (value > SliderPanel.this.slider.getMaximum()) {
                    value = SliderPanel.this.slider.getMaximum();
                }
                SliderPanel.this.slider.setValue(value);
            }
        };
        this.slider.addMouseWheelListener(mwl);
        this.spinner.addMouseWheelListener(mwl);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = (Integer)SliderPanel.this.spinner.getValue();
                model.setCurrentValue(value);
            }
        });
        if (name != null) {
            JLabel label = new JLabel(name, 0);
            label.setAlignmentX(0.5f);
            this.add((Component)label, "West");
        }
        this.add((Component)this.slider, "Center");
        this.add((Component)this.spinner, "East");
        this.model = model;
        model.setUpdateListener(this);
    }

    public void setNumColummns(int cols) {
        ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField().setColumns(cols);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.spinner != null) {
            this.spinner.setFont(font);
        }
        if (this.slider != null) {
            this.slider.setFont(font);
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.spinner != null) {
            this.spinner.setToolTipText(text);
        }
        if (this.slider != null) {
            this.slider.setToolTipText(text);
        }
    }

    @Override
    public void update() {
        int value = this.model.getCurrentValue();
        int min = this.model.getRangeMin();
        int max = this.model.getRangeMax();
        if (this.slider.getMaximum() != max || this.slider.getMinimum() != min) {
            this.slider.setMinimum(min);
            this.slider.setMaximum(max);
            SpinnerNumberModel spinnerModel = (SpinnerNumberModel)this.spinner.getModel();
            spinnerModel.setMinimum(Integer.valueOf(min));
            spinnerModel.setMaximum(Integer.valueOf(max));
        }
        this.slider.setValue(value);
        this.spinner.setValue(value);
    }
}

