/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.CategoryJComboBox;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.displaysettings.BoundedValue;
import fiji.plugin.trackmate.gui.displaysettings.BoundedValueDouble;
import fiji.plugin.trackmate.gui.displaysettings.ColorIcon;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.SliderPanel;
import fiji.plugin.trackmate.gui.displaysettings.SliderPanelDouble;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.drjekyll.fontchooser.FontDialog;

public class StyleElements {
    private static final DecimalFormat format = new DecimalFormat("#.###");

    public static Separator separator() {
        return new Separator();
    }

    public static LabelElement label(String label) {
        return new LabelElement(label);
    }

    public static StringElement stringElement(String label, final Supplier<String> get, final Consumer<String> set) {
        return new StringElement(label){

            @Override
            public String get() {
                return (String)get.get();
            }

            @Override
            public void set(String s) {
                set.accept(s);
            }
        };
    }

    public static BooleanElement booleanElement(String label, final BooleanSupplier get, final Consumer<Boolean> set) {
        return new BooleanElement(label){

            @Override
            public boolean get() {
                return get.getAsBoolean();
            }

            @Override
            public void set(boolean b) {
                set.accept(b);
            }
        };
    }

    public static ColorElement colorElement(String label, final Supplier<Color> get, final Consumer<Color> set) {
        return new ColorElement(label){

            @Override
            public Color getColor() {
                return (Color)get.get();
            }

            @Override
            public void setColor(Color c) {
                set.accept(c);
            }
        };
    }

    public static ColormapElement colormapElement(String label, final Supplier<Colormap> get, final Consumer<Colormap> set) {
        return new ColormapElement(label){

            @Override
            public Colormap get() {
                return (Colormap)get.get();
            }

            @Override
            public void set(Colormap v) {
                set.accept(v);
            }
        };
    }

    public static BoundedDoubleElement boundedDoubleElement(String label, double rangeMin, double rangeMax, final DoubleSupplier get, final Consumer<Double> set) {
        return new BoundedDoubleElement(label, rangeMin, rangeMax){

            @Override
            public double get() {
                return get.getAsDouble();
            }

            @Override
            public void set(double v) {
                set.accept(v);
            }
        };
    }

    public static DoubleElement doubleElement(String label, final DoubleSupplier get, final Consumer<Double> set) {
        return new DoubleElement(label){

            @Override
            public double get() {
                return get.getAsDouble();
            }

            @Override
            public void set(double v) {
                set.accept(v);
            }
        };
    }

    public static IntElement intElement(String label, int rangeMin, int rangeMax, final IntSupplier get, final Consumer<Integer> set) {
        return new IntElement(label, rangeMin, rangeMax){

            @Override
            public int get() {
                return get.getAsInt();
            }

            @Override
            public void set(int v) {
                set.accept(v);
            }
        };
    }

    public static <E> EnumElement<E> enumElement(String label, E[] values, final Supplier<E> get, final Consumer<E> set) {
        return new EnumElement<E>(label, values){

            @Override
            public E getValue() {
                return get.get();
            }

            @Override
            public void setValue(E e) {
                set.accept(e);
            }
        };
    }

    public static <E> ListElement<E> listElement(String label, List<E> values, final Supplier<E> get, final Consumer<E> set) {
        return new ListElement<E>(label, values){

            @Override
            public E getValue() {
                return get.get();
            }

            @Override
            public void setValue(E e) {
                set.accept(e);
            }
        };
    }

    public static FeatureElement featureElement(String label, final Supplier<DisplaySettings.TrackMateObject> typeGet, final Supplier<String> featureGet, final BiConsumer<DisplaySettings.TrackMateObject, String> set) {
        return new FeatureElement(label){

            @Override
            public void setValue(DisplaySettings.TrackMateObject type, String feature) {
                set.accept(type, feature);
            }

            @Override
            public DisplaySettings.TrackMateObject getType() {
                return (DisplaySettings.TrackMateObject)((Object)typeGet.get());
            }

            @Override
            public String getFeature() {
                return (String)featureGet.get();
            }
        };
    }

    public static FontElement fontElement(String label, final Supplier<Font> get, final Consumer<Font> set) {
        return new FontElement(label){

            @Override
            public void set(Font font) {
                set.accept(font);
            }

            @Override
            public Font get() {
                return (Font)get.get();
            }
        };
    }

    public static JLabel linkedLabel(LabelElement element) {
        return new JLabel(element.getLabel());
    }

    public static CategoryJComboBox<DisplaySettings.TrackMateObject, String> linkedFeatureSelector(FeatureElement element) {
        Settings settings = new Settings();
        settings.addAllAnalyzers();
        CategoryJComboBox<DisplaySettings.TrackMateObject, String> selector = FeatureDisplaySelector.createComboBoxSelector(null, settings);
        selector.setSelectedItem(element.getFeature());
        selector.addActionListener(e -> element.setValue((DisplaySettings.TrackMateObject)((Object)((Object)selector.getSelectedCategory())), (String)selector.getSelectedItem()));
        element.onSet((type, feature) -> {
            if (!feature.equals(selector.getSelectedItem())) {
                selector.setSelectedItem(feature);
            }
        });
        return selector;
    }

    public static JComboBox<Colormap> linkedColormapChooser(ColormapElement element) {
        JComboBox<Colormap> cb = new JComboBox<Colormap>(Colormap.getAvailableLUTs().toArray(new Colormap[0]));
        cb.setRenderer(new ColormapRenderer());
        cb.setSelectedItem(element.get());
        cb.addActionListener(e -> element.set((Colormap)cb.getSelectedItem()));
        element.onSet(cm -> {
            if (cm != cb.getSelectedItem()) {
                cb.setSelectedItem(cm);
            }
        });
        return cb;
    }

    public static JCheckBox linkedCheckBox(BooleanElement element, String label) {
        JCheckBox checkbox = new JCheckBox(label, element.get());
        checkbox.addActionListener(e -> element.set(checkbox.isSelected()));
        element.onSet(b -> {
            if (b.booleanValue() != checkbox.isSelected()) {
                checkbox.setSelected((boolean)b);
            }
        });
        return checkbox;
    }

    public static JButton linkedColorButton(final ColorElement element, final JColorChooser colorChooser) {
        final ColorIcon icon = new ColorIcon(element.getColor(), 16, 0);
        final JButton button = new JButton(icon);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setFont(new JButton().getFont());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(new EmptyBorder(2, 5, 2, 2));
        button.setHorizontalAlignment(2);
        button.addActionListener(e -> {
            colorChooser.setColor(element.getColor());
            JDialog d = JColorChooser.createDialog(button, "Choose a color", true, colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Color c = colorChooser.getColor();
                    if (c != null) {
                        icon.setColor(c);
                        button.repaint();
                        element.setColor(c);
                    }
                }
            }, null);
            d.setVisible(true);
        });
        element.onSet(icon::setColor);
        return button;
    }

    public static SliderPanel linkedSliderPanel(IntElement element, int tfCols) {
        SliderPanel slider = new SliderPanel(null, element.getValue(), 1);
        slider.setNumColummns(tfCols);
        slider.setBorder(new EmptyBorder(0, 0, 0, 0));
        return slider;
    }

    public static JSpinner linkedSpinner(IntElement element) {
        BoundedValue value = element.getValue();
        SpinnerNumberModel model = new SpinnerNumberModel(element.get(), value.getRangeMin(), value.getRangeMax(), 1);
        JSpinner spinner = new JSpinner(model);
        spinner.setMaximumSize(new Dimension(80, spinner.getMaximumSize().height));
        model.addChangeListener(e -> element.set(((Number)model.getValue()).intValue()));
        return spinner;
    }

    public static SliderPanelDouble linkedSliderPanel(BoundedDoubleElement element, int tfCols) {
        return StyleElements.linkedSliderPanel(element, tfCols, 1.0);
    }

    public static SliderPanelDouble linkedSliderPanel(BoundedDoubleElement element, int tfCols, double stepSize) {
        SliderPanelDouble slider = new SliderPanelDouble(null, element.getValue(), stepSize);
        slider.setDecimalFormat("0.####");
        slider.setNumColummns(tfCols);
        slider.setBorder(new EmptyBorder(0, 0, 0, 0));
        return slider;
    }

    public static <E> JSpinner linkedSpinnerEnumSelector(EnumElement<E> element) {
        SpinnerListModel model = new SpinnerListModel(element.getValues());
        JSpinner spinner = new JSpinner(model);
        spinner.setFont(Fonts.SMALL_FONT);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setEditable(false);
        model.setValue(element.getValue());
        model.addChangeListener(e -> element.setValue(model.getValue()));
        element.onSet(e -> {
            if (e != model.getValue()) {
                model.setValue(e);
            }
        });
        return spinner;
    }

    public static <E> JComboBox<E> linkedComboBoxEnumSelector(EnumElement<E> element) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(((EnumElement)element).values);
        JComboBox<Object> cb = new JComboBox<Object>(model);
        cb.setFont(Fonts.SMALL_FONT);
        cb.addActionListener(e -> element.setValue(model.getSelectedItem()));
        element.onSet(e -> {
            if (e != model.getSelectedItem()) {
                model.setSelectedItem(e);
            }
        });
        return cb;
    }

    public static <E> JComboBox<E> linkedComboBoxSelector(ListElement<E> element) {
        DefaultComboBoxModel model = new DefaultComboBoxModel(new Vector(((ListElement)element).values));
        JComboBox cb = new JComboBox(model);
        cb.setFont(Fonts.SMALL_FONT);
        cb.addActionListener(e -> element.setValue(model.getSelectedItem()));
        element.onSet(e -> {
            if (e != model.getSelectedItem()) {
                model.setSelectedItem(e);
            }
        });
        return cb;
    }

    public static JFormattedTextField linkedFormattedTextField(final DoubleElement element) {
        final JFormattedTextField ftf = new JFormattedTextField(format);
        ftf.setHorizontalAlignment(4);
        ftf.setValue(element.get());
        ftf.addActionListener(e -> element.set(((Number)ftf.getValue()).doubleValue()));
        ftf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ftf.commitEdit();
                    element.set(((Number)ftf.getValue()).doubleValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        GuiUtils.selectAllOnFocus(ftf);
        element.onSet(d -> {
            if (d.doubleValue() != ((Number)ftf.getValue()).doubleValue()) {
                ftf.setValue(element.value);
            }
        });
        return ftf;
    }

    public static JTextField linkedTextField(final StringElement element) {
        final JTextField tf = new JTextField(element.get());
        tf.setHorizontalAlignment(2);
        tf.addActionListener(e -> element.set(tf.getText()));
        GuiUtils.selectAllOnFocus(tf);
        tf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                element.set(tf.getText());
            }
        });
        element.onSet(d -> {
            if (d != tf.getText()) {
                tf.setText(element.value);
            }
        });
        return tf;
    }

    public static JButton linkedFontButton(FontElement element, Window parent) {
        JButton btn = new JButton("Select font");
        btn.setFont(element.get());
        btn.addPropertyChangeListener("font", e -> element.set(btn.getFont()));
        element.onSet(font -> {
            if (!font.equals(btn.getFont())) {
                btn.setFont((Font)font);
            }
        });
        btn.addActionListener(e -> {
            FontDialog dialog = new FontDialog(parent, "Select font for TrackMate display", Dialog.ModalityType.APPLICATION_MODAL);
            dialog.setDefaultCloseOperation(2);
            dialog.setSelectedFont(btn.getFont());
            GuiUtils.positionWindow((Window)dialog, parent);
            dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
            dialog.setVisible(true);
            if (!dialog.isCancelSelected()) {
                btn.setFont(dialog.getSelectedFont());
            }
        });
        return btn;
    }

    private static final class ColormapRenderer
    extends JPanel
    implements ListCellRenderer<Colormap> {
        private static final long serialVersionUID = 1L;
        private Colormap lut = Colormap.Jet;
        private final DefaultListCellRenderer lbl;

        public ColormapRenderer() {
            this.setPreferredSize(new Dimension(150, 20));
            BoxLayout itemlayout = new BoxLayout(this, 2);
            this.lbl = new DefaultListCellRenderer();
            this.setLayout(itemlayout);
            this.add(this.lbl);
            this.add(Box.createHorizontalGlue());
            this.add(new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    for (int i = 0; i < width; ++i) {
                        double beta = (double)i / (double)(width - 1);
                        g.setColor(lut.getPaint(beta));
                        g.drawLine(i, 0, i, height);
                    }
                    g.setColor(this.getParent().getBackground());
                    g.drawRect(0, 0, width, height);
                }

                @Override
                public Dimension getMaximumSize() {
                    return new Dimension(100, 20);
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Colormap> list, Colormap value, int index, boolean isSelected, boolean cellHasFocus) {
            this.lut = value;
            this.lbl.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
            this.setBackground(this.lbl.getBackground());
            return this;
        }
    }

    public static abstract class FontElement
    implements StyleElement {
        private final ArrayList<Consumer<Font>> onSet = new ArrayList();
        private Font value;
        private final String label;

        public FontElement(String label) {
            this.label = label;
        }

        public Font getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract Font get();

        public abstract void set(Font var1);

        public void onSet(Consumer<Font> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            if (this.get() != this.value) {
                this.value = this.get();
            }
        }
    }

    public static abstract class ColormapElement
    implements StyleElement {
        private final ArrayList<Consumer<Colormap>> onSet = new ArrayList();
        private final String label;

        public ColormapElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract Colormap get();

        public abstract void set(Colormap var1);

        public void onSet(Consumer<Colormap> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Colormap>>)((Consumer<Consumer>)c -> c.accept(this.get())));
        }
    }

    public static abstract class IntElement
    implements StyleElement {
        private final BoundedValue value;
        private final String label;

        public IntElement(String label, int rangeMin, int rangeMax) {
            int currentValue = Math.max(rangeMin, Math.min(rangeMax, this.get()));
            this.value = new BoundedValue(rangeMin, rangeMax, currentValue){

                @Override
                public void setCurrentValue(int value) {
                    super.setCurrentValue(value);
                    if (this.get() != this.getCurrentValue()) {
                        this.set(this.getCurrentValue());
                    }
                }
            };
            this.label = label;
        }

        public BoundedValue getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract int get();

        public abstract void set(int var1);

        @Override
        public void update() {
            if (this.get() != this.value.getCurrentValue()) {
                this.value.setCurrentValue(this.get());
            }
        }
    }

    public static abstract class DoubleElement
    implements StyleElement {
        private final ArrayList<Consumer<Double>> onSet = new ArrayList();
        private double value = 0.0;
        private final String label;

        public DoubleElement(String label) {
            this.label = label;
        }

        public double getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract double get();

        public abstract void set(double var1);

        public void onSet(Consumer<Double> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            if (this.get() != this.value) {
                this.value = this.get();
            }
        }
    }

    public static abstract class BoundedDoubleElement
    implements StyleElement {
        private final BoundedValueDouble value;
        private final String label;

        public BoundedDoubleElement(String label, double rangeMin, double rangeMax) {
            double currentValue = Math.max(rangeMin, Math.min(rangeMax, this.get()));
            this.value = new BoundedValueDouble(rangeMin, rangeMax, currentValue){

                @Override
                public void setCurrentValue(double value) {
                    super.setCurrentValue(value);
                    if (this.get() != this.getCurrentValue()) {
                        this.set(this.getCurrentValue());
                    }
                }
            };
            this.label = label;
        }

        public BoundedValueDouble getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract double get();

        public abstract void set(double var1);

        @Override
        public void update() {
            if (this.get() != this.value.getCurrentValue()) {
                this.value.setCurrentValue(this.get());
            }
        }
    }

    public static abstract class BooleanElement
    implements StyleElement {
        private final String label;
        private final ArrayList<Consumer<Boolean>> onSet = new ArrayList();

        public BooleanElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<Boolean> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Boolean>>)((Consumer<Consumer>)c -> c.accept(this.get())));
        }

        public abstract boolean get();

        public abstract void set(boolean var1);
    }

    public static abstract class ColorElement
    implements StyleElement {
        private final ArrayList<Consumer<Color>> onSet = new ArrayList();
        private final String label;

        public ColorElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<Color> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Color>>)((Consumer<Consumer>)c -> c.accept(this.getColor())));
        }

        public abstract Color getColor();

        public abstract void setColor(Color var1);
    }

    public static abstract class FeatureElement
    implements StyleElement {
        private final ArrayList<BiConsumer<DisplaySettings.TrackMateObject, String>> onSet = new ArrayList();
        private final String label;

        public FeatureElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(BiConsumer<DisplaySettings.TrackMateObject, String> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<BiConsumer<DisplaySettings.TrackMateObject, String>>)((Consumer<BiConsumer>)c -> c.accept(this.getType(), this.getFeature())));
        }

        public abstract DisplaySettings.TrackMateObject getType();

        public abstract String getFeature();

        public abstract void setValue(DisplaySettings.TrackMateObject var1, String var2);
    }

    public static abstract class ListElement<E>
    implements StyleElement {
        private final ArrayList<Consumer<E>> onSet = new ArrayList();
        private final String label;
        private final List<E> values;

        public ListElement(String label, List<E> values) {
            this.label = label;
            this.values = values;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<E> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Consumer>>)((Consumer<Consumer>)c -> c.accept(this.getValue())));
        }

        public abstract E getValue();

        public abstract void setValue(E var1);

        public List<E> getValues() {
            return this.values;
        }
    }

    public static abstract class EnumElement<E>
    implements StyleElement {
        private final ArrayList<Consumer<E>> onSet = new ArrayList();
        private final String label;
        private final E[] values;

        public EnumElement(String label, E[] values) {
            this.label = label;
            this.values = values;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<E> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Consumer>>)((Consumer<Consumer>)c -> c.accept(this.getValue())));
        }

        public abstract E getValue();

        public abstract void setValue(E var1);

        public E[] getValues() {
            return this.values;
        }
    }

    public static abstract class StringElement
    implements StyleElement {
        private final ArrayList<Consumer<String>> onSet = new ArrayList();
        private final String label;
        private String value;

        public StringElement(String label) {
            this.label = label;
            this.value = "";
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public abstract String get();

        public abstract void set(String var1);

        public void onSet(Consumer<String> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            if (this.get() != this.value) {
                this.value = this.get();
            }
            this.onSet.forEach((Consumer<Consumer<String>>)((Consumer<Consumer>)c -> c.accept(this.get())));
        }
    }

    public static class LabelElement
    implements StyleElement {
        private final String label;

        public LabelElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Separator
    implements StyleElement {
        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static interface StyleElement {
        default public void update() {
        }

        public void accept(StyleElementVisitor var1);
    }

    public static interface StyleElementVisitor {
        default public void visit(Separator element) {
            throw new UnsupportedOperationException();
        }

        default public void visit(LabelElement label) {
            throw new UnsupportedOperationException();
        }

        default public void visit(ColorElement colorElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(BooleanElement booleanElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(BoundedDoubleElement doubleElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(DoubleElement doubleElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(IntElement intElement) {
            throw new UnsupportedOperationException();
        }

        default public <E> void visit(EnumElement<E> enumElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(FeatureElement featureElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(ColormapElement element) {
            throw new UnsupportedOperationException();
        }

        default public void visit(FontElement fontElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(StringElement stringElement) {
            throw new UnsupportedOperationException();
        }

        default public <E> void visit(ListElement<E> listElement) {
            throw new UnsupportedOperationException();
        }
    }
}

