/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.gui.components.ModuleChooserPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.providers.DetectorProvider;
import java.util.Map;

public class ChooseDetectorDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "ChooseDetector";
    private final TrackMate trackmate;
    private final DetectorProvider detectorProvider;

    public ChooseDetectorDescriptor(DetectorProvider detectorProvider, TrackMate trackmate) {
        super(KEY);
        this.trackmate = trackmate;
        this.detectorProvider = detectorProvider;
        String selectedDetector = "LOG_DETECTOR";
        if (null != trackmate.getSettings().detectorFactory) {
            selectedDetector = trackmate.getSettings().detectorFactory.getKey();
        }
        this.targetPanel = new ModuleChooserPanel<SpotDetectorFactoryBase>(detectorProvider, "detector", selectedDetector);
    }

    private void setCurrentChoiceFromPlugin() {
        String key = "LOG_DETECTOR";
        if (null != this.trackmate.getSettings().detectorFactory) {
            key = this.trackmate.getSettings().detectorFactory.getKey();
        }
        ModuleChooserPanel component = (ModuleChooserPanel)this.targetPanel;
        component.setSelectedModuleKey(key);
    }

    @Override
    public void displayingPanel() {
        this.setCurrentChoiceFromPlugin();
    }

    @Override
    public void aboutToHidePanel() {
        ModuleChooserPanel component = (ModuleChooserPanel)this.targetPanel;
        String detectorKey = component.getSelectedModuleKey();
        SpotDetectorFactoryBase factory = (SpotDetectorFactoryBase)this.detectorProvider.getFactory(detectorKey);
        if (null == factory) {
            this.trackmate.getModel().getLogger().error("[ChooseDetectorDescriptor] Cannot find detector named " + detectorKey + " in current TrackMate modules.");
            return;
        }
        this.trackmate.getSettings().detectorFactory = factory;
        Map<String, Object> currentSettings = this.trackmate.getSettings().detectorSettings;
        if (!factory.checkSettings(currentSettings)) {
            Map<String, Object> defaultSettings = factory.getDefaultSettings();
            this.trackmate.getSettings().detectorSettings = defaultSettings;
        }
        SettingsPersistence.saveLastUsedSettings(this.trackmate.getSettings(), this.trackmate.getModel().getLogger());
    }

    @Override
    public Runnable getBackwardRunnable() {
        return () -> this.trackmate.getModel().clearSpots(true);
    }
}

