/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.components.InitFilterPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import java.util.function.Function;

public class InitFilterDescriptor
extends WizardPanelDescriptor {
    public static final String KEY = "InitialFiltering";
    private final TrackMate trackmate;

    public InitFilterDescriptor(TrackMate trackmate, FeatureFilter filter) {
        super(KEY);
        this.trackmate = trackmate;
        Function<String, double[]> valuesCollector = key -> FeatureUtils.collectFeatureValues("QUALITY", DisplaySettings.TrackMateObject.SPOTS, trackmate.getModel(), false);
        this.targetPanel = new InitFilterPanel(filter, valuesCollector);
    }

    @Override
    public Runnable getForwardRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                InitFilterDescriptor.this.trackmate.getModel().getLogger().log("\nComputing spot quality histogram...\n", Logger.BLUE_COLOR);
                InitFilterPanel component = (InitFilterPanel)InitFilterDescriptor.this.targetPanel;
                component.refresh();
            }
        };
    }

    @Override
    public void aboutToHidePanel() {
        InitFilterPanel component = (InitFilterPanel)this.targetPanel;
        this.trackmate.getSettings().initialSpotFilterValue = component.getFeatureThreshold().value;
        SettingsPersistence.saveLastUsedSettings(this.trackmate.getSettings(), this.trackmate.getModel().getLogger());
    }
}

