/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.io.TmXmlWriter;
import fiji.plugin.trackmate.tracking.jaqaman.SimpleSparseLAPTrackerFactory;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;

public class SettingsPersistence {
    private static File lastSettingsFile = new File(new File(System.getProperty("user.home"), ".trackmate"), "lastusedsettings.xml");

    public static final Settings readLastUsedSettings(ImagePlus imp, Logger logger) {
        TmXmlReader reader = new TmXmlReader(lastSettingsFile);
        if (!reader.isReadingOk()) {
            logger.error("Could not read the last used settings file at " + lastSettingsFile + ".\n");
            logger.error("Using built-in defaults.\n");
            return SettingsPersistence.getDefaultSettings(imp);
        }
        Settings settings = reader.readSettings(null);
        if (imp == null) {
            return settings;
        }
        Settings newSettings = settings.copyOn(imp);
        return newSettings;
    }

    public static final void saveLastUsedSettings(Settings settings, Logger logger) {
        if (!lastSettingsFile.exists()) {
            lastSettingsFile.getParentFile().mkdirs();
        }
        TmXmlWriter writer = new TmXmlWriter(lastSettingsFile);
        writer.appendSettings(settings);
        try {
            writer.writeToFile();
        }
        catch (IOException e) {
            logger.error("Problem writing to the last used settings file at " + lastSettingsFile + ".\n");
        }
    }

    public static Settings getDefaultSettings(ImagePlus imp) {
        Settings settings = new Settings(imp);
        settings.detectorFactory = new LogDetectorFactory();
        settings.detectorSettings = settings.detectorFactory.getDefaultSettings();
        settings.trackerFactory = new SimpleSparseLAPTrackerFactory();
        settings.trackerSettings = settings.trackerFactory.getDefaultSettings();
        settings.addAllAnalyzers();
        return settings;
    }
}

