/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.jaqaman.SegmentTracker;
import fiji.plugin.trackmate.tracking.jaqaman.SparseLAPFrameToFrameTracker;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;

public class SparseLAPTracker
extends MultiThreadedBenchmarkAlgorithm
implements SpotTracker,
Cancelable {
    private static final String BASE_ERROR_MESSAGE = "[SparseLAPTracker] ";
    private SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;
    private Logger logger = Logger.VOID_LOGGER;
    private final SpotCollection spots;
    private final Map<String, Object> settings;
    private boolean isCanceled;
    private String cancelReason;
    private Cancelable cancelable;

    public SparseLAPTracker(SpotCollection spots, Map<String, Object> settings) {
        this.spots = spots;
        this.settings = settings;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelable = null;
        if (null == this.spots) {
            this.errorMessage = "[SparseLAPTracker] The spot collection is null.";
            return false;
        }
        if (this.spots.keySet().isEmpty()) {
            this.errorMessage = "[SparseLAPTracker] The spot collection is empty.";
            return false;
        }
        boolean empty = true;
        for (int frame : this.spots.keySet()) {
            if (this.spots.getNSpots(frame, true) <= 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            this.errorMessage = "[SparseLAPTracker] The spot collection is empty.";
            return false;
        }
        long start = System.currentTimeMillis();
        HashMap<String, Object> ftfSettings = new HashMap<String, Object>();
        ftfSettings.put("LINKING_MAX_DISTANCE", this.settings.get("LINKING_MAX_DISTANCE"));
        ftfSettings.put("ALTERNATIVE_LINKING_COST_FACTOR", this.settings.get("ALTERNATIVE_LINKING_COST_FACTOR"));
        ftfSettings.put("LINKING_FEATURE_PENALTIES", this.settings.get("LINKING_FEATURE_PENALTIES"));
        SparseLAPFrameToFrameTracker frameToFrameLinker = new SparseLAPFrameToFrameTracker(this.spots, ftfSettings);
        this.cancelable = frameToFrameLinker;
        frameToFrameLinker.setNumThreads(this.numThreads);
        Logger.SlaveLogger ftfLogger = new Logger.SlaveLogger(this.logger, 0.0, 0.5);
        frameToFrameLinker.setLogger(ftfLogger);
        if (!frameToFrameLinker.checkInput() || !frameToFrameLinker.process()) {
            this.errorMessage = frameToFrameLinker.getErrorMessage();
            return false;
        }
        this.graph = frameToFrameLinker.getResult();
        this.cancelable = null;
        SegmentTracker segmentLinker = new SegmentTracker(this.graph, this.settings, this.logger);
        if (!segmentLinker.checkInput() || !segmentLinker.process()) {
            this.errorMessage = segmentLinker.getErrorMessage();
            return false;
        }
        this.logger.setStatus("");
        this.logger.setProgress(1.0);
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
        if (this.cancelable != null) {
            this.cancelable.cancel(reason);
        }
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

