/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costfunction;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import java.util.Map;

public class FeaturePenaltyCostFunction
implements CostFunction<Spot, Spot> {
    private final Map<String, Double> featurePenalties;

    public FeaturePenaltyCostFunction(Map<String, Double> featurePenalties) {
        this.featurePenalties = featurePenalties;
    }

    @Override
    public double linkingCost(Spot source, Spot target) {
        double d1 = source.squareDistanceTo(target);
        double d2 = d1 == 0.0 ? Double.MIN_NORMAL : d1;
        double penalty = 1.0;
        for (String feature : this.featurePenalties.keySet()) {
            double ndiff = source.normalizeDiffTo(target, feature);
            if (Double.isNaN(ndiff)) continue;
            double factor = this.featurePenalties.get(feature);
            penalty += factor * 1.5 * ndiff;
        }
        return d2 * penalty * penalty;
    }
}

