/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import fiji.plugin.trackmate.Spot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphSegmentSplitter {
    private final List<Spot> segmentStarts;
    private final List<Spot> segmentEnds;
    private final List<List<Spot>> segmentMiddles;

    public GraphSegmentSplitter(Graph<Spot, DefaultWeightedEdge> graph, boolean findMiddlePoints) {
        ConnectivityInspector connectivity = new ConnectivityInspector(graph);
        List connectedSets = connectivity.connectedSets();
        Comparator<Spot> framecomparator = Spot.frameComparator;
        this.segmentStarts = new ArrayList<Spot>(connectedSets.size());
        this.segmentEnds = new ArrayList<Spot>(connectedSets.size());
        this.segmentMiddles = findMiddlePoints ? new ArrayList<List<Spot>>(connectedSets.size()) : Collections.emptyList();
        for (Set set : connectedSets) {
            if (set.size() < 2) continue;
            ArrayList list = new ArrayList(set);
            Collections.sort(list, framecomparator);
            this.segmentEnds.add((Spot)list.remove(list.size() - 1));
            this.segmentStarts.add((Spot)list.remove(0));
            if (!findMiddlePoints) continue;
            this.segmentMiddles.add(list);
        }
    }

    public List<Spot> getSegmentEnds() {
        return this.segmentEnds;
    }

    public List<List<Spot>> getSegmentMiddles() {
        return this.segmentMiddles;
    }

    public List<Spot> getSegmentStarts() {
        return this.segmentStarts;
    }
}

