/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import java.util.Arrays;

public class ResizableDoubleArray {
    public double[] data;
    public int size;

    public ResizableDoubleArray(double[] data) {
        this.data = data;
        this.size = data.length;
    }

    public ResizableDoubleArray(int initialCapacity) {
        this.data = new double[initialCapacity];
        this.size = 0;
    }

    public ResizableDoubleArray() {
        this(10);
    }

    public void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(double val) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size] = val;
        ++this.size;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "()";
        }
        StringBuilder str = new StringBuilder();
        str.append('(');
        for (int i = 0; i < this.size - 1; ++i) {
            str.append(this.data[i] + ", ");
        }
        str.append(this.data[this.size - 1] + "), size = " + this.size);
        return str.toString();
    }
}

