/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.JLabelLogger;
import fiji.plugin.trackmate.util.QualityHistogramChart;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.DoubleConsumer;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DetectionPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TOOLTIP_PREVIEW = "<html>Preview the current settings on the current frame.<p>Advice: change the settings until you get at least <br><b>all</b> the spots you want, and do not mind the <br>spurious spots too much. You will get a chance to <br>get rid of them later.</html>";
    final Logger logger;
    final JButton btnPreview;
    final QualityHistogramChart chart;

    public DetectionPreviewPanel(DoubleConsumer thresholdUpdater, String axisLabel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        gridBagLayout.rowHeights = new int[]{120, 20};
        this.setLayout(gridBagLayout);
        this.chart = new QualityHistogramChart(thresholdUpdater, axisLabel);
        GridBagConstraints gbcHistogram = new GridBagConstraints();
        gbcHistogram.gridwidth = 2;
        gbcHistogram.insets = new Insets(0, 0, 5, 0);
        gbcHistogram.fill = 1;
        gbcHistogram.gridx = 0;
        gbcHistogram.gridy = 0;
        this.add((Component)this.chart, gbcHistogram);
        JLabelLogger labelLogger = new JLabelLogger();
        labelLogger.setText("   ");
        GridBagConstraints gbcLabelLogger = new GridBagConstraints();
        gbcLabelLogger.insets = new Insets(5, 5, 0, 5);
        gbcLabelLogger.fill = 1;
        gbcLabelLogger.gridx = 0;
        gbcLabelLogger.gridy = 1;
        this.add((Component)labelLogger, gbcLabelLogger);
        this.logger = labelLogger.getLogger();
        this.btnPreview = new JButton("Preview", Icons.PREVIEW_ICON);
        this.btnPreview.setToolTipText(TOOLTIP_PREVIEW);
        GridBagConstraints gbcBtnPreview = new GridBagConstraints();
        gbcBtnPreview.anchor = 12;
        gbcBtnPreview.insets = new Insets(5, 5, 0, 0);
        gbcBtnPreview.gridx = 1;
        gbcBtnPreview.gridy = 1;
        this.add((Component)this.btnPreview, gbcBtnPreview);
        this.btnPreview.setFont(Fonts.SMALL_FONT);
    }
}

