/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CommandCLIConfigurator;
import fiji.plugin.trackmate.util.cli.CondaCLIConfigurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class CommandBuilder
implements CLIConfigurator.ArgumentVisitor {
    private final List<String> tokens = new ArrayList<String>();
    private final Map<CLIConfigurator.Argument<?, ?>, Function<Object, List<String>>> translators;

    protected CommandBuilder(Map<CLIConfigurator.Argument<?, ?>, Function<Object, List<String>>> translators) {
        this.translators = translators;
    }

    public String toString() {
        return StringUtils.join(this.tokens, (String)" ");
    }

    private void check(CLIConfigurator.Argument<?, ?> arg) {
        if (arg.isInCLI() && arg.getArgument() == null) {
            throw new IllegalArgumentException("Incorrect configuration for argument '" + arg.getName() + "'. The command argument is not set.");
        }
    }

    @Override
    public void visit(CommandCLIConfigurator.ExecutablePath executablePath) {
        if (executablePath.getValue() == null) {
            throw new IllegalArgumentException("Executable path is not set.");
        }
        this.tokens.addAll(this.translators.getOrDefault(executablePath, v -> Collections.singletonList("" + v)).apply(executablePath.getValue()));
    }

    @Override
    public void visit(CondaCLIConfigurator.CondaEnvironmentCommand condaEnv) {
        if (condaEnv.getValue() == null) {
            throw new IllegalArgumentException("Conda environment is not set.");
        }
        this.tokens.addAll(this.translators.getOrDefault(condaEnv, v -> Collections.singletonList("" + v)).apply(condaEnv.getValue()));
    }

    @Override
    public void visit(CLIConfigurator.Flag flag) {
        this.check(flag);
        boolean val = flag.isSet() ? ((Boolean)flag.getValue()).booleanValue() : ((Boolean)flag.getDefaultValue()).booleanValue();
        if (val) {
            this.tokens.add(flag.getArgument());
            this.tokens.addAll(this.translators.getOrDefault(flag, v -> Collections.singletonList("" + v)).apply(val));
        }
    }

    @Override
    public void visit(CLIConfigurator.IntArgument arg) {
        int val;
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        int n = val = !arg.isSet() ? ((Integer)arg.getDefaultValue()).intValue() : ((Integer)arg.getValue()).intValue();
        if (arg.hasMin() && val < (Integer)arg.getMin()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is smaller than the min: " + arg.getMin());
        }
        if ((Integer)arg.getMax() != Integer.MAX_VALUE && val > (Integer)arg.getMax()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is larger than the max: " + arg.getMax());
        }
        this.tokens.add(arg.getArgument());
        this.tokens.addAll(this.translators.getOrDefault(arg, v -> Collections.singletonList("" + v)).apply(val));
    }

    @Override
    public void visit(CLIConfigurator.DoubleArgument arg) {
        double val;
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        double d = val = !arg.isSet() ? ((Double)arg.getDefaultValue()).doubleValue() : ((Double)arg.getValue()).doubleValue();
        if (arg.hasMin() && val < (Double)arg.getMin()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is smaller than the min: " + arg.getMin());
        }
        if (arg.hasMax() && val > (Double)arg.getMax()) {
            throw new IllegalArgumentException("Value " + val + " for argument '" + arg.getName() + "' is larger than the max: " + arg.getMax());
        }
        this.tokens.add(arg.getArgument());
        this.tokens.addAll(this.translators.getOrDefault(arg, v -> Collections.singletonList("" + v)).apply(val));
    }

    private void visitString(CLIConfigurator.AbstractStringArgument<?> arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet() && !arg.hasDefaultValue()) {
            return;
        }
        String val = !arg.isSet() ? (String)arg.getDefaultValue() : (String)arg.getValue();
        this.tokens.add(arg.getArgument());
        this.tokens.addAll(this.translators.getOrDefault(arg, v -> Collections.singletonList("" + v)).apply(val));
    }

    @Override
    public void visit(CLIConfigurator.StringArgument stringArgument) {
        this.visitString(stringArgument);
    }

    @Override
    public void visit(CLIConfigurator.PathArgument pathArgument) {
        this.visitString(pathArgument);
    }

    @Override
    public void visit(CLIConfigurator.ChoiceArgument arg) {
        this.check(arg);
        if (arg.isRequired() && !arg.isSet()) {
            throw new IllegalArgumentException("Required argument '" + arg.getName() + "' is not set.");
        }
        if (!arg.isSet()) {
            return;
        }
        this.tokens.add(arg.getArgument());
        this.tokens.addAll(this.translators.getOrDefault(arg, v -> Collections.singletonList("" + v)).apply(arg.getValue()));
    }

    public static List<String> build(CLIConfigurator cli) {
        CommandBuilder cb = new CommandBuilder(cli.translators);
        cli.getCommandArg().accept(cb);
        cli.getSelectedArguments().stream().filter(a -> a.isInCLI()).forEach(arg -> arg.accept(cb));
        return cb.tokens;
    }
}

