/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackSchemePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -1L;
    private final Object cell;
    private final TrackScheme trackScheme;
    private final Point point;
    private static Color previousColor = Color.RED;

    public TrackSchemePopupMenu(TrackScheme trackScheme, Object cell, Point point) {
        this.trackScheme = trackScheme;
        this.cell = cell;
        this.point = point;
        this.init();
    }

    private void manualColorEdges(ArrayList<mxCell> edges) {
        for (mxCell mxCell2 : edges) {
            DefaultWeightedEdge edge = this.trackScheme.getGraph().getEdgeFor((mxICell)mxCell2);
            Double value = previousColor.getRGB();
            this.trackScheme.getModel().getFeatureModel().putEdgeFeature(edge, "MANUAL_EDGE_COLOR", value);
        }
    }

    private void manualColorVertices(ArrayList<mxCell> vertices) {
        for (mxCell mxCell2 : vertices) {
            Spot spot = this.trackScheme.getGraph().getSpotFor((mxICell)mxCell2);
            Double value = previousColor.getRGB();
            spot.putFeature("MANUAL_SPOT_COLOR", value);
        }
    }

    private void selectWholeTrack(ArrayList<mxCell> vertices, ArrayList<mxCell> edges) {
        this.trackScheme.selectTrack(vertices, edges, 0);
    }

    private void selectTrackDownwards(ArrayList<mxCell> vertices, ArrayList<mxCell> edges) {
        this.trackScheme.selectTrack(vertices, edges, -1);
    }

    private void selectTrackUpwards(ArrayList<mxCell> vertices, ArrayList<mxCell> edges) {
        this.trackScheme.selectTrack(vertices, edges, 1);
    }

    private void editSpotName() {
        this.trackScheme.getGUI().graphComponent.startEditingAtCell(this.cell);
    }

    private void toggleBranchFolding() {
        Object parent = this.trackScheme.getGraph().isCellFoldable(this.cell, true) ? this.cell : this.trackScheme.getGraph().getModel().getParent(this.cell);
        this.trackScheme.getGraph().foldCells(!this.trackScheme.getGraph().isCellCollapsed(parent), false, new Object[]{parent});
    }

    private void multiEditSpotName(final ArrayList<mxCell> vertices, EventObject triggerEvent) {
        final mxCell tc = this.getClosestCell(vertices);
        vertices.remove(tc);
        final TrackSchemeGraphComponent graphComponent = this.trackScheme.getGUI().graphComponent;
        graphComponent.startEditingAtCell(tc, triggerEvent);
        graphComponent.addListener("labelChanged", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                for (mxCell lCell : vertices) {
                    lCell.setValue(tc.getValue());
                    TrackSchemePopupMenu.this.trackScheme.getGraph().getSpotFor((mxICell)lCell).setName(tc.getValue().toString());
                }
                graphComponent.refresh();
                graphComponent.removeListener((mxEventSource.mxIEventListener)this);
            }
        });
    }

    private mxCell getClosestCell(Iterable<mxCell> vertices) {
        double min_dist = Double.POSITIVE_INFINITY;
        mxCell target_cell = null;
        for (mxCell lCell : vertices) {
            Point location = lCell.getGeometry().getPoint();
            double dist = location.distanceSq(this.point);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            target_cell = lCell;
        }
        return target_cell;
    }

    private void linkSpots() {
        this.trackScheme.linkSpots();
    }

    private void remove() {
        this.trackScheme.removeSelectedCells();
    }

    private void removeLinks() {
        this.trackScheme.removeSelectedLinkCells();
    }

    private void init() {
        String str;
        Object[] selection = this.trackScheme.getGraph().getSelectionCells();
        final ArrayList<mxCell> vertices = new ArrayList<mxCell>();
        final ArrayList<mxCell> edges = new ArrayList<mxCell>();
        for (Object obj : selection) {
            mxCell lCell = (mxCell)obj;
            if (lCell.isVertex()) {
                vertices.add(lCell);
                continue;
            }
            if (!lCell.isEdge()) continue;
            edges.add(lCell);
        }
        if (vertices.size() > 0 || edges.size() > 0) {
            this.add(new AbstractAction("Select whole track"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.selectWholeTrack(vertices, edges);
                }
            });
            this.add(new AbstractAction("Select track downwards"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.selectTrackDownwards(vertices, edges);
                }
            });
            this.add(new AbstractAction("Select track upwards"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.selectTrackUpwards(vertices, edges);
                }
            });
        }
        if (this.cell != null) {
            this.add(new AbstractAction("Edit spot name"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.editSpotName();
                }
            });
        } else {
            if (vertices.size() > 1) {
                this.add(new AbstractAction("Edit " + vertices.size() + " spot names"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackSchemePopupMenu.this.multiEditSpotName(vertices, e);
                    }
                });
            }
            AbstractAction linkAction = new AbstractAction("Link " + this.trackScheme.getSelectionModel().getSpotSelection().size() + " spots"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.linkSpots();
                }
            };
            if (this.trackScheme.getSelectionModel().getSpotSelection().size() > 1) {
                this.add(linkAction);
            }
        }
        if (edges.size() > 0 || vertices.size() > 0) {
            this.addSeparator();
        }
        if (vertices.size() > 0) {
            str = "Manual color for " + (vertices.size() == 1 ? " one spot" : vertices.size() + " spots");
            this.add(new AbstractAction(str){

                @Override
                public void actionPerformed(ActionEvent e) {
                    previousColor = JColorChooser.showDialog(TrackSchemePopupMenu.this.trackScheme.getGUI(), "Choose Color", previousColor);
                    TrackSchemePopupMenu.this.manualColorVertices(vertices);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TrackSchemePopupMenu.this.trackScheme.doTrackStyle();
                        }
                    });
                }
            });
        }
        if (edges.size() > 0) {
            str = "Manual color for " + (edges.size() == 1 ? " one edge" : edges.size() + " edges");
            this.add(new AbstractAction(str){

                @Override
                public void actionPerformed(ActionEvent e) {
                    previousColor = JColorChooser.showDialog(TrackSchemePopupMenu.this.trackScheme.getGUI(), "Choose Color", previousColor);
                    TrackSchemePopupMenu.this.manualColorEdges(edges);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TrackSchemePopupMenu.this.trackScheme.doTrackStyle();
                        }
                    });
                }
            });
        }
        if (edges.size() > 0 && vertices.size() > 0) {
            str = "Manual color for " + (vertices.size() == 1 ? " one spot and " : vertices.size() + " spots and ") + (edges.size() == 1 ? " one edge" : edges.size() + " edges");
            this.add(new AbstractAction(str){

                @Override
                public void actionPerformed(ActionEvent e) {
                    previousColor = JColorChooser.showDialog(TrackSchemePopupMenu.this.trackScheme.getGUI(), "Choose Color", previousColor);
                    TrackSchemePopupMenu.this.manualColorVertices(vertices);
                    TrackSchemePopupMenu.this.manualColorEdges(edges);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TrackSchemePopupMenu.this.trackScheme.doTrackStyle();
                        }
                    });
                }
            });
        }
        this.add(new AbstractAction("Clear manual color of selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (mxCell mxCell2 : vertices) {
                    Spot spot = TrackSchemePopupMenu.this.trackScheme.getGraph().getSpotFor((mxICell)mxCell2);
                    spot.getFeatures().remove("MANUAL_SPOT_COLOR");
                }
                for (mxCell mxCell2 : edges) {
                    DefaultWeightedEdge edge = TrackSchemePopupMenu.this.trackScheme.getGraph().getEdgeFor((mxICell)mxCell2);
                    TrackSchemePopupMenu.this.trackScheme.getModel().getFeatureModel().removeEdgeFeature(edge, "MANUAL_EDGE_COLOR");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrackSchemePopupMenu.this.trackScheme.doTrackStyle();
                    }
                });
            }
        });
        if (selection.length > 0) {
            this.addSeparator();
            AbstractAction removeAction = new AbstractAction("Remove spots and links"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.remove();
                }
            };
            this.add(removeAction);
            AbstractAction removeLinkAction = new AbstractAction("Remove only links"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackSchemePopupMenu.this.removeLinks();
                }
            };
            this.add(removeLinkAction);
        }
    }
}

