/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.Field;
import io.scif.MetadataService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ClassUtils;

@Plugin(type=Service.class)
public class DefaultMetadataService
extends AbstractService
implements MetadataService {
    @Parameter
    private LogService log;

    @Override
    public Map<String, Object> parse(String data) {
        return this.parse(data, "[&\n]");
    }

    @Override
    public Map<String, Object> parse(String data, String regex) {
        String[] tokens;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String token : tokens = data.split(regex)) {
            Object value;
            int equals = token.indexOf("=");
            if (!map.containsKey("name") && equals < 0) {
                map.put("name", token);
                continue;
            }
            if (equals < 0) {
                this.log.warn((Object)("Ignoring token: " + token));
                continue;
            }
            String key = token.substring(0, equals);
            String rawValue = token.substring(equals + 1);
            if (rawValue.indexOf(44) >= 0) {
                String[] values = rawValue.split(",");
                value = Arrays.asList(values);
            } else {
                value = rawValue;
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void populate(Object metadata, Map<String, Object> map) {
        List fields = ClassUtils.getAnnotatedFields(metadata.getClass(), Field.class);
        for (java.lang.reflect.Field field : fields) {
            Object value;
            String name = field.getName();
            if (!map.containsKey(name) || (value = map.get(name)) == null) continue;
            ClassUtils.setValue((java.lang.reflect.Field)field, (Object)metadata, (Object)value);
        }
    }
}

