/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.ImageIOFormat;
import io.scif.util.FormatTools;
import java.awt.color.CMMException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.imagej.axis.Axes;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="JPEG")
public class JPEGFormat
extends ImageIOFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"jpg", "jpeg", "jpe"};
    }

    public static class Writer
    extends ImageIOFormat.Writer<Metadata> {
        public Writer() {
            super("jpeg");
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{1};
        }
    }

    public static class Reader
    extends ImageIOFormat.Reader<Metadata> {
    }

    public static class Parser
    extends ImageIOFormat.Parser<Metadata> {
        @Parameter
        private DataHandleService dataHandleService;

        @Override
        public void typedParse(DataHandle<Location> handle, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            String name = ((Location)handle.get()).getName();
            try {
                super.typedParse(handle, meta, config);
            }
            catch (CMMException e) {
                ByteArrayOutputStream v = new ByteArrayOutputStream();
                byte[] tag = new byte[2];
                handle.read(tag);
                v.write(tag);
                handle.read(tag);
                int tagValue = Bytes.toShort((byte[])tag, (boolean)false) & 0xFFFF;
                boolean appNoteFound = false;
                while (tagValue != 65499) {
                    int len;
                    if (!appNoteFound || tagValue < 65504 && tagValue >= 65520) {
                        v.write(tag);
                        handle.read(tag);
                        len = Bytes.toShort((byte[])tag, (boolean)false) & 0xFFFF;
                        byte[] tagContents = new byte[len - 2];
                        handle.read(tagContents);
                        v.write(tag);
                        v.write(tagContents);
                    } else {
                        handle.read(tag);
                        len = Bytes.toShort((byte[])tag, (boolean)false) & 0xFFFF;
                        handle.skipBytes(len - 2);
                    }
                    if (tagValue >= 65504 && tagValue < 65520 && !appNoteFound) {
                        appNoteFound = true;
                    }
                    handle.read(tag);
                    tagValue = Bytes.toShort((byte[])tag, (boolean)false) & 0xFFFF;
                }
                v.write(tag);
                byte[] remainder = new byte[(int)(handle.length() - handle.offset())];
                handle.read(remainder);
                v.write(remainder);
                DataHandle bytes = (DataHandle)this.dataHandleService.create((Object)new BytesLocation(v.toByteArray()));
                super.parse((DataHandle<Location>)bytes, meta);
            }
            ((Metadata)this.getMetadata()).setDatasetName(name);
        }
    }

    public static class Checker
    extends AbstractChecker {
        private static final int MAX_SIZE = 8192;

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(Location name, SCIFIOConfig config) {
            if (config.checkerIsOpen()) {
                return super.isFormat(name, config);
            }
            return FormatTools.checkSuffix(name.getName(), this.getFormat().getSuffixes());
        }

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            int blockLen = 4;
            if (!FormatTools.validStream(stream, 4, false)) {
                return false;
            }
            byte[] signature = new byte[4];
            stream.read(signature);
            if (signature[0] != -1 || signature[1] != -40 || signature[2] != -1 || (signature[3] & 0xF0) == 0) {
                stream.seek(0L);
                return false;
            }
            try {
                stream.seek(0L);
                io.scif.Metadata m = this.getFormat().createParser().parse(stream);
                stream.seek(0L);
                if (m.get(0).getAxisLength(Axes.X) > 8192L && m.get(0).getAxisLength(Axes.Y) > 8192L) {
                    return false;
                }
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to parse JPEG data", (Throwable)e);
                return false;
            }
            return true;
        }
    }

    public static class Metadata
    extends ImageIOFormat.Metadata {
        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
        }
    }
}

