/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.codec.JPEG2000CodecOptions;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.JPEG2000Format;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.IFDList;
import io.scif.formats.tiff.PhotoInterp;
import io.scif.formats.tiff.TiffCompression;
import io.scif.formats.tiff.TiffParser;
import io.scif.services.FormatService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="Minimal TIFF", priority=-10000.0)
public class MinimalTIFFFormat
extends AbstractFormat {
    public static final double PRIORITY = -10000.0;

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"tif", "tiff"};
    }

    public static class Reader<M extends Metadata>
    extends ByteArrayReader<M> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            boolean float24;
            Metadata meta = (Metadata)this.getMetadata();
            plane.setColorTable(meta.getColorTable(imageIndex, planeIndex));
            byte[] buf = plane.getBytes();
            IFDList ifds = meta.getIfds();
            TiffParser tiffParser = meta.getTiffParser();
            int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xIndex);
            int y = (int)bounds.min(yIndex);
            int w = (int)bounds.dimension(xIndex);
            int h = (int)bounds.dimension(yIndex);
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            IFD firstIFD = (IFD)ifds.get(0);
            meta.setLastPlane(planeIndex);
            IFD ifd = (IFD)ifds.get((int)planeIndex);
            if ((firstIFD.getCompression() == TiffCompression.JPEG_2000 || firstIFD.getCompression() == TiffCompression.JPEG_2000_LOSSY) && meta.getResolutionLevels() != null) {
                this.setResolutionLevel(ifd);
            }
            tiffParser.getSamples(ifd, buf, x, y, w, h);
            boolean float16 = meta.get(imageIndex).getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 16;
            boolean bl = float24 = meta.get(imageIndex).getPixelType() == 6 && firstIFD.getBitsPerSample()[0] == 24;
            if (float16 || float24) {
                int nPixels = w * h * (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
                int nBytes = float16 ? 2 : 3;
                int mantissaBits = float16 ? 10 : 16;
                int exponentBits = float16 ? 5 : 7;
                int maxExponent = (int)Math.pow(2.0, exponentBits) - 1;
                int bits = nBytes * 8 - 1;
                byte[] newBuf = new byte[buf.length];
                for (int i = 0; i < nPixels; ++i) {
                    int v = Bytes.toInt((byte[])buf, (int)(i * nBytes), (int)nBytes, (boolean)meta.get(imageIndex).isLittleEndian());
                    int sign = v >> bits;
                    int exponent = v >> mantissaBits & (int)(Math.pow(2.0, exponentBits) - 1.0);
                    int mantissa = v & (int)(Math.pow(2.0, mantissaBits) - 1.0);
                    if (exponent == 0) {
                        if (mantissa != 0) {
                            while ((mantissa & (int)Math.pow(2.0, mantissaBits)) == 0) {
                                mantissa <<= 1;
                                --exponent;
                            }
                            ++exponent;
                            mantissa &= (int)(Math.pow(2.0, mantissaBits) - 1.0);
                            exponent = (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                        }
                    } else {
                        exponent = exponent == maxExponent ? 255 : (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                    }
                    int value = sign << 31 | exponent << 23 | (mantissa <<= 23 - mantissaBits);
                    Bytes.unpack((long)value, (byte[])newBuf, (int)(i * 4), (int)4, (boolean)meta.get(imageIndex).isLittleEndian());
                }
                System.arraycopy(newBuf, 0, buf, 0, newBuf.length);
            }
            return plane;
        }

        @Override
        public long getOptimalTileWidth(int imageIndex) {
            FormatTools.assertId(((Location)this.getHandle().get()).getName(), true, 1);
            try {
                return ((IFD)((Metadata)this.getMetadata()).getIfds().get(0)).getTileWidth();
            }
            catch (FormatException e) {
                this.log().debug((Object)"Could not retrieve tile width", (Throwable)e);
                return super.getOptimalTileWidth(imageIndex);
            }
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            FormatTools.assertId(((Location)this.getHandle().get()).getName(), true, 1);
            try {
                return ((IFD)((Metadata)this.getMetadata()).getIfds().get(0)).getTileLength();
            }
            catch (FormatException e) {
                this.log().debug((Object)"Could not retrieve tile height", (Throwable)e);
                return super.getOptimalTileHeight(imageIndex);
            }
        }

        protected void setResolutionLevel(IFD ifd) {
            Metadata meta = (Metadata)this.getMetadata();
            JPEG2000CodecOptions j2kCodecOptions = meta.getJ2kCodecOptions();
            j2kCodecOptions.resolution = 0;
            this.log().debug((Object)("Using JPEG 2000 resolution level " + j2kCodecOptions.resolution));
            meta.getTiffParser().setCodecOptions(j2kCodecOptions);
        }
    }

    public static class Parser<M extends Metadata>
    extends AbstractParser<M> {
        @Parameter
        private FormatService formatService;

        @Override
        protected void typedParse(DataHandle<Location> stream, M meta, SCIFIOConfig config) throws IOException, FormatException {
            TiffParser tiffParser = new TiffParser(this.getContext(), stream);
            tiffParser.setDoCaching(false);
            tiffParser.setUse64BitOffsets(((Metadata)meta).isUse64Bit());
            ((Metadata)meta).setTiffParser(tiffParser);
            Boolean littleEndian = tiffParser.checkHeader();
            if (littleEndian == null) {
                throw new FormatException("Invalid TIFF file");
            }
            this.getSource().setOrder(littleEndian != false ? DataHandle.ByteOrder.LITTLE_ENDIAN : DataHandle.ByteOrder.BIG_ENDIAN);
            this.log().debug((Object)"Reading IFDs");
            IFDList allIFDs = tiffParser.getIFDs();
            if (allIFDs == null || allIFDs.isEmpty()) {
                throw new FormatException("No IFDs found");
            }
            IFDList ifds = new IFDList();
            IFDList thumbnailIFDs = new IFDList();
            ((Metadata)meta).setIfds(ifds);
            ((Metadata)meta).setThumbnailIFDs(thumbnailIFDs);
            for (IFD ifd : allIFDs) {
                int subfileType;
                Number subfile = (Number)ifd.getIFDValue(254);
                int n = subfileType = subfile == null ? 0 : subfile.intValue();
                if (subfileType != 1 || allIFDs.size() <= 1) {
                    ifds.add(ifd);
                    continue;
                }
                if (subfileType != 1) continue;
                thumbnailIFDs.add(ifd);
            }
            this.log().debug((Object)"Populating metadata");
            tiffParser.setAssumeEqualStrips(((Metadata)meta).isEqualStrips());
            for (IFD ifd : ifds) {
                tiffParser.fillInIFD(ifd);
                if (ifd.getCompression() != TiffCompression.JPEG_2000 && ifd.getCompression() != TiffCompression.JPEG_2000_LOSSY) continue;
                this.log().debug((Object)"Found IFD with JPEG 2000 compression");
                long[] stripOffsets = ifd.getStripOffsets();
                long[] stripByteCounts = ifd.getStripByteCounts();
                if (stripOffsets.length > 0) {
                    long stripOffset = stripOffsets[0];
                    stream.seek(stripOffset);
                    JPEG2000Format jp2kFormat = this.formatService.getFormatFromClass(JPEG2000Format.class);
                    JPEG2000Format.Metadata jp2kMeta = (JPEG2000Format.Metadata)jp2kFormat.createMetadata();
                    ((JPEG2000Format.Parser)jp2kFormat.createParser()).parse(stream, jp2kMeta, stripOffset + stripByteCounts[0]);
                    ((Metadata)meta).setResolutionLevels(jp2kMeta.getResolutionLevels());
                    if (((Metadata)meta).getResolutionLevels() == null || ((Metadata)meta).isNoSubresolutions()) continue;
                    if (this.log().isDebug()) {
                        this.log().debug((Object)String.format("Original resolution IFD Levels %d %dx%d Tile %dx%d", ((Metadata)meta).getResolutionLevels(), ifd.getImageWidth(), ifd.getImageLength(), ifd.getTileWidth(), ifd.getTileLength()));
                    }
                    IFDList theseSubResolutionIFDs = new IFDList();
                    ((Metadata)meta).getSubResolutionIFDs().add(theseSubResolutionIFDs);
                    for (int level = 1; level <= ((Metadata)meta).getResolutionLevels(); ++level) {
                        IFD newIFD = new IFD(ifd, this.log());
                        long imageWidth = ifd.getImageWidth();
                        long imageLength = ifd.getImageLength();
                        long tileWidth = ifd.getTileWidth();
                        long tileLength = ifd.getTileLength();
                        long factor = (long)Math.pow(2.0, level);
                        long newTileWidth = Math.round((double)tileWidth / (double)factor);
                        newTileWidth = newTileWidth < 1L ? 1L : newTileWidth;
                        long newTileLength = Math.round((double)tileLength / (double)factor);
                        newTileLength = newTileLength < 1L ? 1L : newTileLength;
                        long evenTilesPerRow = imageWidth / tileWidth;
                        long evenTilesPerColumn = imageLength / tileLength;
                        double remainingWidth = (double)(imageWidth - evenTilesPerRow * tileWidth) / (double)factor;
                        remainingWidth = remainingWidth < 1.0 ? Math.ceil(remainingWidth) : (double)Math.round(remainingWidth);
                        double remainingLength = (double)(imageLength - evenTilesPerColumn * tileLength) / (double)factor;
                        remainingLength = remainingLength < 1.0 ? Math.ceil(remainingLength) : (double)Math.round(remainingLength);
                        long newImageWidth = (long)((double)(evenTilesPerRow * newTileWidth) + remainingWidth);
                        long newImageLength = (long)((double)(evenTilesPerColumn * newTileLength) + remainingLength);
                        int resolutionLevel = Math.abs(level - ((Metadata)meta).getResolutionLevels());
                        newIFD.put(256, newImageWidth);
                        newIFD.put(257, newImageLength);
                        newIFD.put(322, newTileWidth);
                        newIFD.put(323, newTileLength);
                        if (this.log().isDebug()) {
                            this.log().debug((Object)String.format("Added JPEG 2000 sub-resolution IFD Level %d %dx%d Tile %dx%d", resolutionLevel, newImageWidth, newImageLength, newTileWidth, newTileLength));
                        }
                        theseSubResolutionIFDs.add(newIFD);
                    }
                    continue;
                }
                this.log().warn((Object)"IFD has no strip offsets!");
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(DataHandle<Location> stream) {
            return new TiffParser(this.getContext(), stream).isValidHeader();
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private IFDList ifds;
        private IFDList thumbnailIFDs;
        private List<IFDList> subResolutionIFDs;
        private TiffParser tiffParser;
        private boolean equalStrips = false;
        private boolean use64Bit = false;
        private long lastPlane = 0L;
        private boolean noSubresolutions = false;
        private Integer resolutionLevels;
        private JPEG2000CodecOptions j2kCodecOptions;

        public IFDList getIfds() {
            return this.ifds;
        }

        public void setIfds(IFDList ifds) {
            this.ifds = ifds;
        }

        public IFDList getThumbnailIFDs() {
            return this.thumbnailIFDs;
        }

        public void setThumbnailIFDs(IFDList thumbnailIFDs) {
            this.thumbnailIFDs = thumbnailIFDs;
        }

        public List<IFDList> getSubResolutionIFDs() {
            return this.subResolutionIFDs;
        }

        public void setSubResolutionIFDs(List<IFDList> subResolutionIFDs) {
            this.subResolutionIFDs = subResolutionIFDs;
        }

        public TiffParser getTiffParser() {
            return this.tiffParser;
        }

        public void setTiffParser(TiffParser tiffParser) {
            this.tiffParser = tiffParser;
        }

        public boolean isEqualStrips() {
            return this.equalStrips;
        }

        public void setEqualStrips(boolean equalStrips) {
            this.equalStrips = equalStrips;
        }

        public boolean isUse64Bit() {
            return this.use64Bit;
        }

        public void setUse64Bit(boolean use64Bit) {
            this.use64Bit = use64Bit;
        }

        public long getLastPlane() {
            return this.lastPlane;
        }

        public void setLastPlane(long lastPlane) {
            this.lastPlane = lastPlane;
        }

        public boolean isNoSubresolutions() {
            return this.noSubresolutions;
        }

        public void setNoSubresolutions(boolean noSubresolutions) {
            this.noSubresolutions = noSubresolutions;
        }

        public Integer getResolutionLevels() {
            return this.resolutionLevels;
        }

        public void setResolutionLevels(Integer resolutionLevels) {
            this.resolutionLevels = resolutionLevels;
        }

        public JPEG2000CodecOptions getJ2kCodecOptions() {
            return this.j2kCodecOptions;
        }

        public void setJ2kCodecOptions(JPEG2000CodecOptions j2kCodecOptions) {
            this.j2kCodecOptions = j2kCodecOptions;
        }

        @Override
        public void populateImageMetadata() {
            if (this.getImageCount() == 0) {
                this.createImageMetadata(1);
            }
            ImageMetadata ms0 = this.get(0);
            IFD firstIFD = (IFD)this.ifds.get(0);
            try {
                PhotoInterp photo = firstIFD.getPhotometricInterpretation();
                int samples = firstIFD.getSamplesPerPixel();
                if (samples <= 1 && photo == PhotoInterp.RGB) {
                    samples = 3;
                }
                int planarAxes = 2;
                ms0.setLittleEndian(firstIFD.isLittleEndian());
                ms0.setAxisLength(Axes.X, (long)((int)firstIFD.getImageWidth()));
                ms0.setAxisLength(Axes.Y, (long)((int)firstIFD.getImageLength()));
                if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
                    ms0.setThumbSizeX(((IFD)this.thumbnailIFDs.get(0)).getImageWidth());
                    ms0.setThumbSizeY(((IFD)this.thumbnailIFDs.get(0)).getImageLength());
                }
                if (samples > 1) {
                    ms0.setAxisLength(Axes.CHANNEL, (long)samples);
                    planarAxes = 3;
                }
                ms0.setPlanarAxisCount(planarAxes);
                ms0.setPixelType(firstIFD.getPixelType());
                ms0.setMetadataComplete(true);
                ms0.setIndexed(photo == PhotoInterp.RGB_PALETTE && this.getColorTable(0, 0L) != null);
                if (ms0.isIndexed()) {
                    ms0.setAxisLength(Axes.CHANNEL, 1L);
                    for (IFD ifd : this.ifds) {
                        ifd.putIFDValue(262, PhotoInterp.RGB_PALETTE);
                    }
                }
                ms0.setBitsPerPixel(firstIFD.getBitsPerSample()[0]);
                if (this.resolutionLevels != null && this.subResolutionIFDs.size() > 0) {
                    IFDList ifds = this.subResolutionIFDs.get(0);
                    if ((long)(ifds.size() + 1) < ms0.getAxisLength(Axes.TIME)) {
                        ms0.setAxisLength(Axes.TIME, ms0.getAxisLength(Axes.TIME) - (long)(ifds.size() + 1));
                    }
                    for (IFD ifd : ifds) {
                        ImageMetadata ms = ms0.copy();
                        this.add(ms);
                        ms.setAxisLength(Axes.X, (long)((int)ifd.getImageWidth()));
                        ms.setAxisLength(Axes.Y, (long)((int)ifd.getImageLength()));
                        ms.setAxisLength(Axes.TIME, ms0.getAxisLength(Axes.TIME));
                        ms.setThumbnail(true);
                        ms.setThumbSizeX(ms0.getThumbSizeX());
                        ms.setThumbSizeY(ms0.getThumbSizeY());
                    }
                }
            }
            catch (FormatException e) {
                this.log().error((Object)"Error populating TIFF image metadata", (Throwable)e);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                if (this.ifds != null) {
                    for (IFD ifd : this.ifds) {
                        if (ifd.getOnDemandStripOffsets() == null) continue;
                        ifd.getOnDemandStripOffsets().close();
                    }
                }
                this.ifds = null;
                this.thumbnailIFDs = null;
                this.subResolutionIFDs = new ArrayList<IFDList>();
                this.lastPlane = 0L;
                this.tiffParser = null;
                this.resolutionLevels = null;
                this.j2kCodecOptions = JPEG2000CodecOptions.getDefaultOptions();
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            if (this.ifds == null || this.lastPlane < 0L || this.lastPlane > (long)this.ifds.size()) {
                return null;
            }
            IFD lastIFD = (IFD)this.ifds.get((int)this.lastPlane);
            ColorTable8 table = null;
            try {
                int[] bits = lastIFD.getBitsPerSample();
                int[] colorMap = lastIFD.getIFDIntArray(320);
                if (bits[0] <= 16 && bits[0] > 8) {
                    if (colorMap == null || colorMap.length < 196608) {
                        if (this.lastPlane != 0L) {
                            lastIFD = (IFD)this.ifds.get(0);
                            colorMap = lastIFD.getIFDIntArray(320);
                            if (colorMap == null || colorMap.length < 196608) {
                                return null;
                            }
                        } else {
                            return null;
                        }
                    }
                    short[][] table16 = new short[3][colorMap.length / 3];
                    int next = 0;
                    for (int i = 0; i < table16.length; ++i) {
                        for (int j = 0; j < table16[0].length; ++j) {
                            table16[i][j] = (short)(colorMap[next++] & 0xFFFF);
                        }
                    }
                    table = new ColorTable16(table16);
                } else if (bits[0] <= 8) {
                    if (colorMap == null) {
                        if (this.lastPlane != 0L) {
                            lastIFD = (IFD)this.ifds.get(0);
                            colorMap = lastIFD.getIFDIntArray(320);
                            if (colorMap == null) {
                                return null;
                            }
                        } else {
                            return null;
                        }
                    }
                    byte[][] table8 = new byte[3][colorMap.length / 3];
                    int next = 0;
                    for (int j = 0; j < table8.length; ++j) {
                        for (int i = 0; i < table8[0].length; ++i) {
                            table8[j][i] = colorMap[next] > 255 ? (byte)(colorMap[next++] >> 8 & 0xFF) : (byte)(colorMap[next++] & 0xFF);
                        }
                    }
                    table = new ColorTable8(table8);
                }
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to get IFD int array", (Throwable)e);
            }
            return table;
        }
    }
}

