/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.ImageMetadata;
import net.imagej.axis.Axes;

public class XYCTuple {
    private long x;
    private long y;
    private long c;

    public XYCTuple(ImageMetadata meta, long[] axisLengths) {
        this.x = 1L;
        this.y = 1L;
        this.c = 1L;
        if (meta.getInterleavedAxisCount() > 0) {
            for (int i = 0; i < axisLengths.length; ++i) {
                if (meta.getAxisIndex(Axes.X) == i) {
                    this.x = axisLengths[i];
                    continue;
                }
                if (meta.getAxisIndex(Axes.Y) == i) {
                    this.y = axisLengths[i];
                    continue;
                }
                this.c *= axisLengths[i];
            }
        } else {
            this.x = axisLengths[meta.getAxisIndex(Axes.X)];
            this.y = axisLengths[meta.getAxisIndex(Axes.Y)];
            int cIndex = meta.getAxisIndex(Axes.CHANNEL);
            if (cIndex < meta.getPlanarAxisCount() && cIndex >= 0) {
                this.c = axisLengths[meta.getAxisIndex(Axes.CHANNEL)];
            }
            if (this.c <= 0L) {
                this.c = 1L;
            }
        }
    }

    public XYCTuple(long x, long y, long c) {
        this.x = x;
        this.y = y;
        this.c = c;
    }

    public int x() {
        return (int)this.x;
    }

    public int y() {
        return (int)this.y;
    }

    public int c() {
        return (int)this.c;
    }
}

