/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.img.Range;
import java.util.HashMap;
import java.util.Map;
import net.imagej.axis.AxisType;

public class ImageRegion {
    private final Map<AxisType, Range> dimRanges;

    public ImageRegion(AxisType[] axes, String[] ranges) {
        this.dimRanges = new HashMap<AxisType, Range>();
        if (axes.length != ranges.length) {
            throw new IllegalArgumentException("Number of axes: " + axes.length + " does not match number of ranges: " + ranges.length);
        }
        for (int i = 0; i < axes.length; ++i) {
            this.addRange(axes[i], ranges[i]);
        }
    }

    public ImageRegion(AxisType[] axes, Range ... ranges) {
        this.dimRanges = new HashMap<AxisType, Range>();
        if (axes.length != ranges.length) {
            throw new IllegalArgumentException("Number of axes: " + axes.length + " does not match number of ranges: " + ranges.length);
        }
        for (int i = 0; i < axes.length; ++i) {
            this.dimRanges.put(axes[i], ranges[i]);
        }
    }

    public ImageRegion(Map<AxisType, Range> ranges) {
        this.dimRanges = ranges;
    }

    public void addRange(AxisType axis, String range) {
        this.dimRanges.put(axis, new Range(range));
    }

    public Range getRange(AxisType axisType) {
        return this.dimRanges.get(axisType);
    }

    public boolean hasRange(AxisType axisType) {
        return this.dimRanges.get(axisType) != null;
    }

    public int size() {
        return this.dimRanges.size();
    }
}

