/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.ImgUtilityService;
import io.scif.img.Range;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.type.Type;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;

public abstract class AbstractArrayLoader<A>
implements SCIFIOArrayLoader<A> {
    private int index = 0;
    private final Reader reader;
    private final ImageRegion subRegion;
    private final boolean compatible;
    @Parameter
    private ImgUtilityService imgUtilityService;
    private List<List<ColorTable>> tables;
    private boolean[][] loadedTable;

    public AbstractArrayLoader(Reader reader, ImageRegion subRegion) {
        this.reader = reader;
        this.subRegion = subRegion;
        reader.getContext().inject((Object)this);
        Type<?> inputType = this.imgUtilityService.makeType(reader.getMetadata().get(0).getPixelType());
        this.compatible = this.outputClass().isAssignableFrom(inputType.getClass());
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public ColorTable loadTable(int imageIndex, int planeIndex) throws FormatException, IOException {
        ColorTable ct = this.getTable(imageIndex, planeIndex);
        if (ct == null && !this.loadedTable()[imageIndex][planeIndex]) {
            long[] planeMin = new long[this.reader.getMetadata().get(imageIndex).getAxesPlanar().size()];
            long[] planeMax = new long[planeMin.length];
            for (int i = 0; i < planeMax.length; ++i) {
                planeMax[i] = 1L;
            }
            FinalInterval bounds = new FinalInterval(planeMin, planeMax);
            ct = this.reader.openPlane(imageIndex, (long)planeIndex, (Interval)bounds).getColorTable();
            this.addTable(imageIndex, planeIndex, ct);
        }
        return ct;
    }

    @Override
    public A loadArray(Interval bounds) {
        return this.loadArray(bounds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public A loadArray(Interval bounds, A data) {
        Reader reader = this.reader;
        synchronized (reader) {
            int index;
            Metadata meta = this.reader.getMetadata();
            int entities = 1;
            long[] planarMin = new long[meta.get(0).getAxesPlanar().size()];
            long[] planarMax = new long[meta.get(0).getAxesPlanar().size()];
            Range[] npRanges = new Range[meta.get(0).getAxesNonPlanar().size()];
            long[] npIndices = new long[npRanges.length];
            int axisIndex = 0;
            for (CalibratedAxis axis : meta.get(0).getAxesPlanar()) {
                index = meta.get(0).getAxisIndex(axis.type());
                if (this.subRegion != null && this.subRegion.hasRange(axis.type())) {
                    int length = this.subRegion.getRange(axis.type()).size();
                    long offset = (Long)this.subRegion.getRange(axis.type()).get(0);
                    planarMin[axisIndex] = bounds.min(index) + offset;
                    planarMax[axisIndex] = bounds.max(index) + offset;
                    if ((Long)this.subRegion.getRange(axis.type()).get(length - 1) < planarMax[axisIndex]) {
                        planarMax[axisIndex] = (Long)this.subRegion.getRange(axis.type()).get(length - 1);
                    }
                    entities = (int)((long)entities * bounds.dimension(index));
                } else {
                    planarMin[axisIndex] = bounds.min(index);
                    planarMax[axisIndex] = bounds.max(index);
                }
                ++axisIndex;
            }
            axisIndex = 0;
            for (CalibratedAxis axis : meta.get(0).getAxesNonPlanar()) {
                if (this.subRegion != null && this.subRegion.hasRange(axis.type())) {
                    npRanges[axisIndex] = this.subRegion.getRange(axis.type());
                } else {
                    index = meta.get(0).getAxisIndex(axis.type());
                    npRanges[axisIndex] = new Range(bounds.min(index), bounds.max(index));
                }
                entities *= npRanges[axisIndex].size();
                ++axisIndex;
            }
            if (data == null) {
                data = this.emptyArray(entities);
            }
            try {
                FinalInterval planarBounds = new FinalInterval(planarMin, planarMax);
                this.read(data, (Interval)planarBounds, npRanges, npIndices);
            }
            catch (FormatException e) {
                throw new IllegalStateException("Could not open a plane for the given dimensions", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not open a plane for the given dimensions", e);
            }
            return data;
        }
    }

    private void read(A data, Interval bounds, Range[] npRanges, long[] npIndices) throws FormatException, IOException {
        this.read(data, null, bounds, npRanges, npIndices, 0, 0);
    }

    private void read(A data, Plane tmpPlane, Interval bounds, Range[] npRanges, long[] npIndices, int depth, int planeCount) throws FormatException, IOException {
        if (depth < npRanges.length) {
            int npPosition = npRanges.length - 1 - depth;
            for (int i = 0; i < npRanges[npPosition].size(); ++i) {
                npIndices[npPosition] = (Long)npRanges[npPosition].get(i);
                this.read(data, tmpPlane, bounds, npRanges, npIndices, depth + 1, planeCount);
                ++planeCount;
            }
        } else if (this.inSubregion(npIndices)) {
            int planeIndex = (int)FormatTools.positionToRaster(0, this.reader, npIndices);
            this.validateBounds(this.reader.getMetadata().get(0).getAxesLengthsPlanar(), bounds);
            if (tmpPlane == null) {
                tmpPlane = this.reader.openPlane(this.index, (long)planeIndex, bounds);
            } else {
                long expectedLength = Intervals.numElements((Dimensions)bounds);
                if ((long)tmpPlane.getBytes().length != expectedLength) {
                    throw new IllegalArgumentException("Expected tmpPlane length " + expectedLength + " but was " + tmpPlane.getBytes().length);
                }
                tmpPlane = this.reader.openPlane(this.index, (long)planeIndex, tmpPlane, bounds);
            }
            this.convertBytes(data, tmpPlane.getBytes(), planeCount);
            if (!this.loadedTable()[this.index][planeIndex]) {
                this.addTable(this.index, planeIndex, tmpPlane.getColorTable());
            }
        }
    }

    private void validateBounds(long[] lengths, Interval bounds) {
        if (lengths.length != bounds.numDimensions()) {
            throw new IllegalArgumentException("Expected bounds of dimensionality " + lengths.length + " but was " + bounds.numDimensions());
        }
        for (int d = 0; d < bounds.numDimensions(); ++d) {
            if (bounds.min(d) >= 0L && bounds.max(d) < lengths[d]) continue;
            throw new IllegalArgumentException("Bound #" + d + " of [" + bounds.min(d) + ", " + bounds.max(d) + "] is not contained in [0, " + lengths[d] + "]");
        }
    }

    private boolean[][] loadedTable() {
        if (this.loadedTable == null) {
            Metadata m = this.reader.getMetadata();
            this.loadedTable = new boolean[m.getImageCount()][(int)m.get(0).getPlaneCount()];
        }
        return this.loadedTable;
    }

    private List<List<ColorTable>> tables() {
        if (this.tables == null) {
            this.tables = new ArrayList<List<ColorTable>>();
        }
        return this.tables;
    }

    private ColorTable getTable(int imageIndex, int planeIndex) {
        List<ColorTable> imageTable;
        List<List<ColorTable>> tables = this.tables();
        if (imageIndex >= tables.size()) {
            for (int i = tables.size(); i <= imageIndex; ++i) {
                tables.add(new ArrayList());
            }
        }
        return planeIndex >= (imageTable = tables.get(imageIndex)).size() ? null : imageTable.get(planeIndex);
    }

    private void addTable(int imageIndex, int planeIndex, ColorTable colorTable) {
        ColorTable ct = this.getTable(imageIndex, planeIndex);
        if (ct == null) {
            List<ColorTable> imageTable = this.tables.get(imageIndex);
            if (imageTable.size() <= planeIndex) {
                for (int i = imageTable.size(); i <= planeIndex; ++i) {
                    imageTable.add(null);
                }
            }
            boolean[][] isLoaded = this.loadedTable();
            isLoaded[imageIndex][planeIndex] = true;
            imageTable.set(planeIndex, colorTable);
        }
    }

    private boolean inSubregion(long[] npIndices) {
        boolean inSubregion = true;
        if (this.subRegion != null) {
            int index = 0;
            for (CalibratedAxis axis : this.reader.getMetadata().get(0).getAxesNonPlanar()) {
                inSubregion = inSubregion && this.inRange(this.subRegion.getRange(axis.type()), npIndices[index++]);
            }
        }
        return inSubregion;
    }

    private boolean inRange(Range range, long value) {
        if (range == null) {
            return true;
        }
        return range.contains(value);
    }

    protected Reader reader() {
        return this.reader;
    }

    protected boolean isCompatible() {
        return this.compatible;
    }

    protected ImgUtilityService utils() {
        return this.imgUtilityService;
    }

    public abstract void convertBytes(A var1, byte[] var2, int var3);

    public abstract Class<?> outputClass();
}

