/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import io.scif.img.ImgSaver;
import io.scif.img.SCIFIOImgPlus;
import io.scif.services.DatasetIOService;
import io.scif.services.FormatService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultDatasetIOService
extends AbstractService
implements DatasetIOService {
    @Parameter
    private FormatService formatService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private LocationService locationService;
    @Parameter
    private LogService log;

    @Override
    public boolean canOpen(Location source) {
        try {
            return this.formatService.getFormat(source, new SCIFIOConfig(this.getContext()).checkerSetOpen(true)) != null;
        }
        catch (FormatException exc) {
            this.log.error((Throwable)exc);
            return false;
        }
    }

    @Override
    public boolean canOpen(String source) {
        try {
            return this.canOpen(this.locationService.resolve(source));
        }
        catch (URISyntaxException exc) {
            return false;
        }
    }

    @Override
    public boolean canSave(Location destination) {
        try {
            return this.formatService.getWriterForLocation(destination) != null;
        }
        catch (FormatException exc) {
            String message = exc.getMessage();
            if (message != null && message.startsWith("No compatible output format found for extension")) {
                this.log.debug((Throwable)exc);
            } else {
                this.log.error((Throwable)exc);
            }
            return false;
        }
    }

    @Override
    public Dataset open(Location source) throws IOException {
        SCIFIOConfig config = new SCIFIOConfig(this.getContext());
        config.imgOpenerSetIndex(0);
        config.imgOpenerSetComputeMinMax(false);
        config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.PLANAR);
        return this.open(source, config);
    }

    @Override
    public Dataset open(String source) throws IOException {
        return this.open(this.resolve(source));
    }

    @Override
    public Dataset open(Location source, SCIFIOConfig config) throws IOException {
        ImgOpener imageOpener = new ImgOpener(this.getContext());
        try {
            SCIFIOImgPlus<?> imgPlus = imageOpener.openImgs(source, config).get(0);
            Dataset dataset = this.datasetService.create(imgPlus);
            ImageMetadata imageMeta = imgPlus.getImageMetadata();
            this.updateDataset(dataset, imageMeta);
            return dataset;
        }
        catch (ImgIOException exc) {
            throw new IOException((Throwable)((Object)exc));
        }
    }

    @Override
    public Dataset open(String source, SCIFIOConfig config) throws IOException {
        return this.open(this.resolve(source), config);
    }

    @Override
    public List<Dataset> openAll(Location source) throws IOException {
        SCIFIOConfig config = new SCIFIOConfig(this.getContext());
        config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.PLANAR);
        return this.openAll(source, config);
    }

    @Override
    public List<Dataset> openAll(String source) throws IOException {
        return this.openAll(this.resolve(source));
    }

    @Override
    public List<Dataset> openAll(String source, SCIFIOConfig config) throws IOException {
        return this.openAll(this.resolve(source), config);
    }

    @Override
    public List<Dataset> openAll(Location source, SCIFIOConfig config) throws IOException {
        ArrayList<Dataset> datasetList = new ArrayList<Dataset>();
        ImgOpener imageOpener = new ImgOpener(this.getContext());
        try {
            List<SCIFIOImgPlus<?>> openImgs = imageOpener.openImgs(source, config);
            for (int imgId = 0; imgId != openImgs.size(); ++imgId) {
                SCIFIOImgPlus<?> imgPlus = openImgs.get(imgId);
                Dataset dataset = this.datasetService.create(imgPlus);
                ImageMetadata imageMeta = imgPlus.getImageMetadata();
                this.updateDataset(dataset, imageMeta);
                datasetList.add(dataset);
            }
        }
        catch (ImgIOException exc) {
            throw new IOException((Throwable)((Object)exc));
        }
        return datasetList;
    }

    @Override
    public Metadata save(Dataset dataset, String destination) throws IOException {
        return this.save(dataset, this.resolve(destination), new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Metadata save(Dataset dataset, Location destination) throws IOException {
        return this.save(dataset, destination, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Metadata save(Dataset dataset, String destination, SCIFIOConfig config) throws IOException {
        return this.save(dataset, this.resolve(destination), config);
    }

    @Override
    public Metadata save(Dataset dataset, Location destination, SCIFIOConfig config) throws IOException {
        Metadata metadata;
        ImgPlus img = dataset.getImgPlus();
        ImgSaver imageSaver = new ImgSaver(this.getContext());
        try {
            metadata = imageSaver.saveImg(destination, (Img<?>)img, config);
        }
        catch (ImgIOException | IncompatibleTypeException exc) {
            throw new IOException((Throwable)exc);
        }
        String name = destination.getName();
        dataset.setName(name);
        dataset.setDirty(false);
        return metadata;
    }

    private void updateDataset(Dataset dataset, ImageMetadata imageMeta) {
        boolean rgbMerged = false;
        for (CalibratedAxis axis : imageMeta.getAxesPlanar()) {
            if (!axis.type().equals(Axes.CHANNEL)) continue;
            rgbMerged = true;
        }
        dataset.setRGBMerged(rgbMerged);
    }

    private Location resolve(String source) throws IOException {
        try {
            Location location = this.locationService.resolve(source);
            if (location == null) {
                throw new IOException("Unresolvable source: " + source);
            }
            return location;
        }
        catch (URISyntaxException exc) {
            throw new IOException("Invalid source string: " + source);
        }
    }
}

