/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5ViewerMultiscaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;

public class N5MetadataUtils {
    protected static final ArrayList<N5MetadataParser<?>> PARSERS = new ArrayList();
    protected static final ArrayList<N5MetadataParser<?>> GROUP_PARSERS;

    public static void resetParsers() {
        PARSERS.clear();
        PARSERS.add(new N5CosemMetadataParser());
        PARSERS.add(new N5SingleScaleMetadataParser());
        PARSERS.add(new CanonicalMetadataParser());
        PARSERS.add(new N5GenericSingleScaleMetadataParser());
    }

    public static void resetGroupParsers() {
        GROUP_PARSERS.clear();
        GROUP_PARSERS.add(new OmeNgffMetadataParser());
        GROUP_PARSERS.add(new N5CosemMultiScaleMetadata.CosemMultiScaleParser());
        GROUP_PARSERS.add(new N5ViewerMultiscaleMetadataParser());
        GROUP_PARSERS.add(new CanonicalMetadataParser());
    }

    public static void addDefaultParser(N5MetadataParser<?> parser, boolean append) {
        if (append) {
            PARSERS.add(parser);
        } else {
            PARSERS.add(0, parser);
        }
    }

    public static void addDefaultParser(N5MetadataParser<?> parser) {
        N5MetadataUtils.addDefaultParser(parser, false);
    }

    public static void addDefaultGroupParser(N5MetadataParser<?> groupParser, boolean append) {
        if (append) {
            GROUP_PARSERS.add(groupParser);
        } else {
            GROUP_PARSERS.add(0, groupParser);
        }
    }

    public static void addDefaultGroupParser(N5MetadataParser<?> groupParser) {
        N5MetadataUtils.addDefaultGroupParser(groupParser, false);
    }

    public static N5Metadata parseMetadata(N5Reader n5, String group) {
        return N5MetadataUtils.parseMetadata(n5, group, true);
    }

    public static N5Metadata parseMetadata(N5Reader n5, String group, boolean parseWholeTree) {
        return N5MetadataUtils.parseMetadata(n5, group, parseWholeTree, Executors.newCachedThreadPool(), PARSERS, GROUP_PARSERS);
    }

    public static N5Metadata parseMetadata(N5Reader n5, String group, boolean parseWholeTree, ExecutorService exec, List<N5MetadataParser<?>> parsers, List<N5MetadataParser<?>> groupParsers) {
        String groupToParse = parseWholeTree ? "" : group;
        N5TreeNode node = N5MetadataUtils.parseMetadataTree(n5, groupToParse, exec, parsers, groupParsers);
        if (node == null) {
            return null;
        }
        if (parseWholeTree) {
            return node.getDescendant(group).map(N5TreeNode::getMetadata).orElse(null);
        }
        return node.getMetadata();
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5) {
        return N5MetadataUtils.parseMetadataTree(n5, Executors.newCachedThreadPool(), PARSERS, GROUP_PARSERS);
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5, String group) {
        return N5MetadataUtils.parseMetadataTree(n5, group, Executors.newCachedThreadPool(), PARSERS, GROUP_PARSERS);
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5, ExecutorService exec) {
        return N5MetadataUtils.parseMetadataTree(n5, exec, PARSERS, GROUP_PARSERS);
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5, List<N5MetadataParser<?>> parsers, List<N5MetadataParser<?>> groupParsers) {
        return N5MetadataUtils.parseMetadataTree(n5, Executors.newCachedThreadPool(), parsers, groupParsers);
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5, ExecutorService exec, List<N5MetadataParser<?>> parsers, List<N5MetadataParser<?>> groupParsers) {
        return N5MetadataUtils.parseMetadataTree(n5, "", exec, parsers, groupParsers);
    }

    public static N5TreeNode parseMetadataTree(N5Reader n5, String group, ExecutorService exec, List<N5MetadataParser<?>> parsers, List<N5MetadataParser<?>> groupParsers) {
        N5DatasetDiscoverer disc = new N5DatasetDiscoverer(n5, exec, parsers, groupParsers);
        try {
            return disc.discoverAndParseRecursive(group);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        N5MetadataUtils.resetParsers();
        GROUP_PARSERS = new ArrayList();
        N5MetadataUtils.resetGroupParsers();
    }
}

