/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import org.apache.commons.lang3.ArrayUtils;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;

public class N5CosemMetadata
extends N5SingleScaleMetadata
implements AxisMetadata {
    private final CosemTransform cosemTransformMeta;
    private final Axis[] axes;

    public N5CosemMetadata(String path, CosemTransform transform, DatasetAttributes attributes) {
        super(path, transform.toAffineTransform3d(), new double[]{1.0, 1.0, 1.0}, transform.fOrderedScale(), transform.fOrderedTranslation(), N5CosemMetadata.firstSpatialUnit(transform), attributes);
        this.cosemTransformMeta = transform;
        this.axes = transform.buildAxes();
    }

    public CosemTransform getCosemTransform() {
        return this.cosemTransformMeta;
    }

    @Override
    public String[] getAxisLabels() {
        return N5CosemMetadata.reverse(this.cosemTransformMeta.axes);
    }

    @Override
    public String[] getAxisTypes() {
        return (String[])Stream.generate(() -> "space").limit(this.cosemTransformMeta.scale.length).toArray(String[]::new);
    }

    @Override
    public String[] getUnits() {
        return N5CosemMetadata.reverse(this.cosemTransformMeta.units);
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public AffineGet spatialTransform() {
        return this.cosemTransformMeta.getAffine();
    }

    private static String firstSpatialUnit(CosemTransform cosemTform) {
        for (int i = 0; i < cosemTform.axes.length; ++i) {
            if (!cosemTform.axes[i].equals("x") && !cosemTform.axes[i].equals("y") && !cosemTform.axes[i].equals("z")) continue;
            return cosemTform.units[i];
        }
        return "pixel";
    }

    private static String[] reverse(String[] in) {
        String[] out = new String[in.length];
        int j = 0;
        for (int i = in.length - 1; i >= 0; --i) {
            out[j++] = in[i];
        }
        return out;
    }

    @Override
    public N5CosemMetadata modifySpatialTransform(String newPath, AffineGet relativeTransformation) {
        int nd = this.axes.length;
        int tformN = relativeTransformation.numDimensions();
        AffineTransform newTransform = new AffineTransform(nd);
        newTransform.preConcatenate(this.spatialTransform());
        newTransform.preConcatenate(relativeTransformation);
        double[] newScale = new double[nd];
        double[] newTranslation = new double[nd];
        int j = 0;
        for (int i = 0; i < nd; ++i) {
            newScale[i] = newTransform.get(j, j);
            newTranslation[i] = newTransform.get(j, tformN);
            ++j;
        }
        ArrayUtils.reverse((double[])newScale);
        ArrayUtils.reverse((double[])newTranslation);
        return new N5CosemMetadata(newPath, new CosemTransform(this.getCosemTransform().axes, newScale, newTranslation, this.getCosemTransform().units), this.getAttributes());
    }

    public static class CosemTransform {
        public static final transient String KEY = "transform";
        public final String[] axes;
        public final double[] scale;
        public final double[] translate;
        public final String[] units;

        public CosemTransform(String[] axes, double[] scale, double[] translate, String[] units) {
            this.axes = axes;
            this.scale = scale;
            this.translate = translate;
            this.units = units;
        }

        public AffineGet getAffine() {
            double[] scaleRev = new double[this.scale.length];
            double[] translateRev = new double[this.translate.length];
            int j = this.scale.length - 1;
            for (int i = 0; i < this.scale.length; ++i) {
                scaleRev[i] = this.scale[j];
                translateRev[i] = this.translate[j];
                --j;
            }
            return new ScaleAndTranslation(scaleRev, translateRev);
        }

        public AffineTransform3D toAffineTransform3d() {
            assert (this.scale.length >= 2 && this.translate.length >= 2);
            int[] spaceIndexes = new int[3];
            Arrays.fill(spaceIndexes, -1);
            for (int i = 0; i < this.axes.length; ++i) {
                if (this.axes[i].equals("x")) {
                    spaceIndexes[0] = i;
                    continue;
                }
                if (this.axes[i].equals("y")) {
                    spaceIndexes[1] = i;
                    continue;
                }
                if (!this.axes[i].equals("z")) continue;
                spaceIndexes[2] = i;
            }
            AffineTransform3D transform = new AffineTransform3D();
            for (int i = 0; i < 3; ++i) {
                if (spaceIndexes[i] <= -1) continue;
                transform.set(this.scale[spaceIndexes[i]], i, i);
                transform.set(this.translate[spaceIndexes[i]], i, 3);
            }
            return transform;
        }

        public double[] fOrderedScale() {
            return IntStream.range(0, this.scale.length).mapToDouble(i -> this.scale[this.scale.length - i - 1]).toArray();
        }

        public double[] fOrderedTranslation() {
            return IntStream.range(0, this.translate.length).mapToDouble(i -> this.translate[this.translate.length - i - 1]).toArray();
        }

        public Axis[] buildAxes() {
            Object[] out = new Axis[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                out[i] = new Axis(AxisUtils.getDefaultType(this.axes[i]), this.axes[i], this.units[i]);
            }
            ArrayUtils.reverse((Object[])out);
            return out;
        }
    }
}

