/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import net.imglib2.type.numeric.ARGBType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.AbstractN5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.IntensityMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;

public class CanonicalDatasetMetadata
extends AbstractN5DatasetMetadata
implements CanonicalMetadata,
N5DatasetMetadata,
IntensityMetadata,
ColorMetadata {
    private IntensityLimits intensityLimits;
    private ColorMetadata colorMetadata;
    private static final ARGBType defaultColor = new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)255));

    public CanonicalDatasetMetadata(String path, DatasetAttributes attributes, double min, double max, ColorMetadata colorMetadata) {
        super(path, attributes);
        this.intensityLimits = new IntensityLimits(min, max);
        this.colorMetadata = colorMetadata;
    }

    public CanonicalDatasetMetadata(String path, DatasetAttributes attributes, IntensityLimits limits, ColorMetadata colorMetadata) {
        super(path, attributes);
        this.intensityLimits = limits;
        this.colorMetadata = colorMetadata;
    }

    public CanonicalDatasetMetadata(String path, DatasetAttributes attributes, ColorMetadata colorMetadata) {
        super(path, attributes);
        this.intensityLimits = null;
        this.colorMetadata = colorMetadata;
    }

    public CanonicalDatasetMetadata(String path, DatasetAttributes attributes) {
        super(path, attributes);
        this.intensityLimits = null;
        this.colorMetadata = null;
    }

    @Override
    public double minIntensity() {
        return this.intensityLimits == null ? 0.0 : this.intensityLimits.min;
    }

    @Override
    public double maxIntensity() {
        return this.intensityLimits == null ? IntensityMetadata.maxForDataType(this.getAttributes().getDataType()) : this.intensityLimits.max;
    }

    @Override
    public ARGBType getColor() {
        return this.colorMetadata == null ? defaultColor : this.colorMetadata.getColor();
    }

    public ColorMetadata getColorMetadata() {
        return this.colorMetadata;
    }

    protected static class IntensityLimits {
        public final double min;
        public final double max;

        public IntensityLimits(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

