/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleGet;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractLinearCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;

public class ScaleCoordinateTransform
extends AbstractLinearCoordinateTransform<ScaleGet, double[]>
implements InvertibleCoordinateTransform<ScaleGet> {
    public static final String TYPE = "scale";
    public double[] scale;
    public transient ScaleGet transform;

    public ScaleCoordinateTransform(double[] scale) {
        super(TYPE, (String)null, (String)null, (String)null);
        this.scale = scale;
        this.buildTransform(scale);
    }

    public ScaleCoordinateTransform(String name, double[] scale) {
        super(TYPE, name, (String)null, (String)null);
        this.scale = scale;
        this.buildTransform(scale);
    }

    public ScaleCoordinateTransform(String name, String[] inputAxes, String[] outputAxes, double[] scale) {
        super(TYPE, name, null, inputAxes, outputAxes);
        this.scale = scale;
        this.buildTransform(scale);
    }

    public ScaleCoordinateTransform(String name, String inputSpace, String outputSpace, double[] scale) {
        super(TYPE, name, inputSpace, outputSpace);
        this.scale = scale;
        this.buildTransform(scale);
    }

    public ScaleCoordinateTransform(String name, String inputSpace, String outputSpace, N5Reader n5, String path) {
        super(TYPE, name, path, inputSpace, outputSpace);
        this.scale = this.getParameters(n5);
        this.buildTransform(this.scale);
    }

    public ScaleCoordinateTransform(String name, String inputSpace, String outputSpace, String path) {
        super(TYPE, name, path, inputSpace, outputSpace);
        this.scale = null;
    }

    public ScaleCoordinateTransform(ScaleCoordinateTransform other, double[] scale) {
        super(other);
        this.scale = scale;
    }

    public ScaleCoordinateTransform(ScaleCoordinateTransform other) {
        super(other);
        this.scale = other.scale;
    }

    public ScaleCoordinateTransform(ScaleCoordinateTransform other, String[] inputAxes, String[] outputAxes) {
        super(other, inputAxes, outputAxes);
        this.scale = other.scale;
    }

    @Override
    public ScaleGet buildTransform(double[] parameters) {
        this.scale = parameters;
        this.transform = parameters.length == 2 ? new Scale2D(parameters) : (parameters.length == 3 ? new Scale3D(parameters) : new Scale(parameters));
        return this.transform;
    }

    @Override
    public ScaleGet getTransform() {
        if (this.transform == null && this.scale != null) {
            this.buildTransform(this.scale);
        }
        return this.transform;
    }

    @Override
    public double[] getParameters(N5Reader n5) {
        return ScaleCoordinateTransform.getDoubleArray(n5, this.getParameterPath());
    }
}

