/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.realtransform.RealComponentMappingTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.StackedRealTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.CoordinateSystems;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;

public class StackedCoordinateTransform
extends AbstractCoordinateTransform<RealTransform> {
    private final List<CoordinateTransform<?>> transforms;
    private transient CoordinateSystems spaces;
    private transient RealTransform totalTransform;

    public StackedCoordinateTransform(String name, String inputSpace, String outputSpace, List<CoordinateTransform<?>> transforms) {
        super("stacked", name, inputSpace, outputSpace);
        this.transforms = transforms;
    }

    public StackedCoordinateTransform(String name, String inputSpace, String outputSpace, CoordinateTransform<?>[] transforms) {
        this(name, inputSpace, outputSpace, Arrays.stream(transforms).collect(Collectors.toList()));
    }

    public void setSpaces(CoordinateSystems spaces) {
        this.spaces = spaces;
    }

    public String[] inputAxesLabels() {
        return (String[])this.transforms.stream().flatMap(t -> Arrays.stream(t.getInputAxes())).toArray(String[]::new);
    }

    public String[] outputAxesLabels() {
        return (String[])this.transforms.stream().flatMap(t -> Arrays.stream(t.getOutputAxes())).toArray(String[]::new);
    }

    public RealTransform buildTransform() {
        RealTransform[] arr = (RealTransform[])this.transforms.stream().map(x -> x.getTransform()).toArray(RealTransform[]::new);
        StackedRealTransform stackedTransform = new StackedRealTransform(arr);
        if (this.spaces != null) {
            Object[] inputAxisLabels = this.spaces.getSpace(this.getInput()).getAxisNames();
            Object[] tformInputAxisLabels = this.inputAxesLabels();
            Object[] outputAxisLabels = this.spaces.getSpace(this.getOutput()).getAxisNames();
            Object[] tformOutputAxisLabels = this.outputAxesLabels();
            RealComponentMappingTransform pre = null;
            if (!Arrays.equals(inputAxisLabels, tformInputAxisLabels)) {
                int[] inPermParams = AxisUtils.findPermutation(inputAxisLabels, tformInputAxisLabels);
                pre = new RealComponentMappingTransform(inPermParams.length, inPermParams);
            }
            RealComponentMappingTransform post = null;
            if (!Arrays.equals(outputAxisLabels, tformOutputAxisLabels)) {
                int[] outPermParams = AxisUtils.findPermutation(tformOutputAxisLabels, outputAxisLabels);
                post = new RealComponentMappingTransform(outPermParams.length, outPermParams);
            }
            if (pre == null && post == null) {
                this.totalTransform = stackedTransform;
                return this.totalTransform;
            }
            RealTransformSequence seq = new RealTransformSequence();
            if (pre != null) {
                seq.add((RealTransform)pre);
            }
            seq.add((RealTransform)stackedTransform);
            if (post != null) {
                seq.add((RealTransform)post);
            }
            this.totalTransform = seq;
            return this.totalTransform;
        }
        this.totalTransform = stackedTransform;
        return this.totalTransform;
    }

    @Override
    public RealTransform getTransform() {
        if (this.totalTransform == null) {
            this.buildTransform();
        }
        return this.totalTransform;
    }
}

