/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.Memory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sc.fiji.compat.FijiTools;

class MemoryImageJ {
    private static int flags = 40;

    MemoryImageJ() {
    }

    public static void run(String arg) {
        if (IJ.isMacOSX()) {
            MemoryImageJ.runMacOSX();
            return;
        }
        File configFile = new File(FijiTools.getImageJDir(), "ImageJ.cfg");
        if (!configFile.exists()) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(configFile));
                out.println(".");
                out.println(IJ.isWindows() ? "jre\\bin\\javaw.exe" : "jre/bin/java");
                out.println("-Xmx" + (MemoryImageJ.maxMemory() >> 20) + "m -cp ij.jar ij.ImageJ");
                out.close();
            }
            catch (IOException e) {
                IJ.error((String)"Could not write initial ImageJ.cfg!");
                return;
            }
        }
        new Memory().run(arg);
    }

    private static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    private static void runMacOSX() {
        long memory = MemoryImageJ.maxMemory() >> 20;
        int threads = Prefs.getThreads();
        GenericDialog gd = new GenericDialog("Memory " + (IJ.is64Bit() ? "(64-bit)" : "(32-bit)"));
        gd.addNumericField("Maximum Memory:", (double)memory, 0, 5, "MB");
        gd.addNumericField("Parallel Threads for Stacks:", (double)threads, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.invalidNumber()) {
            IJ.showMessage((String)"Memory", (String)"The number entered was invalid.");
            return;
        }
        memory = (long)gd.getNextNumber();
        threads = (int)gd.getNextNumber();
        Prefs.setThreads((int)threads);
        int limit = 1700;
        if (!IJ.is64Bit() && memory > 1700L && !IJ.showMessageWithCancel((String)"Memory", (String)"Note: setting the memory limit to a value\ngreater than 1700MB on a 32-bit system\nmay cause ImageJ to fail to start.")) {
            return;
        }
        MemoryImageJ.writeFileMacOSX(memory);
    }

    private static void writeFileMacOSX(long memory) {
        File infoPList = new File(FijiTools.getImageJDir(), "Contents/Info.plist");
        try {
            String contents = MemoryImageJ.readFile(infoPList);
            String mem = "" + memory + "m";
            FileOutputStream out = new FileOutputStream(infoPList);
            out.write(MemoryImageJ.editInfoPList(contents, mem).getBytes("UTF-8"));
            out.close();
            IJ.showMessage((String)"Memory", (String)("The new " + memory + " limit will take effect after Fiji is restarted."));
        }
        catch (Exception e) {
            IJ.error((String)("Could not write " + infoPList));
        }
    }

    private static String readFile(File file) throws IOException {
        if (!file.exists()) {
            return "";
        }
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream in = new FileInputStream(file);
        in.read(buffer, 0, buffer.length);
        in.close();
        return new String(buffer, 0, buffer.length, "UTF-8");
    }

    private static String editInfoPList(String contents, String memory) {
        String key = "\n\t\t<key>memory</key>\n\t\t<string>" + memory + "</string>";
        Pattern p = Pattern.compile(".*<key>fiji</key>[^<]*<dict>(.*)</dict>.*", flags);
        Matcher matcher = p.matcher(contents);
        if (matcher.matches()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            String inner = contents.substring(start, end);
            p = Pattern.compile(".*<key>(heap|mem|memory)</key>[^<]*<string>([^<]*)</string>.*", flags);
            Matcher matcher2 = p.matcher(inner);
            if (matcher2.matches()) {
                int start2 = start + matcher2.end(2);
                return contents.substring(0, start += matcher2.start(2)) + memory + contents.substring(start2);
            }
            return contents.substring(0, start) + key + contents.substring(start);
        }
        String dict = "\t<key>fiji</key>\n\t<dict>" + key + "\n\t</dict>\n";
        p = Pattern.compile(".*(</dict>).*", flags);
        matcher = p.matcher(contents);
        if (matcher.matches()) {
            int start = matcher.start(1);
            return contents.substring(0, start) + dict + contents.substring(start);
        }
        return "<plist version=\"1.0\">\n<dict>\n" + dict + "</dict>\n</plist>";
    }
}

