/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin;

import com.sun.jna.Native;
import fiji.plugin.Bead_Registration;
import fiji.plugin.Multi_View_Fusion;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.spim.Reconstruction;
import mpicbg.spim.fusion.FusionControl;
import mpicbg.spim.fusion.PreDeconvolutionFusionInterface;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.postprocessing.deconvolution.ExtractPSF;
import mpicbg.spim.postprocessing.deconvolution2.BayesMVDeconvolution;
import mpicbg.spim.postprocessing.deconvolution2.LRFFT;
import mpicbg.spim.postprocessing.deconvolution2.LRInput;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.fiji.plugin.util.GUIHelper;
import spim.process.cuda.CUDAFourierConvolution;

public class Multi_View_Deconvolution
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    public static boolean makeAllPSFSameSize = false;
    public static int psfSize = 17;
    public static boolean isotropic = false;
    public static int[] psfSize3d = null;
    public static float subtractBackground = 0.0f;
    public static ArrayList<String> defaultPSFFileField = null;
    public static boolean defaultOnePSFForAll = true;
    public static boolean defaultTransformPSFs = true;
    public static int defaultExtractPSF = 0;
    public static boolean defaultLoadImagesSequentially = true;
    public static int defaultOutputType = 1;
    public static int defaultOSEMspeedupIndex = 0;
    public static double defaultOSEMspeedup = 1.0;
    public static int defaultNumIterations = 10;
    public static boolean defaultUseTikhonovRegularization = true;
    public static double defaultLambda = 0.006;
    public static int defaultDisplayPSF = 1;
    public static boolean defaultDebugMode = false;
    public static int defaultDebugInterval = 1;
    public static int defaultIterationType = 1;
    public static int defaultContainerInput = 0;
    public static int defaultContainerProcess = 0;
    public static int defaultComputationIndex = 0;
    public static int defaultBlockSizeIndex = 0;
    public static int defaultBlockSizeX = 256;
    public static int defaultBlockSizeY = 256;
    public static int defaultBlockSizeZ = 256;
    public static String[] iterationTypeString = new String[]{"Efficient Bayesian - Optimization II (very fast, imprecise)", "Efficient Bayesian - Optimization I (fast, precise)", "Efficient Bayesian (less fast, more precise)", "Independent (slow, very precise)", "Illustrate overlap of views per pixel (do not deconvolve)"};
    public static String[] imglibContainer = new String[]{"Array container (images smaller ~2048x2048x450 px)", "Cell container (images larger ~2048x2048x450 px)"};
    public static String[] computationOn = new String[]{"CPU (Java)", "GPU (Nvidia CUDA via JNA)"};
    public static String[] osemspeedupChoice = new String[]{"1 (balanced)", "minimal number of overlapping views", "average number of overlapping views", "specify manually"};
    public static String[] extractPSFs = new String[]{"Extract from beads", "Provide file with PSF"};
    public static String[] blocks = new String[]{"Entire image at once", "in 64x64x64 blocks", "in 128x128x128 blocks", "in 256x256x256 blocks", "in 512x512x512 blocks", "in 1024x512x512 blocks", "in 1024x1024x512 blocks", "specify maximal blocksize manually"};
    public static String[] displayPSF = new String[]{"Do not show PSFs", "Show MIP of combined PSF's", "Show combined PSF's", "Show individual PSF's", "Show combined PSF's (original scale)", "Show individual PSF's (original scale)"};
    LRFFT.PSFTYPE iterationType;
    int numIterations;
    int containerInput;
    int containerProcess;
    int computationType;
    int osemspeedupIndex;
    int blockSizeIndex;
    int debugInterval = 1;
    double osemspeedup;
    int[] blockSize = null;
    boolean useTikhonovRegularization = true;
    boolean useBlocks = false;
    boolean useCUDA = false;
    boolean debugMode = false;
    boolean loadImagesSequentially = false;
    boolean extractPSF = true;
    ArrayList<Integer> deviceList = null;
    public static ArrayList<Boolean> deviceChoice = null;
    public static int standardDevice = 10000;
    double lambda = 0.006;

    public void run(String arg0) {
        IOFunctions.printIJLog = true;
        SPIMConfiguration conf = this.getParameters();
        if (conf == null) {
            return;
        }
        conf.readSegmentation = true;
        conf.readRegistration = true;
        conf.isDeconvolution = true;
        IJ.log((String)("Loading images sequentially: " + conf.deconvolutionLoadSequentially));
        conf.instance = this;
        new Reconstruction(conf);
    }

    public void deconvolve(ViewStructure viewStructure, SPIMConfiguration conf, int timePoint) {
        Image<FloatType> psf;
        ArrayList<Object> pointSpreadFunctions;
        FusionControl fusionControl = viewStructure.getFusionControl();
        PreDeconvolutionFusionInterface fusion = (PreDeconvolutionFusionInterface)((Object)fusionControl.getFusion());
        if (conf.deconvolutionJustShowOverlap) {
            fusion.getOverlapImage().getDisplay().setMinMax();
            ImagePlus overlap = ImageJFunctions.copyToImagePlus(fusion.getOverlapImage());
            overlap.setTitle("overlap for each pixel [" + viewStructure.getSPIMConfiguration().inputFilePattern + "]");
            overlap.show();
            return;
        }
        int numViews = viewStructure.getNumViews();
        int[] size = null;
        if (makeAllPSFSameSize || conf.deconvolutionDisplayPSF >= 3) {
            size = ExtractPSF.commonSize(fusion.getPointSpreadFunctions());
        }
        if (makeAllPSFSameSize) {
            pointSpreadFunctions = new ArrayList();
            for (Image<FloatType> image : fusion.getPointSpreadFunctions()) {
                pointSpreadFunctions.add(ExtractPSF.makeSameSize(image, size));
            }
        } else {
            pointSpreadFunctions = fusion.getPointSpreadFunctions();
        }
        if (conf.deconvolutionDisplayPSF == 1) {
            ImageJFunctions.show(fusion.getExtractPSFInstance().getMaxProjectionAveragePSF());
        } else if (conf.deconvolutionDisplayPSF == 2) {
            ImageJFunctions.show(fusion.getExtractPSFInstance().getAveragePSF());
        } else if (conf.deconvolutionDisplayPSF == 4) {
            ImageJFunctions.show(fusion.getExtractPSFInstance().getAverageOriginalPSF());
        } else if (conf.deconvolutionDisplayPSF == 3) {
            for (int i = 0; i < viewStructure.getNumViews(); ++i) {
                psf = (Image<FloatType>)pointSpreadFunctions.get(i);
                String title = "PSF for " + viewStructure.getViews().get(i).getName();
                if (makeAllPSFSameSize) {
                    psf.getDisplay().setMinMax();
                    ImagePlus imp = ImageJFunctions.copyToImagePlus(psf);
                    imp.setTitle(title);
                    imp.show();
                    continue;
                }
                Image<FloatType> tmp = ExtractPSF.makeSameSize(psf, size);
                tmp.getDisplay().setMinMax();
                ImagePlus imp = ImageJFunctions.copyToImagePlus(tmp);
                imp.setTitle(title);
                imp.show();
            }
        } else if (conf.deconvolutionDisplayPSF == 5) {
            for (int i = 0; i < viewStructure.getNumViews(); ++i) {
                psf = fusion.getExtractPSFInstance().getPSFsInInputCalibration().get(i);
                psf.getDisplay().setMinMax();
                ImagePlus imp = ImageJFunctions.copyToImagePlus(psf);
                imp.setTitle("(original scale) PSF for " + viewStructure.getViews().get(i).getName());
                imp.show();
            }
        }
        for (ViewDataBeads view : viewStructure.getViews()) {
            view.closeImage();
        }
        LRInput deconvolutionData = new LRInput();
        IJ.log((String)("Type of iteration: " + (Object)((Object)this.iterationType)));
        IJ.log((String)("Number iterations: " + this.numIterations));
        IJ.log((String)("Using blocks: " + this.useBlocks));
        if (this.useBlocks) {
            IJ.log((String)("Block size: " + Util.printCoordinates((int[])this.blockSize)));
        }
        IJ.log((String)("Using CUDA: " + this.useCUDA));
        if (this.debugMode) {
            IJ.log((String)("Debugging every " + this.debugInterval + " iterations."));
        }
        IJ.log((String)("ImgLib container (input files): " + conf.inputImageFactory.getClass().getSimpleName()));
        IJ.log((String)("ImgLib container (deconvolved): " + conf.processImageFactory.getClass().getSimpleName()));
        if (this.useTikhonovRegularization) {
            IJ.log((String)("Using Tikhonov regularization (lambda = " + this.lambda + ")"));
        } else {
            IJ.log((String)"Not using Tikhonov regularization");
        }
        BayesMVDeconvolution.debug = this.debugMode;
        BayesMVDeconvolution.debugInterval = this.debugInterval;
        for (int view = 0; view < numViews; ++view) {
            int[] devList = new int[this.deviceList.size()];
            for (int i = 0; i < devList.length; ++i) {
                devList[i] = this.deviceList.get(i);
            }
            deconvolutionData.add(new LRFFT(fusion.getFusedImage(view), fusion.getWeightImage(view), (Image<FloatType>)((Image)pointSpreadFunctions.get(view)), devList, this.useBlocks, this.blockSize));
        }
        Image<FloatType> deconvolved = this.useTikhonovRegularization ? new BayesMVDeconvolution(deconvolutionData, this.iterationType, this.numIterations, this.lambda, this.osemspeedup, this.osemspeedupIndex, "deconvolved").getPsi() : new BayesMVDeconvolution(deconvolutionData, this.iterationType, this.numIterations, 0.0, this.osemspeedup, this.osemspeedupIndex, "deconvolved").getPsi();
        if (conf.writeOutputImage > 0 || conf.showOutputImage) {
            String name = viewStructure.getSPIMConfiguration().inputFilePattern;
            String replaceTP = SPIMConfiguration.getReplaceStringTimePoints(name);
            String replaceChannel = SPIMConfiguration.getReplaceStringChannels(name);
            if (replaceTP != null) {
                name = name.replace(replaceTP, "" + conf.timepoints[0]);
            }
            if (replaceChannel != null) {
                name = name.replace(replaceChannel, "" + conf.channelsFuse[0]);
            }
            deconvolved.setName("DC(l=" + this.lambda + ")_" + name);
            if (conf.showOutputImage) {
                deconvolved.getDisplay().setMinMax(0.0, 1.0);
                ImageJFunctions.copyToImagePlus(deconvolved).show();
            }
            if (conf.writeOutputImage == 1) {
                ImageJFunctions.saveAsTiffs(deconvolved, (String)conf.outputdirectory, (String)("DC(l=" + this.lambda + ")_t" + timePoint + "_ch" + viewStructure.getChannelNum(0)), (int)2);
            } else if (conf.writeOutputImage == 2) {
                File dir = new File(conf.outputdirectory, "" + timePoint);
                if (!dir.exists() && !dir.mkdirs()) {
                    IOFunctions.printErr("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + dir.getAbsolutePath() + "', quitting.");
                    return;
                }
                if (this.useTikhonovRegularization) {
                    ImageJFunctions.saveAsTiffs(deconvolved, (String)dir.getAbsolutePath(), (String)("DC(l=" + this.lambda + ")_t" + timePoint + "_ch" + viewStructure.getChannelNum(0)), (int)2);
                } else {
                    ImageJFunctions.saveAsTiffs(deconvolved, (String)dir.getAbsolutePath(), (String)("DC(l=0)_t" + timePoint + "_ch" + viewStructure.getChannelNum(0)), (int)2);
                }
            }
        }
    }

    protected SPIMConfiguration getParameters() {
        int c;
        int i;
        int c2;
        GenericDialogPlus gd = new GenericDialogPlus("Multi-View Deconvolution");
        gd.addDirectoryField("SPIM_data_directory", Bead_Registration.spimDataDirectory);
        gd.addStringField("Pattern_of_SPIM files", Bead_Registration.fileNamePattern, 25);
        gd.addStringField("Timepoints_to_process", Bead_Registration.timepoints);
        gd.addStringField("Angles to process", Bead_Registration.angles);
        gd.addMessage("");
        gd.addChoice("ImgLib_container_(input files)", imglibContainer, imglibContainer[defaultContainerInput]);
        gd.addChoice("ImgLib_container_(processing)", imglibContainer, imglibContainer[defaultContainerProcess]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Bead_Registration.spimDataDirectory = gd.getNextString();
        Bead_Registration.fileNamePattern = gd.getNextString();
        Bead_Registration.timepoints = gd.getNextString();
        Bead_Registration.angles = gd.getNextString();
        this.containerInput = defaultContainerInput = gd.getNextChoiceIndex();
        this.containerProcess = defaultContainerProcess = gd.getNextChoiceIndex();
        int numViews = -1;
        try {
            numViews = SPIMConfiguration.parseIntegerString(Bead_Registration.angles).size();
        }
        catch (ConfigurationParserException e) {
            IOFunctions.printErr("Cannot understand/parse the channels: " + Bead_Registration.angles);
            return null;
        }
        ArrayList<Integer> channels = new ArrayList<Integer>();
        channels.add(0);
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.timepointPattern = Bead_Registration.timepoints;
        conf.anglePattern = Bead_Registration.angles;
        conf.channelPattern = "";
        conf.channelsToRegister = "";
        conf.channelsToFuse = "";
        conf.inputFilePattern = Bead_Registration.fileNamePattern;
        conf.inputdirectory = Bead_Registration.spimDataDirectory;
        if (!Bead_Registration.init(conf)) {
            return null;
        }
        ArrayList timepoints = new ArrayList();
        int numChoices = 0;
        conf.zStretching = -1.0;
        for (int c3 = 0; c3 < channels.size(); ++c3) {
            timepoints.add(new ArrayList());
            final String name = conf.file[0][c3][0][0].getName();
            File regDir = new File(conf.registrationFiledirectory);
            if (!regDir.isDirectory()) {
                IOFunctions.println(conf.registrationFiledirectory + " is not a directory. ");
                return null;
            }
            String[] entries = regDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.contains(name) && filename.contains(".registration");
                }
            });
            String[] entriesBeads = regDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.contains(name) && filename.contains(".beads.txt");
                }
            });
            for (String s : entries) {
                if (s.endsWith(".registration")) {
                    String query = s.substring(0, s.length() - new String("registration").length());
                    boolean isPresent = false;
                    for (String beadFile : entriesBeads) {
                        if (!beadFile.contains(query)) continue;
                        isPresent = true;
                    }
                    if (!((ArrayList)timepoints.get(c3)).contains(-1) && isPresent) {
                        ((ArrayList)timepoints.get(c3)).add(-1);
                        ++numChoices;
                    }
                } else if (s.contains(".registration.to_")) {
                    int timepoint = Integer.parseInt(s.substring(s.indexOf(".registration.to_") + 17, s.length()));
                    String query = s.substring(0, s.length() - new String("registration.to_" + timepoint).length());
                    boolean isPresent = false;
                    for (String beadFile : entriesBeads) {
                        if (!beadFile.contains(query)) continue;
                        isPresent = true;
                    }
                    if (!((ArrayList)timepoints.get(c3)).contains(timepoint) && isPresent) {
                        ((ArrayList)timepoints.get(c3)).add(timepoint);
                        ++numChoices;
                    }
                }
                if (!(conf.zStretching < 0.0)) continue;
                conf.zStretching = Multi_View_Fusion.loadZStretching(conf.registrationFiledirectory + s);
                IOFunctions.println("Z-stretching = " + conf.zStretching);
            }
        }
        if (numChoices == 0) {
            IOFunctions.println("No bead-based segmentation (*.beads.txt) and/or registration (*.registration) files available.");
            return null;
        }
        GenericDialog gd2 = new GenericDialog("Multi-View Deconvolution");
        String[] choices = new String[numChoices];
        int[] suggest = new int[channels.size()];
        int firstSuggestion = -1;
        int index = 0;
        for (c2 = 0; c2 < channels.size(); ++c2) {
            ArrayList tps = (ArrayList)timepoints.get(c2);
            suggest[c2] = -1;
            for (int i2 = 0; i2 < tps.size(); ++i2) {
                choices[index] = (Integer)tps.get(i2) == -1 ? "Individual registration of channel " + channels.get(c2) : "Time-point registration (reference=" + tps.get(i2) + ") of channel " + channels.get(c2);
                if (suggest[c2] == -1) {
                    suggest[c2] = index;
                    if (firstSuggestion == -1) {
                        firstSuggestion = index;
                    }
                }
                ++index;
            }
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            if (suggest[c2] != -1) continue;
            suggest[c2] = firstSuggestion;
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            gd2.addChoice("Registration for channel " + channels.get(c2), choices, choices[suggest[c2]]);
        }
        gd2.addMessage("");
        gd2.addNumericField("Crop_output_image_offset_x", (double)Multi_View_Fusion.cropOffsetXStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_y", (double)Multi_View_Fusion.cropOffsetYStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_z", (double)Multi_View_Fusion.cropOffsetZStatic, 0);
        gd2.addNumericField("Crop_output_image_size_x", (double)Multi_View_Fusion.cropSizeXStatic, 0);
        gd2.addNumericField("Crop_output_image_size_y", (double)Multi_View_Fusion.cropSizeYStatic, 0);
        gd2.addNumericField("Crop_output_image_size_z", (double)Multi_View_Fusion.cropSizeZStatic, 0);
        gd2.addMessage("");
        gd2.addChoice("Type_of_iteration", iterationTypeString, iterationTypeString[defaultIterationType]);
        gd2.addChoice("OSEM_acceleration", osemspeedupChoice, osemspeedupChoice[defaultOSEMspeedupIndex]);
        gd2.addNumericField("Number_of_iterations", (double)defaultNumIterations, 0);
        gd2.addCheckbox("Use_Tikhonov_regularization", defaultUseTikhonovRegularization);
        gd2.addNumericField("Tikhonov_parameter", defaultLambda, 4);
        gd2.addChoice("Compute", blocks, blocks[defaultBlockSizeIndex]);
        gd2.addChoice("Compute_on", computationOn, computationOn[defaultComputationIndex]);
        gd2.addChoice("PSF_estimation", extractPSFs, extractPSFs[defaultExtractPSF]);
        gd2.addChoice("PSF_display", displayPSF, displayPSF[defaultDisplayPSF]);
        gd2.addCheckbox("Debug_mode", defaultDebugMode);
        gd2.addMessage("");
        gd2.addCheckbox("Load_input_images_sequentially", defaultLoadImagesSequentially);
        gd2.addChoice("Fused_image_output", Multi_View_Fusion.outputType, Multi_View_Fusion.outputType[defaultOutputType]);
        gd2.addMessage("");
        gd2.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        text = (MultiLineLabel)gd2.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return null;
        }
        int[][] registrationAssignment = new int[channels.size()][2];
        for (int c4 = 0; c4 < channels.size(); ++c4) {
            int choice = gd2.getNextChoiceIndex();
            index = 0;
            for (int c22 = 0; c22 < channels.size(); ++c22) {
                ArrayList tps = (ArrayList)timepoints.get(c22);
                for (i = 0; i < tps.size(); ++i) {
                    if (index == choice) {
                        registrationAssignment[c4][0] = (Integer)tps.get(i);
                        registrationAssignment[c4][1] = c22;
                    }
                    ++index;
                }
            }
        }
        int tp = registrationAssignment[0][0];
        for (c = 1; c < channels.size(); ++c) {
            if (tp == registrationAssignment[c][0]) continue;
            IOFunctions.println("Inconsistent choice of reference timeseries, only same reference timepoints or individual registration are allowed.");
            return null;
        }
        conf.registrationAssignmentForFusion = new int[channels.size()];
        for (c = 0; c < channels.size(); ++c) {
            IOFunctions.println("channel " + c + " takes it from channel " + registrationAssignment[c][1]);
            conf.registrationAssignmentForFusion[c] = registrationAssignment[c][1];
        }
        if (tp >= 0) {
            conf.timeLapseRegistration = true;
            conf.referenceTimePoint = tp;
            ArrayList<Integer> tpList = null;
            try {
                tpList = SPIMConfiguration.parseIntegerString(conf.timepointPattern);
            }
            catch (ConfigurationParserException e) {
                e.printStackTrace();
                IJ.log((String)("Cannot parse time-point pattern: " + conf.timepointPattern));
                return null;
            }
            if (!tpList.contains(tp)) {
                conf.timepointPattern = conf.timepointPattern + ", " + tp;
                conf.fuseReferenceTimepoint = false;
                if (!Bead_Registration.init(conf)) {
                    return null;
                }
            }
        }
        Multi_View_Fusion.cropOffsetXStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropOffsetYStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropOffsetZStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropSizeXStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropSizeYStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropSizeZStatic = (int)Math.round(gd2.getNextNumber());
        defaultIterationType = gd2.getNextChoiceIndex();
        conf.deconvolutionJustShowOverlap = false;
        if (defaultIterationType == 0) {
            this.iterationType = LRFFT.PSFTYPE.OPTIMIZATION_II;
        } else if (defaultIterationType == 1) {
            this.iterationType = LRFFT.PSFTYPE.OPTIMIZATION_I;
        } else if (defaultIterationType == 2) {
            this.iterationType = LRFFT.PSFTYPE.EFFICIENT_BAYESIAN;
        } else if (defaultIterationType == 3) {
            this.iterationType = LRFFT.PSFTYPE.INDEPENDENT;
        } else {
            conf.deconvolutionJustShowOverlap = true;
        }
        this.osemspeedupIndex = defaultOSEMspeedupIndex = gd2.getNextChoiceIndex();
        this.numIterations = defaultNumIterations = (int)Math.round(gd2.getNextNumber());
        this.useTikhonovRegularization = defaultUseTikhonovRegularization = gd2.getNextBoolean();
        this.lambda = defaultLambda = gd2.getNextNumber();
        this.blockSizeIndex = defaultBlockSizeIndex = gd2.getNextChoiceIndex();
        this.computationType = defaultComputationIndex = gd2.getNextChoiceIndex();
        defaultExtractPSF = gd2.getNextChoiceIndex();
        defaultDisplayPSF = gd2.getNextChoiceIndex();
        defaultDebugMode = this.debugMode = gd2.getNextBoolean();
        defaultLoadImagesSequentially = this.loadImagesSequentially = gd2.getNextBoolean();
        if (defaultExtractPSF == 0) {
            this.extractPSF = true;
        } else {
            this.extractPSF = false;
            GenericDialogPlus gd3 = new GenericDialogPlus("Load PSF File ...");
            gd3.addCheckbox("Use same PSF for all views", defaultOnePSFForAll);
            gd3.showDialog();
            if (gd3.wasCanceled()) {
                return null;
            }
            defaultOnePSFForAll = gd3.getNextBoolean();
            GenericDialogPlus gd4 = new GenericDialogPlus("Select PSF File ...");
            gd4.addMessage("Note: the calibration of the PSF(s) has to match\nthe calibration of the input views if you choose\nto transform them according to the registration of\nthe views!");
            gd4.addMessage("");
            gd4.addCheckbox("Transform_PSFs", defaultTransformPSFs);
            gd4.addMessage("");
            int numPSFs = defaultOnePSFForAll ? 1 : numViews;
            if (defaultPSFFileField == null) {
                defaultPSFFileField = new ArrayList();
            }
            if (defaultPSFFileField.size() < numPSFs) {
                for (i = 0; i < numPSFs; ++i) {
                    defaultPSFFileField.add("");
                }
            } else if (defaultPSFFileField.size() > numPSFs) {
                for (i = numPSFs; i < defaultPSFFileField.size(); ++i) {
                    defaultPSFFileField.remove(numPSFs);
                }
            }
            if (defaultOnePSFForAll) {
                gd4.addFileField("PSF_file", defaultPSFFileField.get(0));
            } else {
                for (i = 0; i < numPSFs; ++i) {
                    gd4.addFileField("PSF_file_view_" + i, defaultPSFFileField.get(i));
                }
            }
            gd4.showDialog();
            if (gd4.wasCanceled()) {
                return null;
            }
            conf.transformPSFs = defaultTransformPSFs = gd4.getNextBoolean();
            defaultPSFFileField.clear();
            for (i = 0; i < numPSFs; ++i) {
                defaultPSFFileField.add(gd4.getNextString());
            }
            conf.psfFiles = new ArrayList();
            if (defaultOnePSFForAll) {
                for (i = 0; i < numViews; ++i) {
                    conf.psfFiles.add(defaultPSFFileField.get(0));
                }
            } else {
                conf.psfFiles.addAll(defaultPSFFileField);
            }
        }
        defaultOutputType = gd2.getNextChoiceIndex();
        if (this.blockSizeIndex == 0) {
            this.useBlocks = false;
            this.blockSize = null;
        } else if (this.blockSizeIndex == 1) {
            this.useBlocks = true;
            this.blockSize = new int[]{64, 64, 64};
        } else if (this.blockSizeIndex == 2) {
            this.useBlocks = true;
            this.blockSize = new int[]{128, 128, 128};
        } else if (this.blockSizeIndex == 3) {
            this.useBlocks = true;
            this.blockSize = new int[]{256, 256, 256};
        } else if (this.blockSizeIndex == 4) {
            this.useBlocks = true;
            this.blockSize = new int[]{512, 512, 512};
        } else if (this.blockSizeIndex == 5) {
            this.useBlocks = true;
            this.blockSize = new int[]{1024, 512, 512};
        } else if (this.blockSizeIndex == 6) {
            this.useBlocks = true;
            this.blockSize = new int[]{1024, 1024, 512};
        }
        if (this.blockSizeIndex == 7) {
            GenericDialog gd3 = new GenericDialog("Define block sizes");
            gd3.addNumericField("blocksize_x", (double)defaultBlockSizeX, 0);
            gd3.addNumericField("blocksize_y", (double)defaultBlockSizeY, 0);
            gd3.addNumericField("blocksize_z", (double)defaultBlockSizeZ, 0);
            gd3.showDialog();
            if (gd3.wasCanceled()) {
                return null;
            }
            defaultBlockSizeX = Math.max(1, (int)Math.round(gd3.getNextNumber()));
            defaultBlockSizeY = Math.max(1, (int)Math.round(gd3.getNextNumber()));
            defaultBlockSizeZ = Math.max(1, (int)Math.round(gd3.getNextNumber()));
            this.useBlocks = true;
            this.blockSize = new int[]{defaultBlockSizeX, defaultBlockSizeY, defaultBlockSizeZ};
        }
        this.deviceList = new ArrayList();
        if (this.computationType == 0) {
            this.useCUDA = false;
            this.deviceList.add(-1);
        } else {
            try {
                LRFFT.cuda = (CUDAFourierConvolution)Native.load((String)"Convolution3D_fftCUDAlib", CUDAFourierConvolution.class);
            }
            catch (UnsatisfiedLinkError e) {
                IJ.log((String)("Cannot find CUDA JNA library: " + e));
                return null;
            }
            int numDevices = LRFFT.cuda.getNumDevicesCUDA();
            if (numDevices == 0) {
                IJ.log((String)"No CUDA devices detected, only CPU will be available.");
            } else {
                IJ.log((String)("numdevices = " + numDevices));
                this.useCUDA = true;
            }
            String[] devices = new String[numDevices];
            byte[] name = new byte[256];
            int highestComputeCapability = 0;
            long highestMemory = 0L;
            int highestComputeCapabilityDevice = -1;
            int highestMemoryDevice = -1;
            for (int i3 = 0; i3 < numDevices; ++i3) {
                LRFFT.cuda.getNameDeviceCUDA(i3, name);
                devices[i3] = "GPU_" + (i3 + 1) + " of " + numDevices + ": ";
                for (byte b : name) {
                    if (b == 0) continue;
                    devices[i3] = devices[i3] + (char)b;
                }
                devices[i3].trim();
                long mem = LRFFT.cuda.getMemDeviceCUDA(i3);
                int compCap = 10 * LRFFT.cuda.getCUDAcomputeCapabilityMajorVersion(i3) + LRFFT.cuda.getCUDAcomputeCapabilityMinorVersion(i3);
                if (compCap > highestComputeCapability) {
                    highestComputeCapability = compCap;
                    highestComputeCapabilityDevice = i3;
                }
                if (mem > highestMemory) {
                    highestMemory = mem;
                    highestMemoryDevice = i3;
                }
                devices[i3] = devices[i3] + " (" + mem / 0x100000L + " MB, CUDA capability " + LRFFT.cuda.getCUDAcomputeCapabilityMajorVersion(i3) + "." + LRFFT.cuda.getCUDAcomputeCapabilityMinorVersion(i3) + ")";
            }
            String cpuSpecs = "CPU (" + Runtime.getRuntime().availableProcessors() + " cores, " + Runtime.getRuntime().maxMemory() / 0x100000L + " MB RAM available)";
            if (this.useBlocks) {
                int i4;
                if (deviceChoice == null || deviceChoice.size() != devices.length + 1) {
                    deviceChoice = new ArrayList(devices.length + 1);
                    for (int i5 = 0; i5 < devices.length; ++i5) {
                        deviceChoice.add(true);
                    }
                    deviceChoice.add(false);
                }
                GenericDialog gdCUDA = new GenericDialog("Choose CUDA/CPUs devices to use");
                for (i4 = 0; i4 < devices.length; ++i4) {
                    gdCUDA.addCheckbox(devices[i4], deviceChoice.get(i4).booleanValue());
                }
                gdCUDA.addCheckbox(cpuSpecs, deviceChoice.get(devices.length).booleanValue());
                gdCUDA.showDialog();
                if (gdCUDA.wasCanceled()) {
                    return null;
                }
                for (i4 = 0; i4 < devices.length; ++i4) {
                    if (gdCUDA.getNextBoolean()) {
                        this.deviceList.add(i4);
                        deviceChoice.set(i4, true);
                        continue;
                    }
                    deviceChoice.set(i4, false);
                }
                if (gdCUDA.getNextBoolean()) {
                    this.deviceList.add(-1);
                    deviceChoice.set(devices.length, true);
                } else {
                    deviceChoice.set(devices.length, false);
                }
                for (int i6 : this.deviceList) {
                    if (i6 >= 0) {
                        IJ.log((String)("Using device " + devices[i6]));
                        continue;
                    }
                    if (i6 != -1) continue;
                    IJ.log((String)("Using device " + cpuSpecs));
                }
                if (this.deviceList.size() == 0) {
                    IJ.log((String)"You selected no device, quitting.");
                    return null;
                }
            } else {
                GenericDialog gdCUDA = new GenericDialog("Choose CUDA device");
                if (standardDevice >= devices.length) {
                    standardDevice = highestComputeCapabilityDevice;
                }
                gdCUDA.addChoice("Device", devices, devices[standardDevice]);
                gdCUDA.showDialog();
                if (gdCUDA.wasCanceled()) {
                    return null;
                }
                standardDevice = gdCUDA.getNextChoiceIndex();
                this.deviceList.add(standardDevice);
                IJ.log((String)("Using device " + devices[this.deviceList.get(0)]));
            }
        }
        if (this.debugMode) {
            GenericDialog gdDebug = new GenericDialog("Debug options");
            gdDebug.addNumericField("Show debug output every n'th frame, n = ", (double)defaultDebugInterval, 0);
            gdDebug.showDialog();
            if (gdDebug.wasCanceled()) {
                return null;
            }
            defaultDebugInterval = this.debugInterval = (int)Math.round(gdDebug.getNextNumber());
        }
        if (this.osemspeedupIndex == 0) {
            this.osemspeedup = 1.0;
            defaultOSEMspeedup = 1.0;
        } else if (this.osemspeedupIndex == 3) {
            GenericDialog gdOSEM = new GenericDialog("OSEM options");
            gdOSEM.addNumericField("Additional_acceleration = ", defaultOSEMspeedup, 2);
            gdOSEM.showDialog();
            if (gdOSEM.wasCanceled()) {
                return null;
            }
            defaultOSEMspeedup = this.osemspeedup = gdOSEM.getNextNumber();
        }
        conf.paralellFusion = false;
        conf.sequentialFusion = false;
        conf.multipleImageFusion = false;
        conf.isDeconvolution = true;
        conf.deconvolutionLoadSequentially = this.loadImagesSequentially;
        conf.deconvolutionDisplayPSF = defaultDisplayPSF;
        conf.extractPSF = this.extractPSF;
        conf.showOutputImage = defaultOutputType == 0;
        conf.writeOutputImage = defaultOutputType;
        conf.useLinearBlening = true;
        conf.useGaussContentBased = false;
        conf.useIntegralContentBased = false;
        conf.scale = 1;
        conf.cropOffsetX = Multi_View_Fusion.cropOffsetXStatic;
        conf.cropOffsetY = Multi_View_Fusion.cropOffsetYStatic;
        conf.cropOffsetZ = Multi_View_Fusion.cropOffsetZStatic;
        conf.cropSizeX = Multi_View_Fusion.cropSizeXStatic;
        conf.cropSizeY = Multi_View_Fusion.cropSizeYStatic;
        conf.cropSizeZ = Multi_View_Fusion.cropSizeZStatic;
        conf.inputImageFactory = this.containerInput == 1 ? new CellContainerFactory(128) : new ArrayContainerFactory();
        conf.processImageFactory = this.containerProcess == 1 ? new CellContainerFactory(128) : new ArrayContainerFactory();
        conf.overrideImageZStretching = true;
        return conf;
    }
}

