/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.model;

import java.util.Collection;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;

public class TranslationInvariantAffineModel3D
extends TranslationInvariantModel<TranslationInvariantAffineModel3D> {
    protected static final int MIN_NUM_MATCHES = 4;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;

    @Override
    public boolean canDoNumDimension(int numDimensions) {
        return numDimensions == 3;
    }

    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 4) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d affine model, at least " + 4 + " data points required.");
        }
        double b22 = 0.0;
        double b21 = 0.0;
        double b20 = 0.0;
        double b12 = 0.0;
        double b11 = 0.0;
        double b10 = 0.0;
        double b02 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a22 = 0.0;
        double a12 = 0.0;
        double a11 = 0.0;
        double a02 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double px = p[0];
            double py = p[1];
            double pz = p[2];
            double qx = q[0];
            double qy = q[1];
            double qz = q[2];
            a00 += w * px * px;
            a01 += w * px * py;
            a02 += w * px * pz;
            a11 += w * py * py;
            a12 += w * py * pz;
            a22 += w * pz * pz;
            b00 += w * px * qx;
            b01 += w * px * qy;
            b02 += w * px * qz;
            b10 += w * py * qx;
            b11 += w * py * qy;
            b12 += w * py * qz;
            b20 += w * pz * qx;
            b21 += w * pz * qy;
            b22 += w * pz * qz;
        }
        double det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        double idet = 1.0 / det;
        double ai00 = (a11 * a22 - a12 * a12) * idet;
        double ai01 = (a02 * a12 - a01 * a22) * idet;
        double ai02 = (a01 * a12 - a02 * a11) * idet;
        double ai11 = (a00 * a22 - a02 * a02) * idet;
        double ai12 = (a02 * a01 - a00 * a12) * idet;
        double ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
    }

    public final void set(TranslationInvariantAffineModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.cost = m.cost;
    }

    public TranslationInvariantAffineModel3D copy() {
        TranslationInvariantAffineModel3D m = new TranslationInvariantAffineModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.cost = this.cost;
        return m;
    }

    public final int getMinNumMatches() {
        return 4;
    }

    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    public final void applyInPlace(double[] l) {
        assert (l.length == 3) : "3d affine transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22;
    }

    public final String toString() {
        return "3d-affine: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ")";
    }
}

