/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.model;

import java.util.Collection;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;

public class TranslationInvariantRigidModel2D
extends TranslationInvariantModel<TranslationInvariantRigidModel2D> {
    protected static final int MIN_NUM_MATCHES = 2;
    protected double cos = 1.0;
    protected double sin = 0.0;
    protected double itx = 0.0;
    protected double ity = 0.0;

    @Override
    public boolean canDoNumDimension(int numDimensions) {
        return numDimensions == 2;
    }

    public final int getMinNumMatches() {
        return 2;
    }

    public final double[] apply(double[] l) {
        assert (l.length == 2) : "2d rigid transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    public final void applyInPlace(double[] l) {
        assert (l.length == 2) : "2d rigid transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = this.cos * l0 - this.sin * l[1];
        l[1] = this.sin * l0 + this.cos * l[1];
    }

    public TranslationInvariantRigidModel2D copy() {
        TranslationInvariantRigidModel2D m = new TranslationInvariantRigidModel2D();
        m.cos = this.cos;
        m.sin = this.sin;
        m.itx = this.itx;
        m.ity = this.ity;
        m.cost = this.cost;
        return m;
    }

    public final void set(TranslationInvariantRigidModel2D m) {
        this.cos = m.cos;
        this.sin = m.sin;
        this.itx = m.itx;
        this.ity = m.ity;
        this.cost = m.cost;
    }

    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        this.cos = 0.0;
        this.sin = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double x1 = p[0];
            double y1 = p[1];
            double x2 = q[0];
            double y2 = q[1];
            this.sin += w * (x1 * y2 - y1 * x2);
            this.cos += w * (x1 * x2 + y1 * y2);
        }
        double norm = Math.sqrt(this.cos * this.cos + this.sin * this.sin);
        this.cos /= norm;
        this.sin /= norm;
    }
}

