/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.test;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import ij.ImageJ;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import mpicbg.models.AffineModel3D;
import mpicbg.models.Point;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.pointdescriptor.LocalCoordinateSystemPointDescriptor;
import mpicbg.pointdescriptor.ModelPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.matcher.SimpleMatcher;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel3D;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import mpicbg.pointdescriptor.similarity.SquareDistance;
import mpicbg.pointdescriptor.test.VirtualPointNode;
import mpicbg.util.TransformUtils;
import net.imglib2.util.Util;
import spim.vecmath.Matrix3f;
import spim.vecmath.Point3f;
import spim.vecmath.Quat4f;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3f;

public class TestPointDescriptor {
    protected static void add(Point p1, Point p2) {
        double[] l1 = p1.getL();
        double[] w1 = p1.getW();
        double[] l2 = p2.getL();
        double[] w2 = p2.getW();
        for (int d = 0; d < l1.length; ++d) {
            int n = d;
            l1[n] = l1[n] + l2[d];
            int n2 = d;
            w1[n2] = w1[n2] + w2[d];
        }
    }

    protected void addSimplePoints(ArrayList<Point> points1, ArrayList<Point> points2) {
        points1.add(new Point(new double[]{0.0, 0.0, 0.0}));
        points1.add(new Point(new double[]{0.0, 0.0, 1.1f}));
        points1.add(new Point(new double[]{0.0, 1.2f, 0.0}));
        points1.add(new Point(new double[]{1.3f, 0.0, 0.0}));
        points1.add(new Point(new double[]{1.3f, 1.4f, 0.0}));
        Point offset = new Point(new double[]{1.0, 2.0, 3.0});
        Iterator<Point> i = points1.iterator();
        while (i.hasNext()) {
            Point p2 = new Point((double[])i.next().getL().clone());
            TestPointDescriptor.add(p2, offset);
            points2.add(p2);
        }
        points1.add(new Point(new double[]{0.1f, 0.1f, 0.1f}));
    }

    protected void addAdvancedPoints(ArrayList<Point> points1, ArrayList<Point> points2) {
        Point p2;
        double v3;
        double v2;
        double v1;
        int i;
        int commonPoints = 10;
        int randomPoints = 100;
        int offsetX = 5;
        int offsetY = -10;
        int offsetZ = 7;
        Random rnd = new Random(325235325L);
        for (i = 0; i < 10; ++i) {
            v1 = rnd.nextDouble() * 5.0 + 5.0;
            v2 = rnd.nextDouble() * 5.0 + 5.0;
            v3 = rnd.nextDouble() * 5.0 + 5.0;
            double o1 = (rnd.nextDouble() - 0.5) / 10.0;
            double o2 = (rnd.nextDouble() - 0.5) / 10.0;
            double o3 = (rnd.nextDouble() - 0.5) / 10.0;
            Point p1 = new Point(new double[]{v1 + o1, v2 + o2, v3 + o3});
            Point p22 = new Point(new double[]{v1 + 5.0, v2 + -10.0, v3 + 7.0});
            points1.add(p1);
            points2.add(p22);
        }
        for (i = 0; i < 100; ++i) {
            v1 = rnd.nextDouble() * 90.0;
            v2 = rnd.nextDouble() * 90.0;
            v3 = rnd.nextDouble() * 90.0;
            Point p1 = new Point(new double[]{v1, v2, v3});
            v1 = rnd.nextDouble() * 90.0;
            v2 = rnd.nextDouble() * 90.0;
            v3 = rnd.nextDouble() * 90.0;
            p2 = new Point(new double[]{v1, v2, v3});
            points1.add(p1);
            points2.add(p2);
        }
        for (i = 0; i < 10; ++i) {
            v1 = rnd.nextDouble() * 5.0;
            v2 = rnd.nextDouble() * 5.0;
            v3 = rnd.nextDouble() * 5.0;
            Point p1 = new Point(new double[]{v1, v2, v3});
            v1 = rnd.nextDouble() * 5.0;
            v2 = rnd.nextDouble() * 5.0;
            v3 = rnd.nextDouble() * 5.0;
            p2 = new Point(new double[]{v1, v2, v3});
            points1.add(p1);
            points2.add(p2);
        }
    }

    protected void applyTransform(ArrayList<Point> points) {
        Transform3D trans = new Transform3D();
        trans.rotX(Math.toRadians(30.0));
        AffineModel3D model = TransformUtils.getAffineModel3D(trans);
        for (Point p : points) {
            model.apply(p.getL());
            model.apply(p.getW());
        }
    }

    public static <P extends Point> ArrayList<VirtualPointNode<P>> createVirtualNodeList(ArrayList<P> points) {
        ArrayList<VirtualPointNode<P>> nodeList = new ArrayList<VirtualPointNode<P>>();
        for (Point point : points) {
            nodeList.add(new VirtualPointNode<Point>(point));
        }
        return nodeList;
    }

    public static <P extends Point> ArrayList<ModelPointDescriptor<P>> createModelPointDescriptors(KDTree<VirtualPointNode<P>> tree, ArrayList<VirtualPointNode<P>> basisPoints, int numNeighbors, TranslationInvariantModel<?> model, Matcher matcher, SimilarityMeasure similarityMeasure) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<ModelPointDescriptor<P>> descriptors = new ArrayList<ModelPointDescriptor<P>>();
        for (VirtualPointNode<P> p : basisPoints) {
            ArrayList neighbors = new ArrayList();
            VirtualPointNode[] neighborList = (VirtualPointNode[])nnsearch.findNNearestNeighbors(p, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n].getPoint());
            }
            try {
                descriptors.add(new ModelPointDescriptor<P>(p.getPoint(), neighbors, model, similarityMeasure, matcher));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }

    public static <P extends Point> ArrayList<LocalCoordinateSystemPointDescriptor<P>> createLocalCoordinateSystemPointDescriptors(KDTree<VirtualPointNode<P>> tree, ArrayList<VirtualPointNode<P>> basisPoints, int numNeighbors, boolean normalize) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<LocalCoordinateSystemPointDescriptor<P>> descriptors = new ArrayList<LocalCoordinateSystemPointDescriptor<P>>();
        for (VirtualPointNode<P> p : basisPoints) {
            ArrayList neighbors = new ArrayList();
            VirtualPointNode[] neighborList = (VirtualPointNode[])nnsearch.findNNearestNeighbors(p, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n].getPoint());
            }
            try {
                descriptors.add(new LocalCoordinateSystemPointDescriptor<P>(p.getPoint(), neighbors, normalize));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }

    public TestPointDescriptor() {
        ArrayList<Point> points1 = new ArrayList<Point>();
        ArrayList<Point> points2 = new ArrayList<Point>();
        this.addSimplePoints(points1, points2);
        this.applyTransform(points2);
        ArrayList nodeList1 = TestPointDescriptor.createVirtualNodeList(points1);
        ArrayList nodeList2 = TestPointDescriptor.createVirtualNodeList(points2);
        KDTree tree1 = new KDTree(nodeList1);
        KDTree tree2 = new KDTree(nodeList2);
        int numNeighbors = 4;
        TranslationInvariantRigidModel3D model = new TranslationInvariantRigidModel3D();
        SimpleMatcher matcher = new SimpleMatcher(4);
        SquareDistance similarityMeasure = new SquareDistance();
        ArrayList descriptors1 = TestPointDescriptor.createModelPointDescriptors(tree1, nodeList1, 4, model, matcher, similarityMeasure);
        ArrayList descriptors2 = TestPointDescriptor.createModelPointDescriptors(tree2, nodeList2, 4, model, matcher, similarityMeasure);
        for (ModelPointDescriptor descriptorA : descriptors1) {
            for (ModelPointDescriptor descriptorB : descriptors2) {
                double difference = descriptorA.descriptorDistance(descriptorB);
                System.out.println("Difference " + descriptorA.getId() + " -> " + descriptorB.getId() + " : " + difference);
                System.out.println("Position " + Util.printCoordinates((double[])descriptorA.getBasisPoint().getL()) + " -> " + Util.printCoordinates((double[])descriptorB.getBasisPoint().getL()) + "\n");
            }
        }
    }

    public static void testQuaternions() {
        Quat4f qu = new Quat4f();
        Matrix3f m = new Matrix3f();
        Transform3D transformationPrior = new Transform3D();
        transformationPrior.rotX(Math.toRadians(45.0));
        transformationPrior.get(m);
        qu.set(m);
        Vector3f v1 = new Vector3f(qu.getX(), qu.getY(), qu.getZ());
        v1.normalize();
        System.out.println("Axis: " + v1);
        System.out.println(Math.toDegrees(Math.acos(qu.getW()) * 2.0));
        Transform3D trans = new Transform3D();
        trans.rotY(Math.toRadians(90.0));
        trans.get(m);
        qu.set(m);
        Vector3f v2 = new Vector3f(qu.getX(), qu.getY(), qu.getZ());
        v2.normalize();
        System.out.println("Axis: " + v2);
        System.out.println(Math.toDegrees(Math.acos(qu.getW()) * 2.0));
        Vector3f v3 = new Vector3f(1.1f, 0.1f, 0.25f);
        v3.normalize();
        Point3f p1 = new Point3f(1.0f, 0.0f, 0.0f);
        Point3f p2 = new Point3f(v3);
        System.out.println("Distance to: " + Math.pow(50.0, p1.distance(p2)));
        transformationPrior.invert();
        trans.mul(transformationPrior);
        trans.get(m);
        qu.set(m);
        System.out.println(Math.toDegrees(Math.acos(qu.getW()) * 2.0));
    }

    public static void testStability(int numNeighbors, int numTrueMatches, int numRandomPoints, double nTimesBetter, double stdev, boolean fastMatching, boolean showPoints) {
        double secondBest;
        double best;
        ArrayList<Point> truepoints1 = new ArrayList<Point>();
        ArrayList<Point> falsepoints1 = new ArrayList<Point>();
        ArrayList<Point> points1 = new ArrayList<Point>();
        ArrayList<Point> points2 = new ArrayList<Point>();
        Random rnd = new Random(4353451L);
        double cubeSize = 326508.0;
        double pointsPercubePixel = 1.0;
        double cubeSizeTrue = 326508.0 * (double)numTrueMatches;
        double cubeTrueKantenLength = Math.pow(cubeSizeTrue, 0.3333333333333333);
        Point offset = new Point(new double[]{-cubeTrueKantenLength / 2.0, -cubeTrueKantenLength / 2.0, -cubeTrueKantenLength / 2.0});
        for (int n = 0; n < numTrueMatches; ++n) {
            Point p = new Point(new double[]{rnd.nextDouble() * cubeTrueKantenLength, rnd.nextDouble() * cubeTrueKantenLength, rnd.nextDouble() * cubeTrueKantenLength});
            TestPointDescriptor.add(p, offset);
            points1.add(p);
            truepoints1.add(p);
            LinkedPoint<Point> p2 = new LinkedPoint<Point>((double[])p.getL().clone(), p);
            double[] dArray = p2.getL();
            dArray[0] = dArray[0] + stdev * rnd.nextGaussian();
            double[] dArray2 = p2.getL();
            dArray2[1] = dArray2[1] + stdev * rnd.nextGaussian();
            double[] dArray3 = p2.getL();
            dArray3[2] = dArray3[2] + 3.0 * stdev * rnd.nextGaussian();
            points2.add(p2);
        }
        double cubeSizeFalse = 326508.0 * (double)numRandomPoints + cubeSizeTrue;
        double cubeFalseKantenLength = Math.pow(cubeSizeFalse, 0.3333333333333333);
        double o = -cubeFalseKantenLength / 2.0;
        for (int n = 0; n < numRandomPoints; ++n) {
            double[][] l = new double[2][3];
            for (int i = 0; i < l.length; ++i) {
                double[] li = l[i];
                boolean worked = true;
                do {
                    worked = true;
                    li[0] = rnd.nextDouble() * cubeFalseKantenLength + o;
                    li[1] = rnd.nextDouble() * cubeFalseKantenLength + o;
                    li[2] = rnd.nextDouble() * cubeFalseKantenLength + o;
                    if (!(li[0] >= -cubeTrueKantenLength / 2.0) || !(li[0] < cubeTrueKantenLength / 2.0) || !(li[1] >= -cubeTrueKantenLength / 2.0) || !(li[1] < cubeTrueKantenLength / 2.0) || !(li[2] >= -cubeTrueKantenLength / 2.0) || !(li[2] < cubeTrueKantenLength / 2.0)) continue;
                    worked = false;
                } while (!worked);
            }
            Point p1 = new Point(new double[]{l[0][0], l[0][1], l[0][2]});
            Point p2 = new Point(new double[]{l[1][0], l[1][1], l[1][2]});
            points1.add(p1);
            falsepoints1.add(p1);
            points2.add(p2);
        }
        long time = System.currentTimeMillis();
        ArrayList nodeList1 = TestPointDescriptor.createVirtualNodeList(points1);
        ArrayList nodeList2 = TestPointDescriptor.createVirtualNodeList(points2);
        KDTree tree1 = new KDTree(nodeList1);
        KDTree tree2 = new KDTree(nodeList2);
        int detectedRight = 0;
        int detectedWrong = 0;
        boolean[] foundByNeighbor = new boolean[numTrueMatches];
        for (int i = 0; i < numTrueMatches; ++i) {
            foundByNeighbor[i] = false;
        }
        if (fastMatching) {
            ArrayList descriptors1 = TestPointDescriptor.createLocalCoordinateSystemPointDescriptors(tree1, nodeList1, numNeighbors, false);
            ArrayList descriptors2 = TestPointDescriptor.createLocalCoordinateSystemPointDescriptors(tree2, nodeList2, numNeighbors, false);
            KDTree lookUpTree2 = new KDTree(descriptors2);
            NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(lookUpTree2);
            for (LocalCoordinateSystemPointDescriptor descriptorA : descriptors1) {
                LocalCoordinateSystemPointDescriptor[] matches;
                best = descriptorA.descriptorDistance((matches = (LocalCoordinateSystemPointDescriptor[])nnsearch.findNNearestNeighbors(descriptorA, 2))[0]);
                if (!(best * nTimesBetter < (secondBest = descriptorA.descriptorDistance(matches[1])))) continue;
                if (TestPointDescriptor.isCorrect(descriptorA.getBasisPoint(), matches[0].getBasisPoint())) {
                    ++detectedRight;
                    ArrayList neighbors = descriptorA.getOrderedNearestNeighboringPoints();
                    for (Point p : neighbors) {
                        for (int i = 0; i < numTrueMatches; ++i) {
                            if (!TestPointDescriptor.isCorrect(p, (Point)points1.get(i))) continue;
                            foundByNeighbor[i] = true;
                        }
                    }
                    continue;
                }
                ++detectedWrong;
            }
        } else {
            TranslationInvariantRigidModel3D model = new TranslationInvariantRigidModel3D();
            SimpleMatcher matcher = new SimpleMatcher(numNeighbors);
            SquareDistance similarityMeasure = new SquareDistance();
            ArrayList descriptors1 = TestPointDescriptor.createModelPointDescriptors(tree1, nodeList1, numNeighbors, model, matcher, similarityMeasure);
            ArrayList descriptors2 = TestPointDescriptor.createModelPointDescriptors(tree2, nodeList2, numNeighbors, model, matcher, similarityMeasure);
            for (ModelPointDescriptor descriptorA : descriptors1) {
                best = Double.MAX_VALUE;
                secondBest = Double.MAX_VALUE;
                boolean correct = true;
                for (ModelPointDescriptor descriptorB : descriptors2) {
                    double difference = descriptorA.descriptorDistance(descriptorB);
                    if (!(difference < secondBest)) continue;
                    if (difference < best) {
                        secondBest = best;
                        best = difference;
                        correct = TestPointDescriptor.isCorrect(descriptorA.getBasisPoint(), descriptorB.getBasisPoint());
                        continue;
                    }
                    secondBest = difference;
                }
                if (!(best * nTimesBetter < secondBest)) continue;
                if (correct) {
                    ++detectedRight;
                    ArrayList neighbors = descriptorA.getOrderedNearestNeighboringPoints();
                    for (Point p : neighbors) {
                        for (int i = 0; i < numTrueMatches; ++i) {
                            if (!TestPointDescriptor.isCorrect(p, (Point)points1.get(i))) continue;
                            foundByNeighbor[i] = true;
                        }
                    }
                    continue;
                }
                ++detectedWrong;
            }
        }
        long duration = System.currentTimeMillis() - time;
        int countAll = 0;
        for (int i = 0; i < numTrueMatches; ++i) {
            if (!foundByNeighbor[i]) continue;
            ++countAll;
        }
        System.out.println(numNeighbors + "\t" + numRandomPoints + "\t" + detectedRight + "\t" + countAll + "\t" + detectedWrong + "\t" + duration);
    }

    public static ArrayList<Point3f> getBoundingBox(float start, float end) {
        ArrayList<Point3f> boundingBox = new ArrayList<Point3f>();
        boundingBox.add(new Point3f(start, start, start));
        boundingBox.add(new Point3f(end, start, start));
        boundingBox.add(new Point3f(end, start, start));
        boundingBox.add(new Point3f(end, end, start));
        boundingBox.add(new Point3f(end, end, start));
        boundingBox.add(new Point3f(start, end, start));
        boundingBox.add(new Point3f(start, end, start));
        boundingBox.add(new Point3f(start, start, start));
        boundingBox.add(new Point3f(start, start, end));
        boundingBox.add(new Point3f(end, start, end));
        boundingBox.add(new Point3f(end, start, end));
        boundingBox.add(new Point3f(end, end, end));
        boundingBox.add(new Point3f(end, end, end));
        boundingBox.add(new Point3f(start, end, end));
        boundingBox.add(new Point3f(start, end, end));
        boundingBox.add(new Point3f(start, start, end));
        boundingBox.add(new Point3f(start, start, start));
        boundingBox.add(new Point3f(start, start, end));
        boundingBox.add(new Point3f(end, start, start));
        boundingBox.add(new Point3f(end, start, end));
        boundingBox.add(new Point3f(end, end, start));
        boundingBox.add(new Point3f(end, end, end));
        boundingBox.add(new Point3f(start, end, start));
        boundingBox.add(new Point3f(start, end, end));
        return boundingBox;
    }

    protected static boolean isCorrect(Point a, Point b) {
        if (a instanceof LinkedPoint) {
            return ((LinkedPoint)a).getLinkedObject() == b;
        }
        if (b instanceof LinkedPoint) {
            return ((LinkedPoint)b).getLinkedObject() == a;
        }
        return false;
    }

    public static void main(String[] args) {
        boolean showPoints = false;
        if (showPoints) {
            String[] params = new String[]{"-ijpath ."};
            ImageJ.main((String[])params);
        }
        double stdev = 0.2f;
        int n = 2;
        while (n <= 10000000) {
            TestPointDescriptor.testStability(3, 100, n, 10.0, stdev, false, showPoints);
            n = (int)((double)n * 1.5);
        }
    }
}

