/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.ArrayList;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.registration.ViewDataBeads;

public class Blending
extends CombinedPixelWeightener<Blending> {
    final boolean[] useView;
    final int numViews;
    final double[] weights;
    final double[] minDistance;
    final int[][] imageSizes;

    protected Blending(ArrayList<ViewDataBeads> views) {
        super(views);
        this.numViews = views.size();
        this.useView = new boolean[this.numViews];
        this.weights = new double[this.numViews];
        this.minDistance = new double[this.numViews];
        this.imageSizes = new int[this.numViews][];
        for (int i = 0; i < this.numViews; ++i) {
            this.imageSizes[i] = views.get(i).getImageSize();
        }
    }

    @Override
    public void updateWeights(double[][] loc, boolean[] useView) {
        int num = 0;
        for (int view = 0; view < this.numViews; ++view) {
            if (!useView[view]) continue;
            ++num;
        }
        this.computeLinearWeights(num, loc, useView);
    }

    @Override
    public void updateWeights(int[][] loc, boolean[] useView) {
        int num = 0;
        for (int view = 0; view < this.numViews; ++view) {
            if (!useView[view]) continue;
            ++num;
        }
        this.computeLinearWeights(num, loc, useView);
    }

    @Override
    public double getWeight(int view) {
        return this.weights[view];
    }

    private final void computeLinearWeights(int num, int[][] loc, boolean[] useView) {
        int i;
        if (num <= 1) {
            for (int i2 = 0; i2 < useView.length; ++i2) {
                this.weights[i2] = useView[i2] ? 1.0 : 0.0;
            }
            return;
        }
        double sumInverseWeights = 0.0;
        for (i = 0; i < useView.length; ++i) {
            if (!useView[i]) continue;
            this.minDistance[i] = 1.0;
            for (int dim = 0; dim < 3; ++dim) {
                double imgHalf;
                double imgHalf10;
                int localImgPos = loc[i][dim];
                double value = Math.min(localImgPos, this.imageSizes[i][dim] - localImgPos - 1) + 1;
                value = value < (imgHalf10 = (double)Math.round(0.35 * (imgHalf = (double)this.imageSizes[i][dim] / 2.0))) ? (value /= imgHalf10) : 1.0;
                int n = i;
                this.minDistance[n] = this.minDistance[n] * value;
            }
            if (this.minDistance[i] < 0.0) {
                this.minDistance[i] = 0.0;
            } else if (this.minDistance[i] > 1.0) {
                this.minDistance[i] = 1.0;
            }
            this.weights[i] = Math.pow(this.minDistance[i], this.conf.alpha);
            sumInverseWeights += this.weights[i];
        }
        if (sumInverseWeights == 0.0) {
            for (i = 0; i < useView.length; ++i) {
                this.weights[i] = 0.0;
            }
        } else {
            for (i = 0; i < useView.length; ++i) {
                if (useView[i]) {
                    int n = i;
                    this.weights[n] = this.weights[n] / sumInverseWeights;
                    continue;
                }
                this.weights[i] = 0.0;
            }
        }
    }

    private final void computeLinearWeights(int num, double[][] loc, boolean[] useView) {
        int i;
        if (num <= 1) {
            for (int i2 = 0; i2 < useView.length; ++i2) {
                this.weights[i2] = useView[i2] ? 1.0 : 0.0;
            }
            return;
        }
        double sumInverseWeights = 0.0;
        for (i = 0; i < useView.length; ++i) {
            if (!useView[i]) continue;
            this.minDistance[i] = 1.0;
            for (int dim = 0; dim < 3; ++dim) {
                double imgHalf;
                double imgHalf10;
                double localImgPos = loc[i][dim];
                double value = Math.min(localImgPos, (double)this.imageSizes[i][dim] - localImgPos - 1.0) + 1.0;
                value = value < (imgHalf10 = (double)Math.round(0.35 * (imgHalf = (double)this.imageSizes[i][dim] / 2.0))) ? (value /= imgHalf10) : 1.0;
                int n = i;
                this.minDistance[n] = this.minDistance[n] * value;
            }
            if (this.minDistance[i] < 0.0) {
                this.minDistance[i] = 0.0;
            } else if (this.minDistance[i] > 1.0) {
                this.minDistance[i] = 1.0;
            }
            this.weights[i] = Math.pow(this.minDistance[i], this.conf.alpha);
            sumInverseWeights += this.weights[i];
        }
        if (sumInverseWeights == 0.0) {
            for (i = 0; i < useView.length; ++i) {
                this.weights[i] = 0.0;
            }
        } else {
            for (i = 0; i < useView.length; ++i) {
                if (useView[i]) {
                    int n = i;
                    this.weights[n] = this.weights[n] / sumInverseWeights;
                    continue;
                }
                this.weights[i] = 0.0;
            }
        }
    }

    @Override
    public void close() {
    }
}

