/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.Date;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.fusion.entropy.Entropy;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.ViewDataBeads;

public class EntropyFast
extends IsolatedPixelWeightener<EntropyFast> {
    final Image<FloatType> entropy;

    public EntropyFast(ViewDataBeads view, ContainerFactory entropyContainerFactory) {
        super(view);
        int windowSizeZ = Math.round((float)this.conf.windowSizeX / (float)view.getZStretching());
        if (this.debugLevel <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing entropy for " + view + " using a " + this.conf.windowSizeX + "x" + this.conf.windowSizeY + "x" + windowSizeZ + " window");
        }
        this.entropy = Entropy.computeEntropy(view.getImage(), entropyContainerFactory, this.conf.histogramBins, this.conf.windowSizeX, this.conf.windowSizeY, windowSizeZ);
        Cursor i = this.entropy.createCursor();
        while (i.hasNext()) {
            i.fwd();
            ((FloatType)i.getType()).set((float)Math.pow(100.0, ((FloatType)i.getType()).get()));
        }
        i.close();
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator() {
        return this.entropy.createLocalizableByDimCursor();
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator(OutOfBoundsStrategyFactory<FloatType> factory) {
        return this.entropy.createLocalizableByDimCursor(factory);
    }

    @Override
    public void close() {
        this.entropy.close();
    }

    @Override
    public Image<FloatType> getResultImage() {
        return this.entropy;
    }
}

