/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import fiji.plugin.Multi_View_Deconvolution;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.fusion.PreDeconvolutionFusion;
import mpicbg.spim.fusion.PreDeconvolutionFusionInterface;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.Java3d;
import mpicbg.spim.postprocessing.deconvolution.ExtractPSF;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3d;
import spim.vecmath.Point3f;

public class PreDeconvolutionFusionSequential
extends SPIMImageFusion
implements PreDeconvolutionFusionInterface {
    final Image<FloatType>[] images;
    final Image<FloatType>[] weights;
    final Image<FloatType> overlap;
    final int numViews;
    final boolean normalize;
    final ExtractPSF extractPSF;

    public PreDeconvolutionFusionSequential(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories) {
        super(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories);
        this.normalize = true;
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        }
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), this.conf.processImageFactory);
        this.numViews = viewStructure.getNumViews();
        if (this.conf.deconvolutionJustShowOverlap) {
            this.overlap = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "overlap");
            this.images = null;
            this.weights = null;
            this.extractPSF = null;
        } else {
            this.overlap = null;
            this.extractPSF = this.conf.extractPSF ? new ExtractPSF(viewStructure) : ExtractPSF.loadAndTransformPSF(this.conf.psfFiles, this.conf.transformPSFs, viewStructure);
            this.images = new Image[this.numViews];
            this.weights = new Image[this.numViews];
            if (this.extractPSF == null) {
                return;
            }
            for (int view = 0; view < this.numViews; ++view) {
                this.weights[view] = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "weights_" + view);
                this.images[view] = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "view_" + view);
                if (this.images[view] != null && this.weights[view] != null) continue;
                if (viewStructure.getDebugLevel() <= 2) {
                    IOFunctions.println("PreDeconvolutionFusion.constructor: Cannot create output image: " + this.conf.processImageFactory.getErrorMessage());
                }
                return;
            }
        }
    }

    public static void computeOverlap(final Image<FloatType> overlap, ArrayList<ViewDataBeads> views, final ViewStructure viewStructure, final int cropOffsetX, final int cropOffsetY, final int cropOffsetZ, final int scale, final Point3f min) {
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Computing overlap");
        }
        final int numViews = views.size();
        final boolean[] useView = new boolean[numViews];
        final AbstractAffineModel3D[] models = new AbstractAffineModel3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            boolean bl = useView[i] = Math.max(views.get(i).getViewErrorStatistics().getNumConnectedViews(), views.get(i).getTile().getConnectedTiles().size()) > 0 || views.get(i).getViewStructure().getNumViews() == 1;
            if (!views.get(i).getUseForRegistration()) {
                int angle = views.get(i).getAcqusitionAngle();
                int timepoint = views.get(i).getViewStructure().getTimePoint();
                for (ViewDataBeads view2 : viewStructure.getViews()) {
                    if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                    useView[i] = true;
                }
            }
            models[i] = (AbstractAffineModel3D)views.get(i).getTile().getModel();
        }
        final int[][] imageSizes = new int[numViews][];
        for (int i = 0; i < numViews; ++i) {
            imageSizes[i] = views.get(i).getImageSize();
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            int myNumber = ai.getAndIncrement();
                            double[] tmp = new double[3];
                            Point3d[] tmpCoordinates = new Point3d[numViews];
                            int[][] loc = new int[numViews][3];
                            for (int i = 0; i < numViews; ++i) {
                                tmpCoordinates[i] = new Point3d();
                            }
                            LocalizableCursor cursor = overlap.createLocalizableCursor();
                            while (cursor.hasNext()) {
                                cursor.fwd();
                                if (cursor.getPosition(2) % numThreads != myNumber) continue;
                                int x = cursor.getPosition(0) + cropOffsetX;
                                int y = cursor.getPosition(1) + cropOffsetY;
                                int z = cursor.getPosition(2) + cropOffsetZ;
                                int num = 0;
                                for (int i = 0; i < numViews; ++i) {
                                    if (!useView[i]) continue;
                                    tmpCoordinates[i].x = (float)(x * scale) + min.x;
                                    tmpCoordinates[i].y = (float)(y * scale) + min.y;
                                    tmpCoordinates[i].z = (float)(z * scale) + min.z;
                                    Java3d.applyInverseInPlace(models[i], tmpCoordinates[i], tmp);
                                    loc[i][0] = (int)Util.round((double)tmpCoordinates[i].x);
                                    loc[i][1] = (int)Util.round((double)tmpCoordinates[i].y);
                                    loc[i][2] = (int)Util.round((double)tmpCoordinates[i].z);
                                    if (loc[i][0] < 0 || loc[i][1] < 0 || loc[i][2] < 0 || loc[i][0] >= imageSizes[i][0] || loc[i][1] >= imageSizes[i][1] || loc[i][2] >= imageSizes[i][2]) continue;
                                    ++num;
                                }
                                ((FloatType)cursor.getType()).set((float)num);
                            }
                            cursor.close();
                        }
                        catch (NoninvertibleModelException e) {
                            if (viewStructure.getDebugLevel() > 2) break block5;
                            IOFunctions.println("PreDeconvolutionFusionSequential(): Model not invertible for " + viewStructure);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    @Override
    public void fuseSPIMImages(int channelIndex) {
        final ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            if (view.getChannelIndex() != channelIndex) continue;
            views.add(view);
        }
        final int numViews = views.size();
        if (this.conf.deconvolutionJustShowOverlap) {
            PreDeconvolutionFusionSequential.computeOverlap(this.overlap, views, this.viewStructure, this.cropOffsetX, this.cropOffsetY, this.cropOffsetZ, this.scale, this.min);
            return;
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Loading source images (Channel " + channelIndex + ").");
        }
        if (channelIndex > 0) {
            return;
        }
        if (this.viewStructure.getDebugLevel() <= 1 && this.isolatedWeightenerFactories.size() > 0) {
            String methods = "(" + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(0)).getDescriptiveName();
            for (int i = 1; i < this.isolatedWeightenerFactories.size(); ++i) {
                methods = methods + ", " + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(i)).getDescriptiveName();
            }
            methods = methods + ")";
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Init isolated weighteners for all views " + methods);
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing output image (Channel " + channelIndex + ").");
        }
        final boolean[] useView = new boolean[numViews];
        final AbstractAffineModel3D[] models = new AbstractAffineModel3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            boolean bl = useView[i] = Math.max(views.get(i).getViewErrorStatistics().getNumConnectedViews(), views.get(i).getTile().getConnectedTiles().size()) > 0 || views.get(i).getViewStructure().getNumViews() == 1;
            if (!views.get(i).getUseForRegistration()) {
                int angle = views.get(i).getAcqusitionAngle();
                int timepoint = views.get(i).getViewStructure().getTimePoint();
                for (ViewDataBeads view2 : this.viewStructure.getViews()) {
                    if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                    useView[i] = true;
                }
            }
            models[i] = (AbstractAffineModel3D)views.get(i).getTile().getModel();
        }
        final int[][] imageSizes = new int[numViews][];
        for (int i = 0; i < numViews; ++i) {
            imageSizes[i] = views.get(i).getImageSize();
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Computing blending weights for all input views ... ");
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    block22: {
                        try {
                            int i;
                            int i2;
                            int myNumber = ai.getAndIncrement();
                            double[] tmp = new double[3];
                            if (PreDeconvolutionFusionSequential.this.viewStructure.getDebugLevel() <= 1 && PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.size() > 0) {
                                String methods = "(" + ((CombinedPixelWeightenerFactory)PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.get(0)).getDescriptiveName();
                                for (i2 = 1; i2 < PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.size(); ++i2) {
                                    methods = methods + ", " + ((CombinedPixelWeightenerFactory)PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.get(i2)).getDescriptiveName();
                                }
                                methods = methods + ")";
                                if (myNumber == 0) {
                                    IOFunctions.println("Initialize combined weighteners for all views " + methods);
                                }
                            }
                            CombinedPixelWeightener[] combW = new CombinedPixelWeightener[PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.size()];
                            for (i2 = 0; i2 < combW.length; ++i2) {
                                combW[i2] = ((CombinedPixelWeightenerFactory)PreDeconvolutionFusionSequential.this.combinedWeightenerFactories.get(i2)).createInstance(views);
                            }
                            Point3d[] tmpCoordinates = new Point3d[numViews];
                            int[][] loc = new int[numViews][3];
                            double[][] locd = new double[numViews][3];
                            boolean[] use = new boolean[numViews];
                            for (int i3 = 0; i3 < numViews; ++i3) {
                                tmpCoordinates[i3] = new Point3d();
                            }
                            LocalizableCursor[] outWeights = new LocalizableCursor[numViews];
                            float[] tmpWeights = new float[numViews];
                            for (int i4 = 0; i4 < numViews; ++i4) {
                                outWeights[i4] = PreDeconvolutionFusionSequential.this.weights[i4].createLocalizableCursor();
                            }
                            LocalizableCursor firstCursor = outWeights[0];
                            while (firstCursor.hasNext()) {
                                int view;
                                for (i = 0; i < numViews; ++i) {
                                    outWeights[i].fwd();
                                }
                                if (firstCursor.getPosition(2) % numThreads != myNumber) continue;
                                int x = firstCursor.getPosition(0) + PreDeconvolutionFusionSequential.this.cropOffsetX;
                                int y = firstCursor.getPosition(1) + PreDeconvolutionFusionSequential.this.cropOffsetY;
                                int z = firstCursor.getPosition(2) + PreDeconvolutionFusionSequential.this.cropOffsetZ;
                                int num = 0;
                                for (int i5 = 0; i5 < numViews; ++i5) {
                                    if (!useView[i5]) continue;
                                    tmpCoordinates[i5].x = (float)(x * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.x;
                                    tmpCoordinates[i5].y = (float)(y * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.y;
                                    tmpCoordinates[i5].z = (float)(z * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.z;
                                    Java3d.applyInverseInPlace(models[i5], tmpCoordinates[i5], tmp);
                                    loc[i5][0] = (int)Util.round((double)tmpCoordinates[i5].x);
                                    loc[i5][1] = (int)Util.round((double)tmpCoordinates[i5].y);
                                    loc[i5][2] = (int)Util.round((double)tmpCoordinates[i5].z);
                                    locd[i5][0] = tmpCoordinates[i5].x;
                                    locd[i5][1] = tmpCoordinates[i5].y;
                                    locd[i5][2] = tmpCoordinates[i5].z;
                                    if (loc[i5][0] >= 0 && loc[i5][1] >= 0 && loc[i5][2] >= 0 && loc[i5][0] < imageSizes[i5][0] && loc[i5][1] < imageSizes[i5][1] && loc[i5][2] < imageSizes[i5][2]) {
                                        use[i5] = true;
                                        ++num;
                                        continue;
                                    }
                                    use[i5] = false;
                                }
                                if (num <= 0) continue;
                                if (combW.length > 0) {
                                    for (CombinedPixelWeightener w : combW) {
                                        w.updateWeights(locd, use);
                                    }
                                }
                                float sumWeights = 0.0f;
                                for (view = 0; view < numViews; ++view) {
                                    if (!use[view]) continue;
                                    float weight = 1.0f;
                                    if (combW.length > 0) {
                                        for (CombinedPixelWeightener w : combW) {
                                            weight = (float)((double)weight * w.getWeight(view));
                                        }
                                    }
                                    tmp[0] = tmpCoordinates[view].x;
                                    tmp[1] = tmpCoordinates[view].y;
                                    tmp[2] = tmpCoordinates[view].z;
                                    if (PreDeconvolutionFusionSequential.this.normalize) {
                                        sumWeights += weight;
                                        tmpWeights[view] = weight;
                                        continue;
                                    }
                                    ((FloatType)outWeights[view].getType()).set(weight);
                                }
                                if (!PreDeconvolutionFusionSequential.this.normalize || !(sumWeights > 0.0f)) continue;
                                for (view = 0; view < numViews; ++view) {
                                    if (!use[view]) continue;
                                    if (sumWeights > 1.0f) {
                                        ((FloatType)outWeights[view].getType()).set(tmpWeights[view] / sumWeights);
                                        continue;
                                    }
                                    ((FloatType)outWeights[view].getType()).set(tmpWeights[view]);
                                }
                            }
                            for (i = 0; i < numViews; ++i) {
                                outWeights[i].close();
                            }
                            for (i = 0; i < combW.length; ++i) {
                                combW[i].close();
                            }
                        }
                        catch (NoninvertibleModelException e) {
                            if (PreDeconvolutionFusionSequential.this.viewStructure.getDebugLevel() > 2) break block22;
                            IOFunctions.println("PreDeconvolutionFusionSequential(): Model not invertible for " + PreDeconvolutionFusionSequential.this.viewStructure);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Computing transformed input views ... ");
        }
        int[] maxSize = new int[]{0, 0, 0};
        for (int view = 0; view < numViews; ++view) {
            if (!useView[view]) continue;
            final int i = view;
            views.get(i).getImage();
            if (Multi_View_Deconvolution.subtractBackground != 0.0f) {
                if (this.viewStructure.getDebugLevel() <= 2) {
                    IOFunctions.println("PreDeconvolutionFusionSequential(): Subtracting background of " + Multi_View_Deconvolution.subtractBackground + " from " + views.get(i).getName());
                }
                PreDeconvolutionFusion.subtractBackground(views.get(i).getImage(false), Multi_View_Deconvolution.subtractBackground);
                views.get(i).getImage(true);
            }
            ai.set(0);
            threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                int myNumber = ai.getAndIncrement();
                                double[] tmp = new double[3];
                                int imageSizeX = imageSizes[i][0];
                                int imageSizeY = imageSizes[i][1];
                                int imageSizeZ = imageSizes[i][2];
                                Point3d tmpCoordinates = new Point3d();
                                LocalizableCursor outIntensity = PreDeconvolutionFusionSequential.this.images[i].createLocalizableCursor();
                                Interpolator interpolator = ((ViewDataBeads)views.get(i)).getImage().createInterpolator(PreDeconvolutionFusionSequential.this.conf.interpolatorFactorOutput);
                                while (outIntensity.hasNext()) {
                                    outIntensity.fwd();
                                    int zPos = outIntensity.getPosition(2);
                                    if (zPos % numThreads != myNumber) continue;
                                    int x = outIntensity.getPosition(0) + PreDeconvolutionFusionSequential.this.cropOffsetX;
                                    int y = outIntensity.getPosition(1) + PreDeconvolutionFusionSequential.this.cropOffsetY;
                                    int z = zPos + PreDeconvolutionFusionSequential.this.cropOffsetZ;
                                    tmpCoordinates.x = (float)(x * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.x;
                                    tmpCoordinates.y = (float)(y * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.y;
                                    tmpCoordinates.z = (float)(z * PreDeconvolutionFusionSequential.this.scale) + PreDeconvolutionFusionSequential.this.min.z;
                                    Java3d.applyInverseInPlace(models[i], tmpCoordinates, tmp);
                                    int locX = (int)Util.round((double)tmpCoordinates.x);
                                    int locY = (int)Util.round((double)tmpCoordinates.y);
                                    int locZ = (int)Util.round((double)tmpCoordinates.z);
                                    if (locX < 0 || locY < 0 || locZ < 0 || locX >= imageSizeX || locY >= imageSizeY || locZ >= imageSizeZ) continue;
                                    tmp[0] = tmpCoordinates.x;
                                    tmp[1] = tmpCoordinates.y;
                                    tmp[2] = tmpCoordinates.z;
                                    interpolator.setPosition(tmp);
                                    ((FloatType)outIntensity.getType()).set(((FloatType)interpolator.getType()).get());
                                }
                                outIntensity.close();
                                interpolator.close();
                            }
                            catch (NoninvertibleModelException e) {
                                if (PreDeconvolutionFusionSequential.this.viewStructure.getDebugLevel() > 2) break block3;
                                IOFunctions.println("PreDeconvolutionFusionSequential(): Model not invertible for " + PreDeconvolutionFusionSequential.this.viewStructure);
                            }
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
            if (this.conf.extractPSF) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("Extracting PSF for " + views.get(i).getName());
                }
                this.extractPSF.extract(i, maxSize);
            }
            views.get(i).closeImage();
        }
        if (this.conf.extractPSF) {
            this.extractPSF.computeAveragePSF(maxSize);
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Done computing output image for deconvolution (Channel " + channelIndex + ").");
        }
    }

    @Override
    public Image<FloatType> getFusedImage() {
        return null;
    }

    @Override
    public Image<FloatType> getFusedImage(int index) {
        return this.images[index];
    }

    @Override
    public Image<FloatType> getWeightImage(int index) {
        return this.weights[index];
    }

    @Override
    public void closeImages() {
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            view.closeImage();
        }
    }

    @Override
    public ArrayList<Image<FloatType>> getPointSpreadFunctions() {
        return this.extractPSF.getPSFs();
    }

    @Override
    public ExtractPSF getExtractPSFInstance() {
        return this.extractPSF;
    }

    @Override
    public Image<FloatType> getOverlapImage() {
        return this.overlap;
    }
}

