/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution2;

import ij.IJ;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.postprocessing.deconvolution2.LRFFT;
import mpicbg.util.RealSum;
import spim.Threads;

public class AdjustInput {
    public static Random rnd = new Random(14235235L);

    public static final void normImage(Image<FloatType> img) {
        double sum = AdjustInput.sumImage(img);
        for (FloatType t : img) {
            t.set((float)((double)t.get() / sum));
        }
    }

    public static final double sumImage(Image<FloatType> img) {
        RealSum sum = new RealSum();
        for (FloatType t : img) {
            sum.add((double)t.get());
        }
        return sum.getSum();
    }

    public static double[] normAllImages(final ArrayList<LRFFT> data) {
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)data.get(0).getImage().getNumPixels(), (int)Threads.numThreads());
        int numThreads = threadChunks.size();
        IJ.log((String)(new Date(System.currentTimeMillis()) + ": numThreads = " + numThreads));
        final int[] minNumOverlap = new int[numThreads];
        final long[] avgNumOverlap = new long[numThreads];
        final int[] countAvgNumOverlap = new int[numThreads];
        final RealSum[] sum = new RealSum[numThreads];
        final long[] count = new long[numThreads];
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long start = myChunk.getStartPosition();
                    long loopSize = myChunk.getLoopSize();
                    RealSum mySum = new RealSum();
                    int myCount = 0;
                    int myMinNumOverlap = Integer.MAX_VALUE;
                    long myAvgNumOverlap = 0L;
                    int myCountAvgNumOverlap = 0;
                    ArrayList<Cursor> cursorsImage = new ArrayList<Cursor>();
                    ArrayList<Cursor> cursorsWeight = new ArrayList<Cursor>();
                    for (LRFFT fft : data) {
                        cursorsImage.add(fft.getImage().createCursor());
                        if (fft.getWeight() == null) continue;
                        cursorsWeight.add(fft.getWeight().createCursor());
                    }
                    for (Cursor c : cursorsImage) {
                        c.fwd(start);
                    }
                    for (Cursor c : cursorsWeight) {
                        c.fwd(start);
                    }
                    for (long l = 0L; l < loopSize; ++l) {
                        for (Cursor c : cursorsImage) {
                            c.fwd();
                        }
                        for (Cursor c : cursorsWeight) {
                            c.fwd();
                        }
                        double sumLocal = 0.0;
                        int countLocal = 0;
                        for (int i = 0; i < cursorsImage.size(); ++i) {
                            if (((FloatType)((Cursor)cursorsWeight.get(i)).getType()).get() == 0.0f) continue;
                            sumLocal += (double)((FloatType)((Cursor)cursorsImage.get(i)).getType()).get();
                            ++countLocal;
                        }
                        if (countLocal > 1) {
                            mySum.add(sumLocal);
                            myCount += countLocal;
                        }
                        if (countLocal <= 0) continue;
                        myAvgNumOverlap += (long)countLocal;
                        ++myCountAvgNumOverlap;
                        myMinNumOverlap = Math.min(countLocal, myMinNumOverlap);
                    }
                    sum[myNumber] = mySum;
                    count[myNumber] = myCount;
                    minNumOverlap[myNumber] = myMinNumOverlap;
                    avgNumOverlap[myNumber] = myAvgNumOverlap;
                    countAvgNumOverlap[myNumber] = myCountAvgNumOverlap;
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        IJ.log((String)(new Date(System.currentTimeMillis()) + ": done normalizing."));
        int minNumOverlapResult = minNumOverlap[0];
        long avgNumOverlapResult = avgNumOverlap[0];
        int countAvgNumOverlapResult = countAvgNumOverlap[0];
        RealSum sumResult = new RealSum();
        sumResult.add(sum[0].getSum());
        long countResult = count[0];
        for (int i = 1; i < numThreads; ++i) {
            minNumOverlapResult = Math.min(minNumOverlapResult, minNumOverlap[i]);
            avgNumOverlapResult += avgNumOverlap[i];
            countAvgNumOverlapResult += countAvgNumOverlap[i];
            countResult += count[i];
            sumResult.add(sum[i].getSum());
        }
        double avgNumOverlapFinal = (double)avgNumOverlapResult / (double)countAvgNumOverlapResult;
        IJ.log((String)("Min number of overlapping views: " + minNumOverlapResult));
        IJ.log((String)("Average number of overlapping views: " + avgNumOverlapFinal));
        if (countResult == 0L) {
            return new double[]{1.0, minNumOverlapResult, avgNumOverlapFinal};
        }
        double avg = sumResult.getSum() / (double)countResult;
        return new double[]{avg, minNumOverlapResult, avgNumOverlapFinal};
    }

    public static double addGaussianNoise(Image<FloatType> img, Random rnd, float sigma, boolean onlyPositive) {
        for (FloatType f : img) {
            float newValue = f.get() + (float)(rnd.nextGaussian() * (double)sigma);
            if (onlyPositive) {
                newValue = Math.max(0.0f, newValue);
            }
            f.set(newValue);
        }
        return 1.0;
    }

    public static double addGaussianNoiseAddMul(Image<FloatType> img, Random rnd, float sigma, boolean onlyPositive) {
        for (FloatType f : img) {
            float value = f.get();
            float newValue = value * (1.0f + (float)(rnd.nextGaussian() * (double)sigma / 3.0)) + (float)(Math.abs(rnd.nextGaussian()) * (double)sigma);
            if (onlyPositive) {
                newValue = Math.max(0.0f, newValue);
            }
            f.set(newValue);
        }
        return 1.0;
    }

    public static void translate(Image<FloatType> img, float[] vector) {
        Image tmp = img.clone();
        LocalizableCursor cursor1 = img.createLocalizableCursor();
        Interpolator interpolator = tmp.createInterpolator((InterpolatorFactory)new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory()));
        int numDimensions = img.getNumDimensions();
        float[] pos = new float[numDimensions];
        while (cursor1.hasNext()) {
            cursor1.fwd();
            for (int d = 0; d < numDimensions; ++d) {
                pos[d] = (float)cursor1.getPosition(d) - vector[d];
            }
            interpolator.setPosition(pos);
            ((FloatType)cursor1.getType()).set((FloatType)interpolator.getType());
        }
        cursor1.close();
        interpolator.close();
    }

    public static void adjustImage(Image<FloatType> image, float minValue, float targetAverage) {
        double avg = AdjustInput.sumImage(image) / (double)image.getNumPixels();
        double correction = (double)(targetAverage - minValue) / avg;
        for (FloatType t : image) {
            t.set((float)((double)t.get() * correction));
        }
        for (FloatType t : image) {
            t.set(t.get() + minValue);
        }
    }
}

