/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution2;

import ij.ImagePlus;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.algorithm.mirror.MirrorImage;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.constant.ConstantContainer;
import mpicbg.imglib.container.imageplus.ImagePlusContainer;
import mpicbg.imglib.container.imageplus.ImagePlusContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.exception.ImgLibException;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.wrapper.ImgLib1;
import mpicbg.imglib.wrapper.ImgLib2;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.postprocessing.deconvolution2.AdjustInput;
import mpicbg.spim.postprocessing.deconvolution2.Block;
import mpicbg.spim.postprocessing.deconvolution2.LRFFTThreads;
import net.imglib2.img.Img;
import net.imglib2.img.imageplus.ImagePlusImg;
import spim.process.cuda.CUDAFourierConvolution;

public class LRFFT {
    public static CUDAFourierConvolution cuda = null;
    private Image<FloatType> image;
    private Image<FloatType> weight;
    private Image<FloatType> kernel1;
    private Image<FloatType> kernel2;
    Image<FloatType> viewContribution = null;
    FourierConvolution<FloatType, FloatType> fftConvolution1;
    FourierConvolution<FloatType, FloatType> fftConvolution2;
    protected int numViews = 0;
    PSFTYPE iterationType;
    ArrayList<LRFFT> views;
    final boolean useBlocks;
    final boolean useCUDA;
    final boolean useCPU;
    final int[] blockSize;
    final int[] deviceList;
    final int device0;
    final int numDevices;
    final Block[] blocks;
    final ImageFactory<FloatType> factory;
    int iteration = -1;

    public LRFFT(Img<net.imglib2.type.numeric.real.FloatType> image, Img<net.imglib2.type.numeric.real.FloatType> weight, Img<net.imglib2.type.numeric.real.FloatType> kernel, int[] deviceList, boolean useBlocks, int[] blockSize) {
        this(LRFFT.wrap(image), LRFFT.wrap(weight), LRFFT.wrap(kernel), deviceList, useBlocks, blockSize);
    }

    public static final Image<FloatType> wrap(Img<net.imglib2.type.numeric.real.FloatType> i) {
        if (i instanceof ImagePlusImg) {
            try {
                return ImageJFunctions.wrapFloat((ImagePlus)((ImagePlusImg)i).getImagePlus());
            }
            catch (net.imglib2.exception.ImgLibException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ImgLib2.wrapFloatToImgLib1(i);
    }

    public static final Img<net.imglib2.type.numeric.real.FloatType> wrap(Image<FloatType> i) {
        ContainerFactory c = i.getContainerFactory();
        if (c instanceof ImagePlusContainerFactory) {
            try {
                return net.imglib2.img.display.imagej.ImageJFunctions.wrapFloat((ImagePlus)((ImagePlusContainer)i.getContainer()).getImagePlus());
            }
            catch (ImgLibException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ImgLib1.wrapFloatToImgLib2(i);
    }

    public LRFFT(Image<FloatType> image, Image<FloatType> weight, Image<FloatType> kernel, int[] deviceList, boolean useBlocks, int[] blockSize) {
        this.image = image;
        this.kernel1 = kernel;
        this.weight = weight;
        this.deviceList = deviceList;
        this.device0 = deviceList[0];
        this.numDevices = deviceList.length;
        boolean anyGPU = false;
        boolean anyCPU = false;
        for (int i : deviceList) {
            if (i >= 0) {
                anyGPU = true;
                continue;
            }
            if (i != -1) continue;
            anyCPU = true;
        }
        this.useCUDA = anyGPU;
        this.useCPU = anyCPU;
        if (useBlocks) {
            this.useBlocks = true;
            this.blockSize = new int[image.getNumDimensions()];
            for (int d = 0; d < this.blockSize.length; ++d) {
                this.blockSize[d] = blockSize[d];
            }
            this.blocks = Block.divideIntoBlocks(image.getDimensions(), this.blockSize, kernel.getDimensions());
            IOFunctions.println("Number of blocks: " + this.blocks.length);
            this.factory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        } else if (this.useCUDA) {
            this.useBlocks = true;
            this.blockSize = new int[image.getNumDimensions()];
            for (int d = 0; d < this.blockSize.length; ++d) {
                this.blockSize[d] = image.getDimension(d) + kernel.getDimension(d) - 1;
            }
            this.blocks = Block.divideIntoBlocks(image.getDimensions(), this.blockSize, kernel.getDimensions());
            this.factory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        } else {
            this.blocks = null;
            this.blockSize = null;
            this.factory = null;
            this.useBlocks = false;
        }
    }

    public LRFFT(Image<FloatType> image, Image<FloatType> kernel, int[] deviceList, boolean useBlocks, int[] blockSize) {
        this(image, (Image<FloatType>)new Image((Container)new ConstantContainer(image.getDimensions(), (Type)new FloatType(1.0f)), (Type)new FloatType()), kernel, deviceList, useBlocks, blockSize);
    }

    protected void setNumViews(int numViews) {
        this.numViews = numViews;
    }

    protected void init(PSFTYPE iterationType, ArrayList<LRFFT> views) {
        Image tmp;
        AdjustInput.normImage(this.kernel1);
        this.iterationType = iterationType;
        this.views = views;
        if (this.numViews == 0) {
            System.out.println("Warning, numViews was not set.");
            this.numViews = 1;
        }
        if (this.numViews == 1 || iterationType == PSFTYPE.INDEPENDENT) {
            this.kernel2 = LRFFT.computeInvertedKernel(this.kernel1);
        } else if (iterationType == PSFTYPE.EFFICIENT_BAYESIAN) {
            tmp = LRFFT.computeInvertedKernel((Image<FloatType>)this.kernel1.clone());
            for (LRFFT view : views) {
                if (view == this) continue;
                FourierConvolution conv1 = new FourierConvolution(LRFFT.computeInvertedKernel(this.kernel1), view.kernel1);
                conv1.setNumThreads();
                conv1.setKeepImgFFT(false);
                conv1.setImageOutOfBoundsStrategy((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory());
                conv1.process();
                FourierConvolution conv2 = new FourierConvolution(conv1.getResult(), LRFFT.computeInvertedKernel(view.kernel1));
                conv2.setNumThreads();
                conv2.setKeepImgFFT(false);
                conv2.setImageOutOfBoundsStrategy((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory());
                conv2.process();
                Cursor cursor = tmp.createCursor();
                for (FloatType t : conv2.getResult()) {
                    cursor.fwd();
                    ((FloatType)cursor.getType()).set(t.get() * ((FloatType)cursor.getType()).get());
                }
            }
            AdjustInput.normImage((Image<FloatType>)tmp);
            this.kernel2 = tmp;
        } else if (iterationType == PSFTYPE.OPTIMIZATION_I) {
            tmp = this.kernel1.clone();
            for (LRFFT view : views) {
                if (view == this) continue;
                FourierConvolution conv = new FourierConvolution(this.kernel1, LRFFT.computeInvertedKernel(view.kernel1));
                conv.setNumThreads();
                conv.setKeepImgFFT(false);
                conv.setImageOutOfBoundsStrategy((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory());
                conv.process();
                Cursor cursor = tmp.createCursor();
                for (FloatType t : conv.getResult()) {
                    cursor.fwd();
                    ((FloatType)cursor.getType()).set(t.get() * ((FloatType)cursor.getType()).get());
                }
            }
            AdjustInput.normImage((Image<FloatType>)tmp);
            this.kernel2 = LRFFT.computeInvertedKernel((Image<FloatType>)tmp);
        } else {
            Image<FloatType> exponentialKernel = LRFFT.computeExponentialKernel(this.kernel1, this.numViews);
            AdjustInput.normImage(exponentialKernel);
            this.kernel2 = LRFFT.computeInvertedKernel(exponentialKernel);
        }
        if (this.useCPU) {
            if (this.useBlocks) {
                Image block = this.factory.createImage(this.blockSize);
                this.fftConvolution1 = new FourierConvolution(block, this.kernel1);
                this.fftConvolution1.setNumThreads();
                this.fftConvolution1.setKeepImgFFT(false);
                this.fftConvolution2 = new FourierConvolution(block, this.kernel2);
                this.fftConvolution2.setNumThreads();
                this.fftConvolution2.setKeepImgFFT(false);
            } else {
                this.fftConvolution1 = new FourierConvolution(this.image, this.kernel1);
                this.fftConvolution1.setNumThreads();
                this.fftConvolution1.setKeepImgFFT(false);
                this.fftConvolution2 = new FourierConvolution(this.image, this.kernel2);
                this.fftConvolution2.setNumThreads();
                this.fftConvolution2.setKeepImgFFT(false);
            }
        } else {
            this.fftConvolution1 = null;
            this.fftConvolution2 = null;
        }
    }

    public static Image<FloatType> computeExponentialKernel(Image<FloatType> kernel, int numViews) {
        Image exponentialKernel = kernel.clone();
        for (FloatType f : exponentialKernel) {
            f.set(LRFFT.pow(f.get(), numViews));
        }
        return exponentialKernel;
    }

    public static Image<FloatType> computeInvertedKernel(Image<FloatType> kernel) {
        Image invKernel = kernel.clone();
        for (int d = 0; d < invKernel.getNumDimensions(); ++d) {
            new MirrorImage(invKernel, d).process();
        }
        return invKernel;
    }

    private static float pow(float value, int power) {
        float result = value;
        for (int i = 1; i < power; ++i) {
            result *= value;
        }
        return result;
    }

    public void setImage(Image<FloatType> image) {
        this.image = image;
        this.setCurrentIteration(-1);
    }

    public void setWeight(Image<FloatType> weight) {
        this.weight = weight;
    }

    public void setKernel(Image<FloatType> kernel) {
        this.kernel1 = kernel;
        this.init(this.iterationType, this.views);
        this.setCurrentIteration(-1);
    }

    public Image<FloatType> getImage() {
        return this.image;
    }

    public Image<FloatType> getWeight() {
        return this.weight;
    }

    public Image<FloatType> getKernel1() {
        return this.kernel1;
    }

    public Image<FloatType> getKernel2() {
        return this.kernel2;
    }

    public void setCurrentIteration(int i) {
        this.iteration = i;
    }

    public int getCurrentIteration() {
        return this.iteration;
    }

    public Image<FloatType> convolve1(Image<FloatType> image) {
        if (this.useCPU && !this.useCUDA) {
            if (this.useBlocks) {
                Image result = image.createNewImage();
                Image block = this.factory.createImage(this.blockSize);
                for (int i = 0; i < this.blocks.length; ++i) {
                    LRFFTThreads.convolve1BlockCPU(this.blocks[i], i, image, (Image<FloatType>)result, (Image<FloatType>)block, this.fftConvolution1);
                }
                block.close();
                return result;
            }
            long time = System.currentTimeMillis();
            FourierConvolution<FloatType, FloatType> fftConv = this.fftConvolution1;
            fftConv.replaceImage(image);
            fftConv.process();
            System.out.println(" block " + this.iteration + ": compute " + (System.currentTimeMillis() - time));
            return fftConv.getResult();
        }
        if (this.useCUDA && !this.useCPU && this.numDevices == 1) {
            Image result = image.createNewImage();
            Image block = this.factory.createImage(this.blockSize);
            for (int i = 0; i < this.blocks.length; ++i) {
                LRFFTThreads.convolve1BlockCUDA(this.blocks[i], i, this.device0, image, (Image<FloatType>)result, (Image<FloatType>)block, this.kernel1, this.blockSize);
            }
            block.close();
            return result;
        }
        Image result = image.createNewImage();
        AtomicInteger ai = new AtomicInteger();
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.deviceList.length);
        for (int i = 0; i < this.deviceList.length; ++i) {
            threads[i] = this.deviceList[i] == -1 ? LRFFTThreads.getCPUThread1(ai, this.blocks, this.blockSize, this.factory, image, (Image<FloatType>)result, this.fftConvolution1) : LRFFTThreads.getCUDAThread1(ai, this.blocks, this.blockSize, this.factory, image, (Image<FloatType>)result, this.deviceList[i], this.kernel1);
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        return result;
    }

    public static final Image<FloatType> createImageFromArray(float[] data, int[] dim) {
        FloatArray access = new FloatArray(data);
        Array array = new Array(new ArrayContainerFactory(), (DataAccess)access, dim, 1);
        FloatType linkedType = new FloatType((DirectAccessContainer)array);
        array.setLinkedType((Type)linkedType);
        return new Image((Container)array, (Type)new FloatType());
    }

    public Image<FloatType> convolve2(Image<FloatType> image) {
        if (this.useCPU && !this.useCUDA) {
            if (this.useBlocks) {
                Image result = image.createNewImage();
                Image block = this.factory.createImage(this.blockSize);
                for (int i = 0; i < this.blocks.length; ++i) {
                    LRFFTThreads.convolve2BlockCPU(this.blocks[i], image, (Image<FloatType>)result, (Image<FloatType>)block, this.fftConvolution2);
                }
                block.close();
                return result;
            }
            FourierConvolution<FloatType, FloatType> fftConv = this.fftConvolution2;
            fftConv.replaceImage(image);
            fftConv.process();
            return fftConv.getResult();
        }
        if (this.useCUDA && !this.useCPU && this.numDevices == 1) {
            Image result = image.createNewImage();
            Image block = this.factory.createImage(this.blockSize);
            for (int i = 0; i < this.blocks.length; ++i) {
                LRFFTThreads.convolve2BlockCUDA(this.blocks[i], this.device0, image, (Image<FloatType>)result, (Image<FloatType>)block, this.kernel2, this.blockSize);
            }
            block.close();
            return result;
        }
        Image result = image.createNewImage();
        AtomicInteger ai = new AtomicInteger();
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.deviceList.length);
        for (int i = 0; i < this.deviceList.length; ++i) {
            threads[i] = this.deviceList[i] == -1 ? LRFFTThreads.getCPUThread2(ai, this.blocks, this.blockSize, this.factory, image, (Image<FloatType>)result, this.fftConvolution2) : LRFFTThreads.getCUDAThread2(ai, this.blocks, this.blockSize, this.factory, image, (Image<FloatType>)result, this.deviceList[i], this.kernel2);
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        return result;
    }

    public LRFFT clone() {
        LRFFT viewClone = new LRFFT((Image<FloatType>)this.image.clone(), (Image<FloatType>)this.weight.clone(), (Image<FloatType>)this.kernel1.clone(), this.deviceList, this.useBlocks, this.blockSize);
        viewClone.numViews = this.numViews;
        viewClone.iterationType = this.iterationType;
        viewClone.views = this.views;
        viewClone.iteration = this.iteration;
        if (this.kernel2 != null) {
            viewClone.kernel2 = this.kernel2.clone();
        }
        if (this.viewContribution != null) {
            viewClone.viewContribution = this.viewContribution.clone();
        }
        if (this.fftConvolution1 != null) {
            viewClone.fftConvolution1 = new FourierConvolution(this.fftConvolution1.getImage(), this.fftConvolution1.getKernel());
            viewClone.fftConvolution1.process();
        }
        if (this.fftConvolution2 != null) {
            viewClone.fftConvolution2 = new FourierConvolution(this.fftConvolution2.getImage(), this.fftConvolution2.getKernel());
            viewClone.fftConvolution2.process();
        }
        return viewClone;
    }

    public static enum PSFTYPE {
        OPTIMIZATION_II,
        OPTIMIZATION_I,
        EFFICIENT_BAYESIAN,
        INDEPENDENT;

    }
}

