/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution2;

import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.postprocessing.deconvolution2.Block;
import mpicbg.spim.postprocessing.deconvolution2.LRFFT;

public class LRFFTThreads {
    protected static final void convolve1BlockCPU(Block blockStruct, int i, Image<FloatType> image, Image<FloatType> result, Image<FloatType> block, FourierConvolution<FloatType, FloatType> fftConvolution1) {
        long time = System.currentTimeMillis();
        blockStruct.copyBlock(image, block);
        System.out.println(" block " + i + "(CPU): copy " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        fftConvolution1.replaceImage(block);
        fftConvolution1.process();
        System.out.println(" block " + i + "(CPU): compute " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        blockStruct.pasteBlock(result, (Image<FloatType>)fftConvolution1.getResult());
        System.out.println(" block " + i + "(CPU): paste " + (System.currentTimeMillis() - time));
    }

    protected static final void convolve2BlockCPU(Block blockStruct, Image<FloatType> image, Image<FloatType> result, Image<FloatType> block, FourierConvolution<FloatType, FloatType> fftConvolution2) {
        blockStruct.copyBlock(image, block);
        fftConvolution2.replaceImage(block);
        fftConvolution2.process();
        blockStruct.pasteBlock(result, (Image<FloatType>)fftConvolution2.getResult());
    }

    protected static final void convolve1BlockCUDA(Block blockStruct, int i, int deviceId, Image<FloatType> image, Image<FloatType> result, Image<FloatType> block, Image<FloatType> kernel1, int[] blockSize) {
        long time = System.currentTimeMillis();
        blockStruct.copyBlock(image, block);
        System.out.println(" block " + i + "(CPU  " + deviceId + "): copy " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        LRFFT.cuda.convolution3DfftCUDAInPlace(((FloatArray)((Array)block.getContainer()).update(null)).getCurrentStorageArray(), LRFFTThreads.getCUDACoordinates(blockSize), ((FloatArray)((Array)kernel1.getContainer()).update(null)).getCurrentStorageArray(), LRFFTThreads.getCUDACoordinates(kernel1.getDimensions()), deviceId);
        System.out.println(" block " + i + "(CUDA " + deviceId + "): compute " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        blockStruct.pasteBlock(result, block);
        System.out.println(" block " + i + "(CPU  " + deviceId + "): paste " + (System.currentTimeMillis() - time));
    }

    protected static final void convolve2BlockCUDA(Block blockStruct, int deviceId, Image<FloatType> image, Image<FloatType> result, Image<FloatType> block, Image<FloatType> kernel2, int[] blockSize) {
        blockStruct.copyBlock(image, block);
        LRFFT.cuda.convolution3DfftCUDAInPlace(((FloatArray)((Array)block.getContainer()).update(null)).getCurrentStorageArray(), LRFFTThreads.getCUDACoordinates(blockSize), ((FloatArray)((Array)kernel2.getContainer()).update(null)).getCurrentStorageArray(), LRFFTThreads.getCUDACoordinates(kernel2.getDimensions()), deviceId);
        blockStruct.pasteBlock(result, block);
    }

    protected static final Thread getCPUThread1(final AtomicInteger ai, final Block[] blocks, final int[] blockSize, final ImageFactory<FloatType> factory, final Image<FloatType> image, final Image<FloatType> result, final FourierConvolution<FloatType, FloatType> fftConvolution1) {
        Thread cpuThread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Image block = factory.createImage(blockSize);
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    LRFFTThreads.convolve1BlockCPU(blocks[i], i, (Image<FloatType>)image, (Image<FloatType>)result, (Image<FloatType>)block, (FourierConvolution<FloatType, FloatType>)fftConvolution1);
                }
                block.close();
            }
        });
        return cpuThread1;
    }

    protected static final Thread getCPUThread2(final AtomicInteger ai, final Block[] blocks, final int[] blockSize, final ImageFactory<FloatType> factory, final Image<FloatType> image, final Image<FloatType> result, final FourierConvolution<FloatType, FloatType> fftConvolution2) {
        Thread cpuThread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Image block = factory.createImage(blockSize);
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    LRFFTThreads.convolve2BlockCPU(blocks[i], (Image<FloatType>)image, (Image<FloatType>)result, (Image<FloatType>)block, (FourierConvolution<FloatType, FloatType>)fftConvolution2);
                }
                block.close();
            }
        });
        return cpuThread2;
    }

    protected static final Thread getCUDAThread1(final AtomicInteger ai, final Block[] blocks, final int[] blockSize, final ImageFactory<FloatType> factory, final Image<FloatType> image, final Image<FloatType> result, final int deviceId, final Image<FloatType> kernel1) {
        Thread cudaThread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Image block = factory.createImage(blockSize);
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    LRFFTThreads.convolve1BlockCUDA(blocks[i], i, deviceId, (Image<FloatType>)image, (Image<FloatType>)result, (Image<FloatType>)block, (Image<FloatType>)kernel1, blockSize);
                }
                block.close();
            }
        });
        return cudaThread1;
    }

    protected static final Thread getCUDAThread2(final AtomicInteger ai, final Block[] blocks, final int[] blockSize, final ImageFactory<FloatType> factory, final Image<FloatType> image, final Image<FloatType> result, final int deviceId, final Image<FloatType> kernel2) {
        Thread cudaThread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Image block = factory.createImage(blockSize);
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    LRFFTThreads.convolve2BlockCUDA(blocks[i], deviceId, (Image<FloatType>)image, (Image<FloatType>)result, (Image<FloatType>)block, (Image<FloatType>)kernel2, blockSize);
                }
                block.close();
            }
        });
        return cudaThread2;
    }

    private static final int[] getCUDACoordinates(int[] c) {
        int[] cuda = new int[c.length];
        for (int d = 0; d < c.length; ++d) {
            cuda[c.length - d - 1] = c[d];
        }
        return cuda;
    }
}

