/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import fiji.util.gui.GenericDialogPlus;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import spim.fiji.datasetmanager.DHMMetaData;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.DHMImgLoader;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class DHM
implements MultiViewDatasetDefinition {
    public static String defaultDir = "";
    public static double defaulCalX = 0.1725;
    public static double defaulCalY = 0.1725;
    public static double defaulCalZ = 1.25;
    public static String defaulCalUnit = "um";
    public static boolean defaultOpenAll = false;

    @Override
    public String getTitle() {
        return "Holographic Imaging Dataset";
    }

    @Override
    public String getExtendedDescription() {
        return "This dataset definition supports data as created by a holographic microscope\n(Amplitude & Phase stacks in 3d over time)";
    }

    @Override
    public SpimData2 createDataset() {
        DHMMetaData meta = this.queryDirectoryAndRatio();
        if (meta == null) {
            return null;
        }
        if (!meta.loadMetaData()) {
            return null;
        }
        TimePoints timepoints = this.createTimePoints(meta);
        ArrayList<ViewSetup> setups = this.createViewSetups(meta);
        MissingViews missingViews = null;
        SequenceDescription sequenceDescription = new SequenceDescription(timepoints, setups, null, missingViews);
        DHMImgLoader imgLoader = new DHMImgLoader(meta.getDir(), meta.getStackDir(), meta.getAmplitudeDir(), meta.getPhaseDir(), meta.getTimepoints(), meta.getZPlanes(), meta.getExt(), meta.getAmpChannelId(), meta.getPhaseChannelId(), (AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?>)sequenceDescription);
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
        double minResolution = Math.min(Math.min(meta.calX, meta.calY), meta.calZ);
        IOFunctions.println("Minimal resolution in all dimensions is: " + minResolution);
        IOFunctions.println("(The smallest resolution in any dimension; the distance between two pixels in the output image will be that wide)");
        ViewRegistrations viewRegistrations = StackList.createViewRegistrations(sequenceDescription.getViewDescriptions(), minResolution);
        ViewInterestPoints viewInterestPoints = new ViewInterestPoints();
        viewInterestPoints.createViewInterestPoints(sequenceDescription.getViewDescriptions());
        SpimData2 spimData = new SpimData2(meta.getDir(), sequenceDescription, viewRegistrations, viewInterestPoints, new BoundingBoxes());
        return spimData;
    }

    protected TimePoints createTimePoints(DHMMetaData meta) {
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        for (int t = 0; t < meta.getTimepoints().size(); ++t) {
            timepoints.add(new TimePoint(Integer.parseInt(meta.getTimepoints().get(t))));
        }
        return new TimePoints(timepoints);
    }

    protected ArrayList<ViewSetup> createViewSetups(DHMMetaData meta) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channels.add(new Channel(meta.getAmpChannelId(), meta.getAmplitudeDir()));
        channels.add(new Channel(meta.getPhaseChannelId(), meta.getPhaseDir()));
        ArrayList<Illumination> illuminations = new ArrayList<Illumination>();
        illuminations.add(new Illumination(0, String.valueOf(0)));
        ArrayList<Angle> angles = new ArrayList<Angle>();
        angles.add(new Angle(0, String.valueOf(0)));
        ArrayList<ViewSetup> viewSetups = new ArrayList<ViewSetup>();
        for (Channel c : channels) {
            for (Illumination i : illuminations) {
                for (Angle a : angles) {
                    FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(meta.calUnit, new double[]{meta.calX, meta.calY, meta.calZ});
                    FinalDimensions dim = new FinalDimensions(new long[]{meta.getWidth(), meta.getHeight(), meta.getDepth()});
                    viewSetups.add(new ViewSetup(viewSetups.size(), null, (Dimensions)dim, (VoxelDimensions)voxelSize, c, a, i));
                }
            }
        }
        return viewSetups;
    }

    protected DHMMetaData queryDirectoryAndRatio() {
        GenericDialogPlus gd = new GenericDialogPlus("Specify Holographic Acquistion Directory");
        gd.addDirectoryField("Holographic_Acquisition main directory", defaultDir, 50);
        gd.addMessage("");
        gd.addMessage("Camera pixel size (e.g. 3.45um) / Magnification (e.g. 20):");
        gd.addNumericField("Pixel_distance_x", defaulCalX, 5);
        gd.addNumericField("Pixel_distance_y", defaulCalY, 5);
        gd.addMessage("Depth between planes (e.g. 0.5mm) / Magnification^2 (e.g. 20^2) * 1000 (mm to um):");
        gd.addNumericField("Pixel_distance_z", defaulCalZ, 5);
        gd.addStringField("Pixel_unit", defaulCalUnit);
        gd.addMessage("");
        gd.addCheckbox("Open_all planes to ensure they have the same dimensions (takes time!)", defaultOpenAll);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultDir = gd.getNextString();
        defaulCalX = gd.getNextNumber();
        defaulCalY = gd.getNextNumber();
        defaulCalZ = gd.getNextNumber();
        defaulCalUnit = gd.getNextString();
        defaultOpenAll = gd.getNextBoolean();
        return new DHMMetaData(new File(defaultDir), defaulCalX, defaulCalY, defaulCalZ, defaulCalUnit, defaultOpenAll);
    }

    @Override
    public MultiViewDatasetDefinition newInstance() {
        return new DHM();
    }

    public static void main(String[] args) {
        new DHM().createDataset();
    }
}

