/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.type.NativeType;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.imgloaders.AbstractImgFactoryImgLoader;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.DisplayImage;

public class Display_View
implements PlugIn {
    public static int defaultAngleChoice = 0;
    public static int defaultChannelChoice = 0;
    public static int defaultIlluminationChoice = 0;
    public static int defaultTimepointChoice = 0;
    public static int defaultPixelType = 0;

    public void run(String arg0) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("displaying a view", false, false, false, false)) {
            return;
        }
        GenericDialog gd = new GenericDialog("Select View");
        List<TimePoint> timepoints = result.getTimePointsToProcess();
        String[] timepointNames = new String[timepoints.size()];
        for (int i = 0; i < timepointNames.length; ++i) {
            timepointNames[i] = result.getTimePointsToProcess().get(i).getName();
        }
        List angles = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllAnglesOrdered();
        String[] angleNames = new String[angles.size()];
        for (int i = 0; i < angles.size(); ++i) {
            angleNames[i] = ((Angle)angles.get(i)).getName();
        }
        List channels = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllChannelsOrdered();
        String[] channelNames = new String[channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            channelNames[i] = ((Channel)channels.get(i)).getName();
        }
        List illuminations = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllIlluminationsOrdered();
        String[] illuminationNames = new String[illuminations.size()];
        for (int i = 0; i < illuminations.size(); ++i) {
            illuminationNames[i] = ((Illumination)illuminations.get(i)).getName();
        }
        gd.addChoice("Angle", angleNames, angleNames[defaultAngleChoice]);
        gd.addChoice("Channel", channelNames, channelNames[defaultChannelChoice]);
        gd.addChoice("Illumination", illuminationNames, illuminationNames[defaultIlluminationChoice]);
        gd.addChoice("Timepoint", timepointNames, timepointNames[defaultTimepointChoice]);
        gd.addMessage("");
        gd.addChoice("Pixel_type", BoundingBoxGUI.pixelTypes, BoundingBoxGUI.pixelTypes[defaultPixelType]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        defaultAngleChoice = gd.getNextChoiceIndex();
        Angle angle = (Angle)angles.get(defaultAngleChoice);
        defaultChannelChoice = gd.getNextChoiceIndex();
        Channel channel = (Channel)channels.get(defaultChannelChoice);
        defaultIlluminationChoice = gd.getNextChoiceIndex();
        Illumination illumination = (Illumination)illuminations.get(defaultIlluminationChoice);
        defaultTimepointChoice = gd.getNextChoiceIndex();
        TimePoint tp = timepoints.get(defaultTimepointChoice);
        int pixelType = defaultPixelType = gd.getNextChoiceIndex();
        ViewId viewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), tp, channel, angle, illumination);
        String name = Display_View.name(((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getViewDescription(viewId));
        if (viewId == null) {
            IOFunctions.println("This ViewSetup is not present for this timepoint: angle: " + name);
            return;
        }
        ViewDescription viewDescription = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
        if (!viewDescription.isPresent()) {
            IOFunctions.println("This ViewSetup is not present for this timepoint: angle: " + name);
            return;
        }
        Display_View.display(result.getData(), viewId, pixelType, name, false);
    }

    public static String name(ViewDescription vd) {
        Angle angle = ((ViewSetup)vd.getViewSetup()).getAngle();
        Channel channel = ((ViewSetup)vd.getViewSetup()).getChannel();
        Illumination illumination = ((ViewSetup)vd.getViewSetup()).getIllumination();
        TimePoint tp = vd.getTimePoint();
        return "angle: " + angle.getName() + " channel: " + channel.getName() + " illum: " + illumination.getName() + " timepoint: " + tp.getName();
    }

    public static void display(AbstractSpimData<?> spimData, ViewId viewId, int pixelType, String name, boolean virtual) {
        ImgFactory<? extends NativeType<?>> factory;
        AbstractImgFactoryImgLoader il;
        ImgLoader imgLoader = (ImgLoader)spimData.getSequenceDescription().getImgLoader();
        if (AbstractImgFactoryImgLoader.class.isInstance(imgLoader)) {
            il = (AbstractImgFactoryImgLoader)imgLoader;
            factory = il.getImgFactory();
            il.setImgFactory((ImgFactory<? extends NativeType<?>>)new ImagePlusImgFactory());
        } else {
            il = null;
            factory = null;
        }
        DisplayImage export = new DisplayImage(virtual);
        if (pixelType == 0) {
            export.exportImage(((ImgLoader)spimData.getSequenceDescription().getImgLoader()).getSetupImgLoader(viewId.getViewSetupId()).getFloatImage(viewId.getTimePointId(), false, new ImgLoaderHint[0]), name);
        } else {
            RandomAccessibleInterval img = ((ImgLoader)spimData.getSequenceDescription().getImgLoader()).getSetupImgLoader(viewId.getViewSetupId()).getImage(viewId.getTimePointId(), new ImgLoaderHint[0]);
            export.exportImage(img, name);
        }
        if (factory != null && il != null) {
            il.setImgFactory(factory);
        }
    }

    public static void main(String[] args) {
        new ImageJ();
        new Display_View().run(null);
    }
}

