/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.queryXML.GenericLoadParseQueryXML;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.spimdata.SpimData2;

public class Duplicate_Transformation
implements PlugIn {
    public static String[] duplicationChoice = new String[]{"One timepoint to other timepoints", "One channel to other channels", "One illumination direction to other illumination directions", "One angle to other angles"};
    public static String[] transformationChoice = new String[]{"Replace all transformations", "Add last transformation only", "Add multiple transformations"};
    public static String[] tpChoice = new String[]{"All Timepoints", "Single Timepoint (Select from List)", "Multiple Timepoints (Select from List)", "Range of Timepoints (Specify by Name)"};
    public static int defaultTPChoice = 0;
    public static int defaultTimePointIndex = 0;
    public static boolean[] defaultTimePointIndices = null;
    public static String defaultTimePointString = null;
    public static String[] angleChoice = new String[]{"All Angles", "Single Angle (Select from List)", "Multiple Angles (Select from List)", "Range of Angles (Specify by Name)"};
    public static int defaultAngleChoice = 0;
    public static int defaultAngleIndex = 0;
    public static boolean[] defaultAngleIndices = null;
    public static String defaultAngleString = null;
    public static String[] channelChoice = new String[]{"All Channels", "Single Channel (Select from List)", "Multiple Channels (Select from List)", "Range of Channels (Specify by Name)"};
    public static int defaultChannelChoice = 0;
    public static int defaultChannelIndex = 0;
    public static boolean[] defaultChannelIndices = null;
    public static String defaultChannelString = null;
    public static String[] illumChoice = new String[]{"All Illumination Directions", "Single Illumination Directions (Select from List)", "Multiple Illumination Directions (Select from List)", "Range of Illumination Directions (Specify by Name)"};
    public static int defaultIllumChoice = 0;
    public static int defaultIllumIndex = 0;
    public static boolean[] defaultIllumIndices = null;
    public static String defaultIllumString = null;
    public static int defaultChoice = 0;
    public static int defaultTransformationChoice = 0;
    public static int defaultNumTransformations = 2;
    public static int defaultTimePoint = 0;
    public static int defaultSelectedTimePointIndex = 1;
    public static int defaultChannel = 0;
    public static int defaultSelectedChannelIndex = 1;
    public static int defaultIllum = 0;
    public static int defaultSelectedIllumIndex = 1;
    public static int defaultAngle = 0;
    public static int defaultSelectedAngleIndex = 1;

    public void run(String arg0) {
        boolean askForTimepoints;
        boolean askForIllum;
        boolean askForChannels;
        int choice;
        GenericDialog gd = new GenericDialog("Define Duplication");
        gd.addChoice("Apply transformation of", duplicationChoice, duplicationChoice[defaultChoice]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        LoadParseQueryXML result = new LoadParseQueryXML();
        boolean askForAngles = choice != 3;
        if (!result.queryXML("duplicating transformations", "Apply to", askForAngles, askForChannels = choice != 1, askForIllum = choice != 2, askForTimepoints = (choice = (defaultChoice = gd.getNextChoiceIndex())) != 0)) {
            return;
        }
        if (!askForTimepoints) {
            if (result.getTimePointsToProcess().size() == 1) {
                IOFunctions.println("Only one timepoint available, cannot apply to another timepoint.");
                return;
            }
            if (!this.applyTimepoints(result)) {
                return;
            }
        } else if (!askForChannels) {
            if (result.getChannelsToProcess().size() == 1) {
                IOFunctions.println("Only one channel available, cannot apply to another channel.");
                return;
            }
            if (!this.applyChannels(result)) {
                return;
            }
        } else if (!askForIllum) {
            if (result.getIlluminationsToProcess().size() == 1) {
                IOFunctions.println("Only one illumination direction available, cannot apply to another illumination direction.");
                return;
            }
            if (!this.applyIllums(result)) {
                return;
            }
        } else if (!askForAngles) {
            if (result.getAnglesToProcess().size() == 1) {
                IOFunctions.println("Only one angle available, cannot apply to another angle.");
                return;
            }
            if (!this.applyAngles(result)) {
                return;
            }
        }
        SpimData2.saveXML((SpimData2)((Object)result.getData()), new File(result.getXMLFileName()).getName(), result.getClusterExtension());
    }

    protected void askForRegistrations(GenericDialog gd) {
        gd.addMessage("");
        gd.addChoice("Duplicate_which_transformations", transformationChoice, transformationChoice[defaultTransformationChoice]);
    }

    protected int parseRegistrations(GenericDialog gd) {
        defaultTransformationChoice = gd.getNextChoiceIndex();
        int transformation = defaultTransformationChoice;
        if (transformation == 2) {
            GenericDialog gd2 = new GenericDialog("Choose number of transformations");
            gd2.addNumericField("Number of transformations to add", (double)defaultNumTransformations, 0);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return -1;
            }
            transformation = (int)Math.round(gd2.getNextNumber());
        }
        return transformation;
    }

    protected void duplicateTransformations(int transformations, ViewId sourceViewId, ViewId targetViewId, SpimData2 spimData) {
        ViewDescription sourceVD = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(sourceViewId.getTimePointId(), sourceViewId.getViewSetupId());
        ViewDescription targetVD = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(targetViewId.getTimePointId(), targetViewId.getViewSetupId());
        ViewSetup sourceVS = (ViewSetup)sourceVD.getViewSetup();
        ViewSetup targetVS = (ViewSetup)targetVD.getViewSetup();
        IOFunctions.println("Source viewId t=" + sourceVD.getTimePoint().getName() + ", ch=" + sourceVS.getChannel().getName() + ", ill=" + sourceVS.getIllumination().getName() + ", angle=" + sourceVS.getAngle().getName());
        IOFunctions.println("Target viewId t=" + targetVD.getTimePoint().getName() + ", ch=" + targetVS.getChannel().getName() + ", ill=" + targetVS.getIllumination().getName() + ", angle=" + targetVS.getAngle().getName());
        if (!sourceVD.isPresent() || !targetVD.isPresent()) {
            if (!sourceVD.isPresent()) {
                IOFunctions.println("Source viewId is NOT present");
            }
            if (!targetVD.isPresent()) {
                IOFunctions.println("Target viewId is NOT present");
            }
            return;
        }
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ViewRegistration vrSource = viewRegistrations.getViewRegistration(sourceViewId);
        ViewRegistration vrTarget = viewRegistrations.getViewRegistration(targetViewId);
        if (transformations == 0) {
            vrTarget.identity();
            for (ViewTransform vt : vrSource.getTransformList()) {
                IOFunctions.println("Concatenationg model " + vt.getName() + ", " + vt.asAffine3D());
                vrTarget.concatenateTransform(vt);
            }
        } else {
            int k;
            ArrayList vts = new ArrayList();
            for (k = 0; k < transformations; ++k) {
                vts.add(vrSource.getTransformList().get(k));
            }
            for (k = vts.size() - 1; k >= 0; --k) {
                ViewTransform vt = (ViewTransform)vts.get(k);
                IOFunctions.println("Adding model " + vt.getName() + ", " + vt.asAffine3D());
                vrTarget.preconcatenateTransform(vt);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean applyTimepoints(LoadParseQueryXML result) {
        GenericDialog gd = new GenericDialog("Define source and target timepoints");
        String[] timepoints = this.assembleTimepoints(result.getTimePointsToProcess());
        if (defaultTimePoint >= timepoints.length) {
            defaultTimePoint = 0;
        }
        gd.addChoice("Source timepoint", timepoints, timepoints[defaultTimePoint]);
        gd.addChoice("Target timepoint(s)", tpChoice, tpChoice[defaultTPChoice]);
        this.askForRegistrations(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultTimePoint = gd.getNextChoiceIndex();
        TimePoint source = result.getTimePointsToProcess().get(defaultTimePoint);
        ArrayList<TimePoint> targets = new ArrayList<TimePoint>();
        defaultTPChoice = gd.getNextChoiceIndex();
        int choice = defaultTPChoice;
        if (choice == 1) {
            int selection;
            if (defaultSelectedTimePointIndex >= timepoints.length) {
                defaultSelectedTimePointIndex = 1;
            }
            if ((selection = GenericLoadParseQueryXML.queryIndividualEntry("Timepoint", timepoints, defaultSelectedTimePointIndex)) < 0) return false;
            defaultSelectedTimePointIndex = selection;
            targets.add(result.getTimePointsToProcess().get(defaultSelectedTimePointIndex));
        } else if (choice == 2 || choice == 3) {
            String[] defaultTimePoint = new String[]{defaultTimePointString};
            boolean[] selection = choice == 2 ? GenericLoadParseQueryXML.queryMultipleEntries("Timepoints", timepoints, defaultTimePointIndices) : GenericLoadParseQueryXML.queryPattern("Timepoints", timepoints, defaultTimePoint);
            if (selection == null) {
                return false;
            }
            defaultTimePointIndices = selection;
            if (choice == 3) {
                defaultTimePointString = defaultTimePoint[0];
            }
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i]) continue;
                targets.add(result.getTimePointsToProcess().get(i));
            }
        } else {
            targets.addAll(result.getTimePointsToProcess());
        }
        if (targets.size() == 0) {
            IOFunctions.println("List of timepoints is empty. Stopping.");
            return false;
        }
        int transformations = this.parseRegistrations(gd);
        if (transformations < 0) {
            return false;
        }
        int countApplied = 0;
        for (int j = 0; j < targets.size(); ++j) {
            if (source.equals(targets.get(j))) continue;
            IOFunctions.println("Applying timepoint " + source.getName() + " >>> " + ((TimePoint)targets.get(j)).getName());
            ++countApplied;
            for (Channel c : result.getChannelsToProcess()) {
                for (Illumination i : result.getIlluminationsToProcess()) {
                    for (Angle a : result.getAnglesToProcess()) {
                        ViewId sourceViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), source, c, a, i);
                        ViewId targetViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), (TimePoint)targets.get(j), c, a, i);
                        if (sourceViewId == null || targetViewId == null) continue;
                        this.duplicateTransformations(transformations, sourceViewId, targetViewId, (SpimData2)((Object)result.getData()));
                    }
                }
            }
        }
        return countApplied != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean applyChannels(LoadParseQueryXML result) {
        GenericDialog gd = new GenericDialog("Define source and target channels");
        String[] channels = this.assembleChannels(result.getChannelsToProcess());
        if (defaultChannel >= channels.length) {
            defaultChannel = 0;
        }
        gd.addChoice("Source channel", channels, channels[defaultChannel]);
        gd.addChoice("Target channel(s)", channelChoice, channelChoice[defaultChannelChoice]);
        this.askForRegistrations(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultChannel = gd.getNextChoiceIndex();
        Channel source = result.getChannelsToProcess().get(defaultChannel);
        ArrayList<Channel> targets = new ArrayList<Channel>();
        defaultChannelChoice = gd.getNextChoiceIndex();
        int choice = defaultChannelChoice;
        if (choice == 1) {
            int selection;
            if (defaultSelectedChannelIndex >= channels.length) {
                defaultSelectedChannelIndex = 1;
            }
            if ((selection = GenericLoadParseQueryXML.queryIndividualEntry("Channel", channels, defaultSelectedChannelIndex)) < 0) return false;
            defaultSelectedChannelIndex = selection;
            targets.add(result.getChannelsToProcess().get(defaultSelectedChannelIndex));
        } else if (choice == 2 || choice == 3) {
            String[] defaultChannel = new String[]{defaultChannelString};
            boolean[] selection = choice == 2 ? GenericLoadParseQueryXML.queryMultipleEntries("Channels", channels, defaultChannelIndices) : GenericLoadParseQueryXML.queryPattern("Channels", channels, defaultChannel);
            if (selection == null) {
                return false;
            }
            defaultChannelIndices = selection;
            if (choice == 3) {
                defaultChannelString = defaultChannel[0];
            }
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i]) continue;
                targets.add(result.getChannelsToProcess().get(i));
            }
        } else {
            targets.addAll(result.getChannelsToProcess());
        }
        if (targets.size() == 0) {
            IOFunctions.println("List of channels is empty. Stopping.");
            return false;
        }
        int transformations = this.parseRegistrations(gd);
        if (transformations < 0) {
            return false;
        }
        int countApplied = 0;
        for (int j = 0; j < targets.size(); ++j) {
            if (source.equals(targets.get(j))) continue;
            IOFunctions.println("Applying chanel " + source.getName() + " >>> " + ((Channel)targets.get(j)).getName());
            ++countApplied;
            for (TimePoint t : result.getTimePointsToProcess()) {
                for (Illumination i : result.getIlluminationsToProcess()) {
                    for (Angle a : result.getAnglesToProcess()) {
                        ViewId sourceViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, source, a, i);
                        ViewId targetViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, (Channel)targets.get(j), a, i);
                        if (sourceViewId == null || targetViewId == null) continue;
                        this.duplicateTransformations(transformations, sourceViewId, targetViewId, (SpimData2)((Object)result.getData()));
                    }
                }
            }
        }
        return countApplied != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean applyIllums(LoadParseQueryXML result) {
        GenericDialog gd = new GenericDialog("Define source and target illumination directions");
        String[] illums = this.assembleIllums(result.getIlluminationsToProcess());
        if (defaultIllum >= illums.length) {
            defaultIllum = 0;
        }
        gd.addChoice("Source illumination direction", illums, illums[defaultIllum]);
        gd.addChoice("Target illumination direction(s)", illumChoice, illumChoice[defaultIllumChoice]);
        this.askForRegistrations(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultIllum = gd.getNextChoiceIndex();
        Illumination source = result.getIlluminationsToProcess().get(defaultIllum);
        ArrayList<Illumination> targets = new ArrayList<Illumination>();
        defaultIllumChoice = gd.getNextChoiceIndex();
        int choice = defaultIllumChoice;
        if (choice == 1) {
            int selection;
            if (defaultSelectedIllumIndex >= illums.length) {
                defaultSelectedIllumIndex = 1;
            }
            if ((selection = GenericLoadParseQueryXML.queryIndividualEntry("Illumination direction", illums, defaultSelectedIllumIndex)) < 0) return false;
            defaultSelectedIllumIndex = selection;
            targets.add(result.getIlluminationsToProcess().get(defaultSelectedIllumIndex));
        } else if (choice == 2 || choice == 3) {
            String[] defaultIllum = new String[]{defaultIllumString};
            boolean[] selection = choice == 2 ? GenericLoadParseQueryXML.queryMultipleEntries("Illumination directions", illums, defaultIllumIndices) : GenericLoadParseQueryXML.queryPattern("Illumination directions", illums, defaultIllum);
            if (selection == null) {
                return false;
            }
            defaultIllumIndices = selection;
            if (choice == 3) {
                defaultIllumString = defaultIllum[0];
            }
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i]) continue;
                targets.add(result.getIlluminationsToProcess().get(i));
            }
        } else {
            targets.addAll(result.getIlluminationsToProcess());
        }
        if (targets.size() == 0) {
            IOFunctions.println("List of illumination directions is empty. Stopping.");
            return false;
        }
        int transformations = this.parseRegistrations(gd);
        if (transformations < 0) {
            return false;
        }
        int countApplied = 0;
        for (int j = 0; j < targets.size(); ++j) {
            if (source.equals(targets.get(j))) continue;
            IOFunctions.println("Applying illumination direction " + source.getName() + " >>> " + ((Illumination)targets.get(j)).getName());
            ++countApplied;
            for (TimePoint t : result.getTimePointsToProcess()) {
                for (Channel c : result.getChannelsToProcess()) {
                    for (Angle a : result.getAnglesToProcess()) {
                        ViewId sourceViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, c, a, source);
                        ViewId targetViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, c, a, (Illumination)targets.get(j));
                        if (sourceViewId == null || targetViewId == null) continue;
                        this.duplicateTransformations(transformations, sourceViewId, targetViewId, (SpimData2)((Object)result.getData()));
                    }
                }
            }
        }
        return countApplied != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean applyAngles(LoadParseQueryXML result) {
        GenericDialog gd = new GenericDialog("Define source and target angles");
        String[] angles = this.assembleAngles(result.getAnglesToProcess());
        if (defaultAngle >= angles.length) {
            defaultAngle = 0;
        }
        gd.addChoice("Source angle", angles, angles[defaultAngle]);
        gd.addChoice("Target angles(s)", angleChoice, angleChoice[defaultAngleChoice]);
        this.askForRegistrations(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        defaultAngle = gd.getNextChoiceIndex();
        Angle source = result.getAnglesToProcess().get(defaultAngle);
        ArrayList<Angle> targets = new ArrayList<Angle>();
        defaultAngleChoice = gd.getNextChoiceIndex();
        int choice = defaultAngleChoice;
        if (choice == 1) {
            int selection;
            if (defaultSelectedAngleIndex >= angles.length) {
                defaultSelectedAngleIndex = 1;
            }
            if ((selection = GenericLoadParseQueryXML.queryIndividualEntry("Angle", angles, defaultSelectedAngleIndex)) < 0) return false;
            defaultSelectedAngleIndex = selection;
            targets.add(result.getAnglesToProcess().get(defaultSelectedAngleIndex));
        } else if (choice == 2 || choice == 3) {
            String[] defaultAngle = new String[]{defaultAngleString};
            boolean[] selection = choice == 2 ? GenericLoadParseQueryXML.queryMultipleEntries("Angles", angles, defaultAngleIndices) : GenericLoadParseQueryXML.queryPattern("Angles", angles, defaultAngle);
            if (selection == null) {
                return false;
            }
            defaultAngleIndices = selection;
            if (choice == 3) {
                defaultAngleString = defaultAngle[0];
            }
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i]) continue;
                targets.add(result.getAnglesToProcess().get(i));
            }
        } else {
            targets.addAll(result.getAnglesToProcess());
        }
        if (targets.size() == 0) {
            IOFunctions.println("List of angles is empty. Stopping.");
            return false;
        }
        int transformations = this.parseRegistrations(gd);
        if (transformations < 0) {
            return false;
        }
        int countApplied = 0;
        for (int j = 0; j < targets.size(); ++j) {
            if (source.equals(targets.get(j))) continue;
            IOFunctions.println("Applying angle " + source.getName() + " >>> " + ((Angle)targets.get(j)).getName());
            ++countApplied;
            for (TimePoint t : result.getTimePointsToProcess()) {
                for (Channel c : result.getChannelsToProcess()) {
                    for (Illumination i : result.getIlluminationsToProcess()) {
                        ViewId sourceViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, c, source, i);
                        ViewId targetViewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), t, c, (Angle)targets.get(j), i);
                        if (sourceViewId == null || targetViewId == null) continue;
                        this.duplicateTransformations(transformations, sourceViewId, targetViewId, (SpimData2)((Object)result.getData()));
                    }
                }
            }
        }
        return countApplied != 0;
    }

    protected String[] assembleTimepoints(List<TimePoint> timepoints) {
        String[] tps = new String[timepoints.size()];
        for (int t = 0; t < tps.length; ++t) {
            tps[t] = timepoints.get(t).getName();
        }
        return tps;
    }

    protected String[] assembleChannels(List<Channel> channels) {
        String[] chs = new String[channels.size()];
        for (int t = 0; t < chs.length; ++t) {
            chs[t] = channels.get(t).getName();
        }
        return chs;
    }

    protected String[] assembleIllums(List<Illumination> illums) {
        String[] is = new String[illums.size()];
        for (int t = 0; t < is.length; ++t) {
            is[t] = illums.get(t).getName();
        }
        return is;
    }

    protected String[] assembleAngles(List<Angle> angles) {
        String[] as = new String[angles.size()];
        for (int t = 0; t < as.length; ++t) {
            as[t] = angles.get(t).getName();
        }
        return as;
    }

    public static void main(String[] args) {
        new ImageJ();
        new Duplicate_Transformation().run(null);
    }
}

