/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import bdv.img.hdf5.Hdf5ImageLoader;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;
import spim.process.fusion.boundingbox.AutomaticBoundingBox;
import spim.process.fusion.boundingbox.AutomaticReorientation;
import spim.process.fusion.boundingbox.BigDataViewerBoundingBox;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.boundingbox.PreDefinedBoundingBox;
import spim.process.fusion.deconvolution.EfficientBayesianBased;
import spim.process.fusion.export.AppendSpimData2;
import spim.process.fusion.export.DisplayImage;
import spim.process.fusion.export.ExportSpimData2HDF5;
import spim.process.fusion.export.ExportSpimData2TIFF;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.Save3dTIFF;
import spim.process.fusion.weightedavg.WeightedAverageFusion;

public class Image_Fusion
implements PlugIn {
    public static final ArrayList<Fusion> staticFusionAlgorithms = new ArrayList();
    public static int defaultFusionAlgorithm = 1;
    public static final ArrayList<BoundingBoxGUI> staticBoundingBoxAlgorithms = new ArrayList();
    public static int defaultBoundingBoxAlgorithm = -1;
    public static final ArrayList<ImgExport> staticImgExportAlgorithms = new ArrayList();
    public static int defaultImgExportAlgorithm = 0;

    public void run(String arg) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("image fusion", true, true, true, true)) {
            return;
        }
        this.fuse((SpimData2)((Object)result.getData()), SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()), result.getClusterExtension(), result.getXMLFileName(), true);
    }

    public boolean fuse(SpimData2 data, List<ViewId> viewIds) {
        return this.fuse(data, viewIds, "", null, false);
    }

    public boolean fuse(SpimData2 data, List<ViewId> viewIds, String clusterExtension, String xmlFileName, boolean saveXML) {
        int i;
        String[] fusionDescriptions = new String[staticFusionAlgorithms.size()];
        String[] boundingBoxDescriptions = new String[staticBoundingBoxAlgorithms.size()];
        String[] imgExportDescriptions = new String[staticImgExportAlgorithms.size()];
        for (i = 0; i < staticFusionAlgorithms.size(); ++i) {
            fusionDescriptions[i] = staticFusionAlgorithms.get(i).getDescription();
        }
        for (i = 0; i < staticBoundingBoxAlgorithms.size(); ++i) {
            boundingBoxDescriptions[i] = staticBoundingBoxAlgorithms.get(i).getDescription();
        }
        for (i = 0; i < staticImgExportAlgorithms.size(); ++i) {
            imgExportDescriptions[i] = staticImgExportAlgorithms.get(i).getDescription();
        }
        if (defaultFusionAlgorithm >= fusionDescriptions.length) {
            defaultFusionAlgorithm = 0;
        }
        if (defaultBoundingBoxAlgorithm < 0) {
            defaultBoundingBoxAlgorithm = data.getBoundingBoxes().getBoundingBoxes().size() > 0 ? 4 : 1;
        }
        if (defaultBoundingBoxAlgorithm >= boundingBoxDescriptions.length) {
            defaultBoundingBoxAlgorithm = 0;
        }
        if (defaultImgExportAlgorithm >= imgExportDescriptions.length) {
            defaultImgExportAlgorithm = 0;
        }
        GenericDialog gd = new GenericDialog("Image Fusion");
        gd.addChoice("Type_of_image_fusion", fusionDescriptions, fusionDescriptions[defaultFusionAlgorithm]);
        gd.addChoice("Bounding_Box", boundingBoxDescriptions, boundingBoxDescriptions[defaultBoundingBoxAlgorithm]);
        gd.addChoice("Fused_image", imgExportDescriptions, imgExportDescriptions[defaultImgExportAlgorithm]);
        HashMap<String, Integer> names = GUIHelper.assembleRegistrationNames(data, viewIds);
        gd.addMessage("");
        GUIHelper.displayRegistrationNames(gd, names);
        gd.addMessage("");
        GUIHelper.addWebsite(gd);
        if (names.keySet().size() > 5) {
            GUIHelper.addScrollBars((Container)gd);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int fusionAlgorithm = defaultFusionAlgorithm = gd.getNextChoiceIndex();
        int boundingBoxAlgorithm = defaultBoundingBoxAlgorithm = gd.getNextChoiceIndex();
        int imgExportAlgorithm = defaultImgExportAlgorithm = gd.getNextChoiceIndex();
        Fusion fusion = staticFusionAlgorithms.get(fusionAlgorithm).newInstance(data, viewIds);
        BoundingBoxGUI boundingBox = staticBoundingBoxAlgorithms.get(boundingBoxAlgorithm).newInstance(data, viewIds);
        ImgExport imgExport = staticImgExportAlgorithms.get(imgExportAlgorithm).newInstance();
        if (((SequenceDescription)data.getSequenceDescription()).getImgLoader() instanceof Hdf5ImageLoader) {
            BoundingBoxGUI.defaultPixelType = 1;
        }
        if (!boundingBox.queryParameters(fusion, imgExport)) {
            return false;
        }
        if (!fusion.queryParameters()) {
            return false;
        }
        fusion.defineNewViewSetups(boundingBox);
        imgExport.setXMLData(fusion.getTimepointsToProcess(), fusion.getNewViewSetups());
        if (!imgExport.queryParameters(data, boundingBox.getPixelType() == 1)) {
            return false;
        }
        boolean spimDataModified = false;
        fusion.fuseData(boundingBox, imgExport);
        spimDataModified |= boundingBox.cleanUp();
        if (((SequenceDescription)data.getSequenceDescription()).getImgLoader() instanceof AbstractImgLoader) {
            try {
                for (ViewSetup setup : ((SequenceDescription)data.getSequenceDescription()).getViewSetupsOrdered()) {
                    spimDataModified |= ((AbstractImgLoader)((SequenceDescription)data.getSequenceDescription()).getImgLoader()).updateXMLMetaData(setup, false);
                }
            }
            catch (Exception e) {
                IOFunctions.println("Failed to update metadata, this should not happen: " + e);
            }
        }
        if ((spimDataModified |= imgExport.finish()) && saveXML) {
            SpimData2.saveXML(data, xmlFileName, clusterExtension);
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Fusion finished.");
        return true;
    }

    public static void main(String[] args) {
        LoadParseQueryXML.defaultXMLfilename = "/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM//dataset.xml";
        new ImageJ();
        new Image_Fusion().run(null);
    }

    static {
        IOFunctions.printIJLog = true;
        staticFusionAlgorithms.add(new EfficientBayesianBased(null, null));
        staticFusionAlgorithms.add(new WeightedAverageFusion(null, null, WeightedAverageFusion.WeightedAvgFusionType.FUSEDATA));
        staticFusionAlgorithms.add(new WeightedAverageFusion(null, null, WeightedAverageFusion.WeightedAvgFusionType.INDEPENDENT));
        staticBoundingBoxAlgorithms.add(new BoundingBoxGUI(null, null));
        staticBoundingBoxAlgorithms.add(new BigDataViewerBoundingBox(null, null));
        staticBoundingBoxAlgorithms.add(new AutomaticReorientation(null, null));
        staticBoundingBoxAlgorithms.add(new AutomaticBoundingBox(null, null));
        staticBoundingBoxAlgorithms.add(new PreDefinedBoundingBox(null, null));
        staticImgExportAlgorithms.add(new DisplayImage());
        staticImgExportAlgorithms.add(new Save3dTIFF(null));
        staticImgExportAlgorithms.add(new ExportSpimData2TIFF());
        staticImgExportAlgorithms.add(new ExportSpimData2HDF5());
        staticImgExportAlgorithms.add(new AppendSpimData2());
    }
}

