/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.boundingbox;

import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;

public class BoundingBox
implements Interval,
Comparable<BoundingBox> {
    protected int[] min;
    protected int[] max;
    protected String title;

    public BoundingBox(String title, int[] min, int[] max) {
        this.title = title;
        this.min = min;
        this.max = max;
    }

    public BoundingBox(int[] min, int[] max) {
        this.min = min;
        this.max = max;
        this.title = "DefaultBoundingBox";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getMin() {
        return this.min;
    }

    public int[] getMax() {
        return this.max;
    }

    public long min(int d) {
        return this.min[d];
    }

    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.min[d];
        }
    }

    public void min(Positionable min) {
        min.setPosition(this.min);
    }

    public long max(int d) {
        return this.max[d];
    }

    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.max[d];
        }
    }

    public void max(Positionable max) {
        max.setPosition(this.max);
    }

    public double realMin(int d) {
        return this.min[d];
    }

    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.min[d];
        }
    }

    public void realMin(RealPositionable min) {
        min.setPosition(this.min);
    }

    public double realMax(int d) {
        return this.max[d];
    }

    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.max[d];
        }
    }

    public void realMax(RealPositionable max) {
        max.setPosition(this.max);
    }

    public int numDimensions() {
        return this.min.length;
    }

    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.max.length; ++d) {
            dimensions[d] = this.dimension(d);
        }
    }

    public long dimension(int d) {
        return this.max[d] - this.min[d] + 1;
    }

    @Override
    public int compareTo(BoundingBox o) {
        return o.getTitle().compareTo(this.getTitle());
    }
}

