/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.boundingbox;

import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.boundingbox.BoundingBox;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;

public class XmlIoBoundingBoxes
extends XmlIoSingleton<BoundingBoxes> {
    public XmlIoBoundingBoxes() {
        super("BoundingBoxes", BoundingBoxes.class);
        this.handledTags.add("BoundingBoxDefinition");
    }

    public Element toXml(BoundingBoxes boundingBoxes) {
        Element elem = super.toXml();
        for (BoundingBox bb : boundingBoxes.getBoundingBoxes()) {
            elem.addContent((Content)this.boundingBoxToXml(bb));
        }
        return elem;
    }

    public BoundingBoxes fromXml(Element allBoundingBoxes) throws SpimDataException {
        BoundingBoxes boundingBoxes = (BoundingBoxes)super.fromXml(allBoundingBoxes);
        for (Element boundingBoxElement : allBoundingBoxes.getChildren("BoundingBoxDefinition")) {
            String title = boundingBoxElement.getAttributeValue("name");
            int[] min = XmlHelpers.getIntArray((Element)boundingBoxElement, (String)"min");
            int[] max = XmlHelpers.getIntArray((Element)boundingBoxElement, (String)"max");
            boundingBoxes.addBoundingBox(new BoundingBox(title, min, max));
        }
        return boundingBoxes;
    }

    protected Element boundingBoxToXml(BoundingBox bb) {
        Element elem = new Element("BoundingBoxDefinition");
        elem.setAttribute("name", bb.getTitle());
        elem.addContent((Content)XmlHelpers.intArrayElement((String)"min", (int[])bb.getMin()));
        elem.addContent((Content)XmlHelpers.intArrayElement((String)"max", (int[])bb.getMax()));
        return elem;
    }
}

