/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer;

import java.util.ArrayList;
import java.util.Collections;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.NamedEntity;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.util.Util;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBox;
import spim.fiji.spimdata.explorer.SimpleInfoBox;
import spim.process.fusion.boundingbox.PreDefinedBoundingBox;

public class ViewSetupExplorerInfoBox<AS extends AbstractSpimData<?>> {
    public ViewSetupExplorerInfoBox(AS data, String xml) {
        String text = "";
        text = text + "ImgLoader:\n";
        text = text + data.getSequenceDescription().getImgLoader().getClass().getName() + "\n";
        text = text + data.getSequenceDescription().getImgLoader().toString() + "\n";
        for (Object vs : data.getSequenceDescription().getViewSetupsOrdered()) {
            int d;
            text = text + "\n";
            text = text + "ViewSetup id=" + vs.getId() + ": \n";
            Dimensions dim = vs.getSize();
            VoxelDimensions vDim = vs.getVoxelSize();
            if (dim == null) {
                text = text + "Dimensions of image stack not loaded yet.\n";
            } else {
                text = text + "Dimensions: ";
                for (d = 0; d < dim.numDimensions() - 1; ++d) {
                    text = text + Long.toString(dim.dimension(d)) + " x ";
                }
                text = text + Long.toString(dim.dimension(dim.numDimensions() - 1)) + "px\n";
            }
            if (vDim == null) {
                text = text + "Voxel Dimensions of image stack not loaded yet.\n";
            } else {
                text = text + "Voxel Dimensions: ";
                for (d = 0; d < vDim.numDimensions() - 1; ++d) {
                    text = text + Double.toString(vDim.dimension(d)) + " x ";
                }
                text = text + Double.toString(vDim.dimension(vDim.numDimensions() - 1)) + vDim.unit() + "\n";
            }
            for (String attrib : vs.getAttributes().keySet()) {
                Entity e = (Entity)vs.getAttributes().get(attrib);
                if (Angle.class.isInstance(e)) {
                    Angle a = (Angle)e;
                    text = text + attrib + " " + a.getName() + " (id=" + a.getId() + ")";
                    if (a.hasRotation()) {
                        text = text + ", Rotation Axis " + Util.printCoordinates((double[])a.getRotationAxis()) + ", Rotation Angle " + a.getRotationAngleDegrees();
                    }
                    text = text + "\n";
                    continue;
                }
                if (NamedEntity.class.isInstance(e)) {
                    text = text + attrib + " " + ((NamedEntity)e).getName() + " (id=" + e.getId() + ")\n";
                    continue;
                }
                text = text + attrib + " (id=" + e.getId() + ")\n";
            }
        }
        text = text + "\nTimePoints:\n";
        String tps = "";
        for (TimePoint t : data.getSequenceDescription().getTimePoints().getTimePointsOrdered()) {
            tps = tps + t.getId() + ", ";
        }
        text = text + tps.substring(0, tps.length() - 2) + "\n";
        text = text + "\nBounding Boxes:\n";
        if (SpimData2.class.isInstance(data)) {
            SpimData2 sd = (SpimData2)((Object)data);
            if (sd.getBoundingBoxes().getBoundingBoxes().size() == 0) {
                text = text + "None defined\n";
            } else {
                for (BoundingBox bb : sd.getBoundingBoxes().getBoundingBoxes()) {
                    text = text + PreDefinedBoundingBox.getBoundingBoxDescription(bb) + "\n";
                }
            }
        }
        text = text + "\nMissing Views:\n";
        if (data.getSequenceDescription().getMissingViews() != null && data.getSequenceDescription().getMissingViews().getMissingViews() != null && data.getSequenceDescription().getMissingViews().getMissingViews().size() != 0) {
            ArrayList ids = new ArrayList();
            ids.addAll(data.getSequenceDescription().getMissingViews().getMissingViews());
            Collections.sort(ids);
            for (ViewId viewId : ids) {
                text = text + "Timepoint: " + viewId.getTimePointId() + ", Viewsetup id: " + viewId.getViewSetupId() + "\n";
            }
        } else {
            text = text + "No missing views\n";
        }
        new SimpleInfoBox("Information", text);
    }
}

