/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.NamedEntity;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class ViewSetupTableModel<AS extends AbstractSpimData<?>>
extends AbstractTableModel {
    private static final long serialVersionUID = -6526338840427674269L;
    protected ArrayList<BasicViewDescription<? extends BasicViewSetup>> elements = null;
    final ViewSetupExplorerPanel<AS, ?> panel;
    final ArrayList<String> columnNames;
    final int registrationColumn;
    final int interestPointsColumn;
    final ViewRegistrations viewRegistrations;
    final ViewInterestPoints viewInterestPoints;

    public int registrationColumn() {
        return this.registrationColumn;
    }

    public int interestPointsColumn() {
        return this.interestPointsColumn;
    }

    public ViewSetupTableModel(ViewSetupExplorerPanel<AS, ?> panel) {
        this.panel = panel;
        this.columnNames = new ArrayList();
        this.columnNames.add("Timepoint");
        this.columnNames.add("View Id");
        this.columnNames.addAll(((BasicViewSetup)panel.getSpimData().getSequenceDescription().getViewSetupsOrdered().get(0)).getAttributes().keySet());
        this.columnNames.add("#Registrations");
        this.registrationColumn = this.columnNames.size() - 1;
        this.viewRegistrations = panel.getSpimData().getViewRegistrations();
        if (SpimData2.class.isInstance(panel.getSpimData())) {
            SpimData2 data2 = (SpimData2)((Object)panel.getSpimData());
            this.columnNames.add("#InterestPoints");
            this.interestPointsColumn = this.columnNames.size() - 1;
            this.viewInterestPoints = data2.getViewInterestPoints();
        } else {
            this.viewInterestPoints = null;
            this.interestPointsColumn = -1;
        }
    }

    protected ArrayList<BasicViewDescription<? extends BasicViewSetup>> elements() {
        ArrayList<BasicViewDescription> elementsNew = new ArrayList<BasicViewDescription>();
        for (TimePoint t : this.panel.getSpimData().getSequenceDescription().getTimePoints().getTimePointsOrdered()) {
            for (BasicViewSetup v : this.panel.getSpimData().getSequenceDescription().getViewSetupsOrdered()) {
                ViewId viewId = new ViewId(t.getId(), v.getId());
                BasicViewDescription viewDesc = (BasicViewDescription)this.panel.getSpimData().getSequenceDescription().getViewDescriptions().get(viewId);
                if (!viewDesc.isPresent()) continue;
                elementsNew.add(viewDesc);
            }
        }
        if (this.elements == null || this.elements.size() != elementsNew.size()) {
            this.elements = elementsNew;
        }
        return this.elements;
    }

    public void sortByColumn(final int column) {
        Collections.sort(this.elements(), new Comparator<BasicViewDescription<? extends BasicViewSetup>>(){

            @Override
            public int compare(BasicViewDescription<? extends BasicViewSetup> arg0, BasicViewDescription<? extends BasicViewSetup> arg1) {
                if (column == 0) {
                    int diff = arg0.getTimePointId() - arg1.getTimePointId();
                    return diff == 0 ? arg0.getViewSetupId() - arg1.getViewSetupId() : diff;
                }
                if (column == 1) {
                    int diff = arg0.getViewSetupId() - arg1.getViewSetupId();
                    return diff == 0 ? arg0.getTimePointId() - arg1.getTimePointId() : diff;
                }
                if (column == ViewSetupTableModel.this.registrationColumn) {
                    int diff1 = ViewSetupTableModel.this.viewRegistrations.getViewRegistration(arg0).getTransformList().size() - ViewSetupTableModel.this.viewRegistrations.getViewRegistration(arg1).getTransformList().size();
                    int diff2 = arg0.getTimePointId() - arg1.getTimePointId();
                    return diff1 == 0 ? (diff2 == 0 ? arg0.getViewSetupId() - arg1.getViewSetupId() : diff2) : diff1;
                }
                if (column == ViewSetupTableModel.this.interestPointsColumn && ViewSetupTableModel.this.viewInterestPoints != null) {
                    int diff1 = ViewSetupTableModel.this.viewInterestPoints.getViewInterestPointLists((ViewId)arg0).getHashMap().keySet().size() - ViewSetupTableModel.this.viewInterestPoints.getViewInterestPointLists((ViewId)arg1).getHashMap().keySet().size();
                    int diff2 = arg0.getTimePointId() - arg1.getTimePointId();
                    return diff1 == 0 ? (diff2 == 0 ? arg0.getViewSetupId() - arg1.getViewSetupId() : diff2) : diff1;
                }
                int diff1 = ((Entity)arg0.getViewSetup().getAttributes().get(ViewSetupTableModel.this.columnNames.get(column))).getId() - ((Entity)arg1.getViewSetup().getAttributes().get(ViewSetupTableModel.this.columnNames.get(column))).getId();
                int diff2 = arg0.getViewSetupId() - arg1.getViewSetupId();
                return diff1 == 0 ? (diff2 == 0 ? arg0.getTimePointId() - arg1.getTimePointId() : diff2) : diff1;
            }
        });
        this.fireTableDataChanged();
    }

    public ArrayList<BasicViewDescription<? extends BasicViewSetup>> getElements() {
        return this.elements();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.elements().size();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        BasicViewDescription<BasicViewSetup> vd = this.elements().get(row);
        if (column == 0) {
            return vd.getTimePoint().getId();
        }
        if (column == 1) {
            return vd.getViewSetupId();
        }
        if (column == this.registrationColumn) {
            return this.viewRegistrations.getViewRegistration(vd).getTransformList().size();
        }
        if (column == this.interestPointsColumn && this.viewInterestPoints != null) {
            return this.viewInterestPoints.getViewInterestPointLists((ViewId)vd).getHashMap().keySet().size();
        }
        Entity e = (Entity)vd.getViewSetup().getAttributes().get(this.columnNames.get(column));
        if (e instanceof NamedEntity) {
            return ((NamedEntity)e).getName() + " (id = " + e.getId() + ")";
        }
        return e.getId() + " (no name available)";
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }
}

