/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.interestpoint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.spimdata.explorer.ViewSetupExplorer;
import spim.fiji.spimdata.explorer.interestpoint.InterestPointTableModel;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class InterestPointExplorerPanel
extends JPanel {
    private static final long serialVersionUID = -3767947754096099774L;
    final ViewSetupExplorer<?, ?> viewSetupExplorer;
    protected JTable table;
    protected InterestPointTableModel tableModel;
    protected JLabel label;
    protected ArrayList<Pair<InterestPointList, ViewId>> delete = new ArrayList();

    public InterestPointExplorerPanel(ViewInterestPoints viewInterestPoints, ViewSetupExplorer<?, ?> viewSetupExplorer) {
        this.viewSetupExplorer = viewSetupExplorer;
        this.initComponent(viewInterestPoints);
    }

    public InterestPointTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public void updateViewDescription(BasicViewDescription<?> vd, boolean isFirst) {
        if (vd != null && this.label != null) {
            this.label.setText("View Description --- Timepoint: " + vd.getTimePointId() + ", View Setup Id: " + vd.getViewSetupId());
        }
        if (vd == null) {
            this.label.setText("No or multiple View Descriptions selected");
        }
        this.tableModel.updateViewDescription(vd, isFirst);
        if (this.table.getSelectedRowCount() == 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void initComponent(ViewInterestPoints viewInterestPoints) {
        this.tableModel = new InterestPointTableModel(viewInterestPoints, this);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setSelectionMode(1);
        MyRenderer myRenderer = new MyRenderer();
        myRenderer.setHorizontalAlignment(0);
        for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
            this.table.getColumnModel().getColumn(column).setCellRenderer(myRenderer);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(1020, 300));
        Font f = this.table.getFont();
        this.table.setFont(new Font(f.getName(), f.getStyle(), 11));
        this.setLayout(new BorderLayout());
        this.label = new JLabel("View Description --- ");
        this.add((Component)this.label, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(5);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(400);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = InterestPointExplorerPanel.this.table.rowAtPoint(e.getPoint());
                int col = InterestPointExplorerPanel.this.table.columnAtPoint(e.getPoint());
                if (InterestPointExplorerPanel.this.tableModel.getSelectedRow() == row && InterestPointExplorerPanel.this.tableModel.getSelectedCol() == col) {
                    InterestPointExplorerPanel.this.tableModel.setSelected(-1, -1);
                } else {
                    InterestPointExplorerPanel.this.tableModel.setSelected(row, col);
                }
                int sr = InterestPointExplorerPanel.this.table.getSelectedRow();
                InterestPointExplorerPanel.this.tableModel.fireTableDataChanged();
                InterestPointExplorerPanel.this.table.setRowSelectionInterval(sr, sr);
            }
        });
        this.addPopupMenu(this.table);
    }

    protected void delete() {
        if (this.table.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.table, "Nothing selected.");
            return;
        }
        BasicViewDescription<?> vd = this.tableModel.getCurrentViewDescription();
        if (vd == null) {
            JOptionPane.showMessageDialog(this.table, "No active viewdescription.");
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        Arrays.sort(selectedRows);
        ViewInterestPoints vip = this.tableModel.getViewInterestPoints();
        for (int rowIndex = selectedRows.length - 1; rowIndex >= 0; --rowIndex) {
            int row = selectedRows[rowIndex];
            String label = InterestPointTableModel.label(vip, vd, row);
            IOFunctions.println("Removing label '' for timepoint_id " + vd.getTimePointId() + " viewsetup_id " + vd.getViewSetupId() + " -- Parsing through all correspondences to remove any links to this interest point list.");
            List<CorrespondingInterestPoints> correspondencesList = this.getCorrespondingInterestPoints(vip, (ViewId)vd, label);
            Collections.sort(correspondencesList);
            ViewId lastViewIdCorr = null;
            List<CorrespondingInterestPoints> cList = null;
            int size = 0;
            block1: for (CorrespondingInterestPoints pair : correspondencesList) {
                ViewId viewIdCorr = pair.getCorrespondingViewId();
                String labelCorr = pair.getCorrespodingLabel();
                int idCorr = pair.getCorrespondingDetectionId();
                if (lastViewIdCorr == null || !lastViewIdCorr.equals((Object)viewIdCorr)) {
                    if (lastViewIdCorr != null) {
                        IOFunctions.println("Correspondences: " + size + " >>> " + cList.size());
                    }
                    IOFunctions.println("Removing correspondences in timepointid=" + viewIdCorr.getTimePointId() + ", viewid=" + viewIdCorr.getViewSetupId());
                    lastViewIdCorr = viewIdCorr;
                    cList = this.getCorrespondingInterestPoints(vip, viewIdCorr, labelCorr);
                    size = cList.size();
                }
                for (int i = 0; i < cList.size(); ++i) {
                    CorrespondingInterestPoints cc = (CorrespondingInterestPoints)cList.get(i);
                    if (cc.getDetectionId() != idCorr || cc.getCorrespondingDetectionId() != pair.getDetectionId() || !cc.getCorrespondingViewId().equals(vd)) continue;
                    cList.remove(i);
                    continue block1;
                }
            }
            if (lastViewIdCorr != null) {
                IOFunctions.println("Correspondences: " + size + " >>> " + cList.size());
            }
            this.delete.add((Pair<InterestPointList, ViewId>)new ValuePair((Object)vip.getViewInterestPointLists((ViewId)vd).getInterestPointList(label), vd));
            vip.getViewInterestPointLists((ViewId)vd).getHashMap().remove(label);
        }
        this.tableModel.setSelected(-1, -1);
        this.tableModel.fireTableDataChanged();
    }

    public List<InterestPoint> getInterestPoints(ViewInterestPoints vip, ViewId v, String label) {
        InterestPointList ipList = vip.getViewInterestPointLists(v).getInterestPointList(label);
        List<InterestPoint> list = ipList.getInterestPoints();
        if (list == null) {
            ipList.loadInterestPoints();
            list = ipList.getInterestPoints();
        }
        return list;
    }

    public List<CorrespondingInterestPoints> getCorrespondingInterestPoints(ViewInterestPoints vip, ViewId v, String label) {
        InterestPointList ipList = vip.getViewInterestPointLists(v).getInterestPointList(label);
        List<CorrespondingInterestPoints> correspondencesList = ipList.getCorrespondingInterestPoints();
        if (correspondencesList == null) {
            ipList.loadCorrespondingInterestPoints();
            correspondencesList = ipList.getCorrespondingInterestPoints();
        }
        return correspondencesList;
    }

    protected void addPopupMenu(JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("Delete");
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterestPointExplorerPanel.this.delete();
                System.out.println("Right-click performed on table and choose DELETE");
            }
        });
        popupMenu.add(deleteItem);
        table.setComponentPopupMenu(popupMenu);
    }

    protected static class MyRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Color backgroundColor = this.getBackground();

        protected MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            InterestPointTableModel model = (InterestPointTableModel)table.getModel();
            if (model.getState(row, column)) {
                c.setBackground(Color.red);
            } else if (!isSelected) {
                c.setBackground(this.backgroundColor);
            }
            return c;
        }
    }
}

