/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import spim.fiji.datasetmanager.MicroManager;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;
import spim.fiji.spimdata.imgloaders.MultipageTiffReader;

public class LegacyMicroManagerImgLoader
extends AbstractImgLoader {
    final File mmFile;
    final AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?> sequenceDescription;

    public LegacyMicroManagerImgLoader(File mmFile, AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?> sequenceDescription) {
        this.mmFile = mmFile;
        this.sequenceDescription = sequenceDescription;
    }

    public File getFile() {
        return this.mmFile;
    }

    public static final <T extends RealType<T> & NativeType<T>> void populateImage(ArrayImg<T, ?> img, BasicViewDescription<?> vd, MultipageTiffReader r) {
        ArrayCursor cursor = img.cursor();
        int t = vd.getTimePoint().getId();
        int a = ((Angle)vd.getViewSetup().getAttribute(Angle.class)).getId();
        int c = ((Channel)vd.getViewSetup().getAttribute(Channel.class)).getId();
        int i = ((Illumination)vd.getViewSetup().getAttribute(Illumination.class)).getId();
        int countDroppedFrames = 0;
        ArrayList<Integer> slices = null;
        for (int z = 0; z < r.depth(); ++z) {
            String label = MultipageTiffReader.generateLabel(r.interleavedId(c, a), z, t, i);
            Pair<Object, HashMap<String, Object>> result = r.readImage(label);
            if (result == null) {
                ++countDroppedFrames;
                if (slices == null) {
                    slices = new ArrayList<Integer>();
                }
                slices.add(z);
                int j = 0;
                while ((long)j < img.dimension(0) * img.dimension(1)) {
                    cursor.next();
                    ++j;
                }
                continue;
            }
            Object o = result.getA();
            if (o instanceof byte[]) {
                for (byte b : (byte[])o) {
                    ((RealType)cursor.next()).setReal((float)UnsignedByteType.getUnsignedByte((byte)b));
                }
                continue;
            }
            for (short s : (short[])o) {
                ((RealType)cursor.next()).setReal((float)UnsignedShortType.getUnsignedShort((short)s));
            }
        }
        if (countDroppedFrames > 0) {
            IOFunctions.printlnSafe("(" + new Date(System.currentTimeMillis()) + "): WARNING!!! " + countDroppedFrames + " DROPPED FRAME(s) in timepoint=" + t + " viewsetup=" + vd.getViewSetupId() + " following slices:");
            Iterator iterator = slices.iterator();
            while (iterator.hasNext()) {
                int z = (Integer)iterator.next();
                IOFunctions.printlnSafe("(" + new Date(System.currentTimeMillis()) + "): slice=" + z);
            }
        }
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        try {
            MultipageTiffReader r = new MultipageTiffReader(this.mmFile);
            ArrayImg img = ArrayImgs.floats((long[])new long[]{r.width(), r.height(), r.depth()});
            BasicViewDescription vd = (BasicViewDescription)this.sequenceDescription.getViewDescriptions().get(view);
            LegacyMicroManagerImgLoader.populateImage(img, vd, r);
            if (normalize) {
                LegacyMicroManagerImgLoader.normalize((Img<FloatType>)img);
            }
            this.updateMetaDataCache(view, r.width(), r.height(), r.depth(), r.calX(), r.calY(), r.calZ());
            r.close();
            return img;
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to load viewsetup=" + view.getViewSetupId() + " timepoint=" + view.getTimePointId() + ": " + e);
            e.printStackTrace();
            return null;
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        try {
            MultipageTiffReader r = new MultipageTiffReader(this.mmFile);
            ArrayImg img = ArrayImgs.unsignedShorts((long[])new long[]{r.width(), r.height(), r.depth()});
            BasicViewDescription vd = (BasicViewDescription)this.sequenceDescription.getViewDescriptions().get(view);
            LegacyMicroManagerImgLoader.populateImage(img, vd, r);
            this.updateMetaDataCache(view, r.width(), r.height(), r.depth(), r.calX(), r.calY(), r.calZ());
            r.close();
            return img;
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to load viewsetup=" + view.getViewSetupId() + " timepoint=" + view.getTimePointId() + ": " + e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void loadMetaData(ViewId view) {
        try {
            MultipageTiffReader r = new MultipageTiffReader(this.mmFile);
            this.updateMetaDataCache(view, r.width(), r.height(), r.depth(), r.calX(), r.calY(), r.calZ());
            r.close();
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to load metadata for viewsetup=" + view.getViewSetupId() + " timepoint=" + view.getTimePointId() + ": " + e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return new MicroManager().getTitle() + ", ImgFactory=ArrayImgFactory";
    }
}

